/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole.model;

import com.alibaba.druid.support.jconsole.model.ColumnGroup;
import com.alibaba.druid.support.jconsole.model.GroupableTableHeaderUI;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GroupableTableHeader
extends JTableHeader {
    private static final long serialVersionUID = 1L;
    protected Vector<ColumnGroup> columnGroups;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setUI(new GroupableTableHeaderUI());
        this.setReorderingAllowed(false);
        this.setRequestFocusEnabled(false);
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(g);
    }

    public void clearColumnGroups() {
        this.columnGroups = null;
    }

    public ColumnGroup[] getColumnGroups() {
        Object[] retg = null;
        if (this.columnGroups.size() > 0) {
            retg = new ColumnGroup[this.columnGroups.size()];
            this.columnGroups.copyInto(retg);
        }
        return retg;
    }

    public Enumeration<ColumnGroup> getColumnGroups(TableColumn col) {
        if (this.columnGroups == null) {
            return null;
        }
        Enumeration<ColumnGroup> enum1 = this.columnGroups.elements();
        while (enum1.hasMoreElements()) {
            ColumnGroup cGroup = enum1.nextElement();
            Vector<ColumnGroup> v_ret = cGroup.getColumnGroups(col, new Vector<ColumnGroup>());
            if (v_ret == null) continue;
            return v_ret.elements();
        }
        return null;
    }

    @Override
    public boolean isFocusTraversable() {
        return super.isFocusable() && this.isRequestFocusEnabled();
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration<ColumnGroup> enum1 = this.columnGroups.elements();
        while (enum1.hasMoreElements()) {
            ColumnGroup cGroup = enum1.nextElement();
            cGroup.setColumnMargin(columnMargin);
        }
    }

    @Override
    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = b;
    }
}

