/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.sd;

import com.authlete.sd.CollectionUtility;
import com.authlete.sd.SDConstants;
import com.google.gson.Gson;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;

final class SDUtility {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final Gson GSON = new Gson();

    SDUtility() {
    }

    public static byte[] fromBase64url(String input) {
        return Base64.getUrlDecoder().decode(input);
    }

    public static String toBase64url(byte[] input) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(input);
    }

    public static <T> T fromJson(String input, Class<T> klass) {
        return (T)GSON.fromJson(input, klass);
    }

    public static String toJson(Object input) {
        return GSON.toJson(input);
    }

    public static String fromUTF8Bytes(byte[] input) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(input);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        try {
            return decoder.decode(byteBuffer).toString();
        }
        catch (CharacterCodingException cause) {
            throw new IllegalArgumentException("Invalid UTF-8 byte sequence.", cause);
        }
    }

    public static byte[] toUTF8Bytes(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] computeDigest(String hashAlgorithm, byte[] input) {
        try {
            return MessageDigest.getInstance(hashAlgorithm).digest(input);
        }
        catch (NoSuchAlgorithmException cause) {
            String message = String.format("The hash algorithm '%s' is not supported.", hashAlgorithm);
            throw new IllegalArgumentException(message, cause);
        }
    }

    public static String computeDigest(String hashAlgorithm, String input) {
        byte[] digest = SDUtility.computeDigest(hashAlgorithm, SDUtility.toUTF8Bytes(input));
        return SDUtility.toBase64url(digest);
    }

    public static byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static String generateRandomDigest(String hashAlgorithm) {
        byte[] input = SDUtility.generateRandomBytes(64);
        byte[] digest = SDUtility.computeDigest(hashAlgorithm, input);
        return SDUtility.toBase64url(digest);
    }

    public static boolean isReservedKey(String key) {
        return SDConstants.RESERVED_KEYS.contains(key);
    }

    public static Map<String, Object> generateDecoyArrayElement(String hashAlgorithm) {
        String digest = SDUtility.generateRandomDigest(hashAlgorithm);
        return CollectionUtility.mapOf("...", digest);
    }
}

