/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonWriter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonReader
implements Closeable {
    private static final int STATE_READ_START_OBJECT = 0;
    private static final int STATE_READ_FIELD = 1;
    private static final int STATE_READ_VALUE = 2;
    private static final int STATE_READ_POST_VALUE = 3;
    private static final String EMPTY_ARRAY = "~!a~";
    private static final String EMPTY_OBJECT = "~!o~";
    private static final Character[] _charCache;
    private static final Byte[] _byteCache;
    private static final Map<String, String> _stringCache;
    private static final Set<Class> _prims;
    private static final Map<Class, Object[]> _constructors;
    private static final Map<String, Class> _nameToClass;
    private static final Class[] _emptyClassArray;
    private static final List<Object[]> _readers;
    private static final Set<Class> _notCustom;
    private static final Map<String, String> _months;
    private static final Map<Class, ClassFactory> _factory;
    private static final Pattern _datePattern1;
    private static final Pattern _datePattern2;
    private static final Pattern _datePattern3;
    private static final Pattern _datePattern4;
    private static final Pattern _timePattern1;
    private static final Pattern _timePattern2;
    private static final Pattern _timePattern3;
    private static final Pattern _extraQuotes;
    private final Map<Long, JsonObject> _objsRead = new LinkedHashMap<Long, JsonObject>();
    private final Collection<UnresolvedReference> _unresolvedRefs = new ArrayList<UnresolvedReference>();
    private final Collection<Object[]> _prettyMaps = new ArrayList<Object[]>();
    private final FastPushbackReader _in;
    private boolean _noObjects = false;
    private final char[] _numBuf = new char[256];
    private final StringBuilder _strBuf = new StringBuilder();
    static final ThreadLocal<Deque<char[]>> _snippet;
    static final ThreadLocal<Integer> _line;
    static final ThreadLocal<Integer> _col;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MIN_HIGH_SURROGATE = '\ud800';

    public static void assignInstantiator(Class c, ClassFactory factory) {
        _factory.put(c, factory);
    }

    public static void addReader(Class c, JsonClassReader reader) {
        for (Object[] item : _readers) {
            Class clz = (Class)item[0];
            if (clz != c) continue;
            item[1] = reader;
            return;
        }
        _readers.add(new Object[]{c, reader});
    }

    public static void addNotCustomReader(Class c) {
        _notCustom.add(c);
    }

    protected Object readIfMatching(Object o, Class compType, LinkedList<JsonObject<String, Object>> stack) throws IOException {
        Class c;
        if (o == null) {
            JsonReader.error("Bug in json-io, null must be checked before calling this method.");
        }
        if (_notCustom.contains(o.getClass())) {
            return null;
        }
        if (compType != null && _notCustom.contains(compType)) {
            return null;
        }
        boolean isJsonObject = o instanceof JsonObject;
        if (!isJsonObject && compType == null) {
            return null;
        }
        boolean needsType = false;
        if (isJsonObject) {
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("@ref")) {
                return null;
            }
            if (jObj.target == null) {
                String typeStr = null;
                try {
                    String type = jObj.type;
                    if (type != null) {
                        typeStr = type;
                        c = JsonReader.classForName(type);
                    }
                    if (compType != null) {
                        c = compType;
                        needsType = true;
                    }
                    return null;
                }
                catch (Exception e) {
                    return JsonReader.error("Class listed in @type [" + typeStr + "] is not found", e);
                }
            } else {
                c = jObj.target.getClass();
            }
        } else {
            c = compType;
        }
        JsonClassReader closestReader = null;
        int minDistance = Integer.MAX_VALUE;
        for (Object[] item : _readers) {
            Class clz = (Class)item[0];
            if (clz == c) {
                closestReader = (JsonClassReader)item[1];
                break;
            }
            int distance = JsonWriter.getDistance(clz, c);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestReader = (JsonClassReader)item[1];
        }
        if (closestReader == null) {
            return null;
        }
        if (needsType && isJsonObject) {
            ((JsonObject)o).setType(c.getName());
        }
        return closestReader.read(o, stack);
    }

    @Deprecated
    public static Object toJava(String json) {
        throw new RuntimeException("Use com.cedarsoftware.util.JsonReader");
    }

    public static Object jsonToJava(String json) throws IOException {
        ByteArrayInputStream ba = new ByteArrayInputStream(json.getBytes("UTF-8"));
        JsonReader jr = new JsonReader(ba, false);
        Object obj = jr.readObject();
        jr.close();
        return obj;
    }

    @Deprecated
    public static Map toMaps(String json) {
        try {
            return JsonReader.jsonToMaps(json);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Map jsonToMaps(String json) throws IOException {
        ByteArrayInputStream ba = new ByteArrayInputStream(json.getBytes("UTF-8"));
        JsonReader jr = new JsonReader(ba, true);
        Map map = (Map)jr.readObject();
        jr.close();
        return map;
    }

    public JsonReader() {
        this._noObjects = false;
        this._in = null;
    }

    public JsonReader(InputStream in) {
        this(in, false);
    }

    public JsonReader(InputStream in, boolean noObjects) {
        this._noObjects = noObjects;
        try {
            this._in = new FastPushbackReader((Reader)new BufferedReader(new InputStreamReader(in, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Your JVM does not support UTF-8.  Get a new JVM.", e);
        }
    }

    public Object readObject() throws IOException {
        Object o = this.readJsonObject();
        if (o == EMPTY_OBJECT) {
            return new JsonObject();
        }
        Object graph = this.convertParsedMapsToJava((JsonObject)o);
        if (this._noObjects) {
            return o;
        }
        return graph;
    }

    public Object jsonObjectsToJava(JsonObject root) throws IOException {
        this._noObjects = false;
        return this.convertParsedMapsToJava(root);
    }

    private Object convertParsedMapsToJava(JsonObject root) throws IOException {
        this.createJavaObjectInstance(Object.class, root);
        Object graph = this.convertMapsToObjects(root);
        this.patchUnresolvedReferences();
        this.rehashMaps();
        this._objsRead.clear();
        this._unresolvedRefs.clear();
        this._prettyMaps.clear();
        return graph;
    }

    private Object convertMapsToObjects(JsonObject<String, Object> root) throws IOException {
        LinkedList<JsonObject<String, Object>> stack = new LinkedList<JsonObject<String, Object>>();
        stack.addFirst(root);
        boolean useMaps = this._noObjects;
        while (!stack.isEmpty()) {
            JsonObject jsonObj = (JsonObject)stack.removeFirst();
            if (useMaps) {
                if (jsonObj.isArray() || jsonObj.isCollection()) {
                    this.traverseCollectionNoObj(stack, jsonObj);
                    continue;
                }
                if (jsonObj.isMap()) {
                    this.traverseMap(stack, jsonObj);
                    continue;
                }
                this.traverseFieldsNoObj(stack, jsonObj);
                continue;
            }
            if (jsonObj.isArray()) {
                this.traverseArray(stack, jsonObj);
            } else if (jsonObj.isCollection()) {
                this.traverseCollection(stack, jsonObj);
            } else if (jsonObj.isMap()) {
                this.traverseMap(stack, jsonObj);
            } else {
                this.traverseFields(stack, jsonObj);
            }
            jsonObj.clear();
        }
        return root.target;
    }

    private void traverseArray(LinkedList<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) throws IOException {
        int len = jsonObj.getLength();
        if (len == 0) {
            return;
        }
        Class compType = jsonObj.getComponentType();
        if (Character.TYPE == compType) {
            return;
        }
        if (Byte.TYPE == compType) {
            jsonObj.moveBytesToMate();
            jsonObj.clearArray();
            return;
        }
        boolean isPrimitive = JsonReader.isPrimitive(compType);
        Object array = jsonObj.target;
        Object[] items = jsonObj.getArray();
        for (int i = 0; i < len; ++i) {
            JsonObject<String, Object> jsonObject;
            Object element = items[i];
            if (element == null) {
                Array.set(array, i, null);
                continue;
            }
            if (element == EMPTY_OBJECT) {
                Object arrayElement = this.createJavaObjectInstance(compType, new JsonObject());
                Array.set(array, i, arrayElement);
                continue;
            }
            Object special = this.readIfMatching(element, compType, stack);
            if (special != null) {
                Array.set(array, i, special);
                continue;
            }
            if (isPrimitive) {
                Array.set(array, i, JsonReader.newPrimitiveWrapper(compType, element));
                continue;
            }
            if (element.getClass().isArray()) {
                if (char[].class == compType) {
                    Object[] jsonArray = (Object[])element;
                    if (jsonArray.length == 0) {
                        Array.set(array, i, new char[0]);
                        continue;
                    }
                    String value = (String)jsonArray[0];
                    int numChars = value.length();
                    char[] chars = new char[numChars];
                    for (int j = 0; j < numChars; ++j) {
                        chars[j] = value.charAt(j);
                    }
                    Array.set(array, i, chars);
                    continue;
                }
                jsonObject = new JsonObject<String, Object>();
                jsonObject.put("@items", element);
                Array.set(array, i, this.createJavaObjectInstance(compType, jsonObject));
                stack.addFirst(jsonObject);
                continue;
            }
            if (element instanceof JsonObject) {
                jsonObject = (JsonObject<String, Object>)element;
                Long ref = (Long)jsonObject.get("@ref");
                if (ref != null) {
                    JsonObject refObject = this._objsRead.get(ref);
                    if (refObject == null) {
                        JsonReader.error("Forward reference @ref: " + ref + ", but no object defined (@id) with that value");
                    }
                    if (refObject.target != null) {
                        Array.set(array, i, refObject.target);
                        continue;
                    }
                    this._unresolvedRefs.add(new UnresolvedReference(jsonObj, i, (long)ref));
                    continue;
                }
                Object arrayElement = this.createJavaObjectInstance(compType, jsonObject);
                Array.set(array, i, arrayElement);
                if (JsonReader.isPrimitive(arrayElement.getClass())) continue;
                stack.addFirst(jsonObject);
                continue;
            }
            Array.set(array, i, element);
        }
        jsonObj.clearArray();
    }

    private void traverseCollectionNoObj(LinkedList<JsonObject<String, Object>> stack, JsonObject jsonObj) throws IOException {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return;
        }
        int idx = 0;
        ArrayList<Object> copy = new ArrayList<Object>(items.length);
        for (Object element : items) {
            JsonObject jsonObject;
            if (element == EMPTY_OBJECT) {
                copy.add(new JsonObject());
                continue;
            }
            copy.add(element);
            if (element instanceof Object[]) {
                jsonObject = new JsonObject();
                jsonObject.put("@items", element);
                stack.addFirst(jsonObject);
            } else if (element instanceof JsonObject) {
                jsonObject = (JsonObject)element;
                Long ref = (Long)jsonObject.get("@ref");
                if (ref != null) {
                    JsonObject refObject = this._objsRead.get(ref);
                    if (refObject == null) {
                        JsonReader.error("Forward reference @ref: " + ref + ", but no object defined (@id) with that value");
                    }
                    copy.set(idx, refObject);
                } else {
                    stack.addFirst(jsonObject);
                }
            }
            ++idx;
        }
        jsonObj.target = null;
        for (int i = 0; i < items.length; ++i) {
            items[i] = copy.get(i);
        }
    }

    private void traverseCollection(LinkedList<JsonObject<String, Object>> stack, JsonObject jsonObj) throws IOException {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return;
        }
        Collection col = (Collection)jsonObj.target;
        boolean isList = col instanceof List;
        int idx = 0;
        for (Object element : items) {
            if (element == null) {
                col.add(null);
            } else if (element == EMPTY_OBJECT) {
                col.add(new JsonObject());
            } else {
                JsonObject<String, Object> jObj;
                Object special = this.readIfMatching(element, null, stack);
                if (special != null) {
                    col.add(special);
                } else if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                    col.add(element);
                } else if (element.getClass().isArray()) {
                    jObj = new JsonObject<String, Object>();
                    jObj.put("@items", element);
                    this.createJavaObjectInstance(Object.class, jObj);
                    col.add(jObj.target);
                    this.convertMapsToObjects(jObj);
                } else {
                    jObj = (JsonObject<String, Object>)element;
                    Long ref = (Long)jObj.get("@ref");
                    if (ref != null) {
                        JsonObject refObject = this._objsRead.get(ref);
                        if (refObject == null) {
                            JsonReader.error("Forward reference @ref: " + ref + ", but no object defined (@id) with that value");
                        }
                        if (refObject.target != null) {
                            col.add(refObject.target);
                        } else {
                            this._unresolvedRefs.add(new UnresolvedReference(jsonObj, idx, (long)ref));
                            if (isList) {
                                col.add(null);
                            }
                        }
                    } else {
                        this.createJavaObjectInstance(Object.class, jObj);
                        if (!JsonReader.isPrimitive(jObj.getTargetClass())) {
                            this.convertMapsToObjects(jObj);
                        }
                        col.add(jObj.target);
                    }
                }
            }
            ++idx;
        }
        jsonObj.remove("@items");
    }

    private void traverseMap(LinkedList<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) throws IOException {
        Object[] javaValues;
        Object[] javaKeys;
        this.convertMapToKeysItems(jsonObj);
        Object[] keys = (Object[])jsonObj.get("@keys");
        Object[] items = jsonObj.getArray();
        if (keys == null || items == null) {
            if (keys != items) {
                JsonReader.error("Map written where one of @keys or @items is empty");
            }
            return;
        }
        int size = keys.length;
        if (size != items.length) {
            JsonReader.error("Map written with @keys and @items entries of different sizes");
        }
        JsonObject<String, Object[]> jsonKeyCollection = new JsonObject<String, Object[]>();
        jsonKeyCollection.put("@items", keys);
        jsonKeyCollection.target = javaKeys = new Object[size];
        stack.addFirst(jsonKeyCollection);
        JsonObject<String, Object[]> jsonItemCollection = new JsonObject<String, Object[]>();
        jsonItemCollection.put("@items", items);
        jsonItemCollection.target = javaValues = new Object[size];
        stack.addFirst(jsonItemCollection);
        this._prettyMaps.add(new Object[]{jsonObj, javaKeys, javaValues});
    }

    private void traverseFieldsNoObj(LinkedList<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) throws IOException {
        Object target = jsonObj.target;
        for (Map.Entry e : jsonObj.entrySet()) {
            Object value;
            String key = (String)e.getKey();
            if (key.charAt(0) == '@') continue;
            Field field = null;
            if (target != null) {
                field = JsonReader.getDeclaredField(target.getClass(), key);
            }
            if ((value = e.getValue()) == null) {
                jsonObj.put(key, null);
                continue;
            }
            if (value == EMPTY_OBJECT) {
                jsonObj.put(key, new JsonObject());
                continue;
            }
            if (value.getClass().isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.put("@items", value);
                stack.addFirst(jsonArray);
                jsonObj.put(key, jsonArray);
                continue;
            }
            if (value instanceof JsonObject) {
                Long ref;
                JsonObject jObj = (JsonObject)value;
                if (field != null) {
                    if (JsonObject.isPrimitiveWrapper(field.getType())) {
                        jObj.put("value", JsonReader.newPrimitiveWrapper(field.getType(), jObj.get("value")));
                        continue;
                    }
                }
                if ((ref = (Long)jObj.get("@ref")) != null) {
                    JsonObject refObject = this._objsRead.get(ref);
                    if (refObject == null) {
                        JsonReader.error("Forward reference @ref: " + ref + ", but no object defined (@id) with that value");
                    }
                    jsonObj.put(key, refObject);
                    continue;
                }
                stack.addFirst(jObj);
                continue;
            }
            if (field == null) continue;
            Class<?> fieldType = field.getType();
            if (JsonReader.isPrimitive(fieldType)) {
                jsonObj.put(key, JsonReader.newPrimitiveWrapper(fieldType, value));
                continue;
            }
            if (BigDecimal.class == fieldType) {
                jsonObj.put(key, new BigDecimal(value.toString()));
                continue;
            }
            if (BigInteger.class != fieldType) continue;
            jsonObj.put(key, new BigInteger(value.toString()));
        }
        jsonObj.target = null;
    }

    private void traverseFields(LinkedList<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) throws IOException {
        Object special = this.readIfMatching(jsonObj, null, stack);
        if (special != null) {
            jsonObj.target = special;
            return;
        }
        Object javaMate = jsonObj.target;
        Iterator i = jsonObj.entrySet().iterator();
        Class<?> cls = javaMate.getClass();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            Field field = JsonReader.getDeclaredField(cls, key);
            Object rhs = e.getValue();
            if (field == null) continue;
            this.assignField(stack, jsonObj, field, rhs);
        }
        jsonObj.clear();
    }

    private void assignField(LinkedList<JsonObject<String, Object>> stack, JsonObject jsonObj, Field field, Object rhs) throws IOException {
        Object target = jsonObj.target;
        try {
            JsonObject jObj;
            Class<?> fieldType = field.getType();
            if (Collection.class.isAssignableFrom(fieldType)) {
                if (rhs instanceof JsonObject) {
                    JsonObject col = (JsonObject)rhs;
                    Object[] items = col.getArray();
                    this.markSubobjectTypes(field, items, 0);
                }
            } else if (Map.class.isAssignableFrom(fieldType) && rhs instanceof JsonObject) {
                JsonObject map = (JsonObject)rhs;
                this.convertMapToKeysItems(map);
                if (map.get("@keys") instanceof Object[]) {
                    Object[] keys = (Object[])map.get("@keys");
                    this.markSubobjectTypes(field, keys, 0);
                }
                if (map.get("@items") instanceof Object[]) {
                    Object[] values = (Object[])map.get("@items");
                    this.markSubobjectTypes(field, values, 1);
                }
            }
            if (rhs instanceof JsonObject) {
                JsonObject job = (JsonObject)rhs;
                String type = job.type;
                if (type == null || type.isEmpty()) {
                    job.setType(fieldType.getName());
                }
            }
            if (rhs == null) {
                field.set(target, null);
            } else if (rhs == EMPTY_OBJECT) {
                jObj = new JsonObject();
                jObj.type = fieldType.getName();
                Object value = this.createJavaObjectInstance(fieldType, jObj);
                field.set(target, value);
            } else {
                Object special = this.readIfMatching(rhs, field.getType(), stack);
                if (special != null) {
                    field.set(target, special);
                } else if (rhs.getClass().isArray()) {
                    Object[] elements = (Object[])rhs;
                    JsonObject<String, Object[]> jsonArray = new JsonObject<String, Object[]>();
                    if (char[].class == fieldType) {
                        if (elements.length == 0) {
                            field.set(target, new char[0]);
                        } else {
                            field.set(target, ((String)elements[0]).toCharArray());
                        }
                    } else {
                        jsonArray.put("@items", elements);
                        this.createJavaObjectInstance(fieldType, jsonArray);
                        field.set(target, jsonArray.target);
                        stack.addFirst(jsonArray);
                    }
                } else if (rhs instanceof JsonObject) {
                    jObj = (JsonObject)rhs;
                    Long ref = (Long)jObj.get("@ref");
                    if (ref != null) {
                        JsonObject refObject = this._objsRead.get(ref);
                        if (refObject == null) {
                            JsonReader.error("Forward reference @ref: " + ref + ", but no object defined (@id) with that value");
                        }
                        if (refObject.target != null) {
                            field.set(target, refObject.target);
                        } else {
                            this._unresolvedRefs.add(new UnresolvedReference(jsonObj, field.getName(), (long)ref));
                        }
                    } else {
                        field.set(target, this.createJavaObjectInstance(fieldType, jObj));
                        if (!JsonReader.isPrimitive(jObj.getTargetClass())) {
                            stack.addFirst((JsonObject)rhs);
                        }
                    }
                } else if (JsonReader.isPrimitive(fieldType)) {
                    field.set(target, JsonReader.newPrimitiveWrapper(fieldType, rhs));
                } else {
                    field.set(target, rhs);
                }
            }
        }
        catch (Exception e) {
            JsonReader.error("IllegalAccessException setting field '" + field.getName() + "' on target: " + target + " with value: " + rhs, e);
        }
    }

    private void convertMapToKeysItems(JsonObject map) {
        if (!map.containsKey("@keys") && !map.containsKey("@ref")) {
            Object[] keys = new Object[map.keySet().size()];
            Object[] values = new Object[map.keySet().size()];
            int i = 0;
            Iterator i$ = map.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry e;
                Map.Entry entry = e = i$.next();
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            String saveType = map.getType();
            map.clear();
            map.setType(saveType);
            map.put("@keys", keys);
            map.put("@items", values);
        }
    }

    private void markSubobjectTypes(Field field, Object[] items, int typeArg) {
        if (items == null || items.length == 0) {
            return;
        }
        for (Object o : items) {
            ParameterizedType paramType;
            Type[] typeArgs;
            JsonObject item;
            String type;
            if (!(o instanceof JsonObject) || (type = (item = (JsonObject)o).getType()) != null && !type.isEmpty() || !(field.getGenericType() instanceof ParameterizedType) || (typeArgs = (paramType = (ParameterizedType)field.getGenericType()).getActualTypeArguments()) == null || typeArgs.length <= typeArg || !(typeArgs[typeArg] instanceof Class)) continue;
            Class c = (Class)typeArgs[typeArg];
            item.setType(c.getName());
        }
    }

    private Object createJavaObjectInstance(Class clazz, JsonObject jsonObj) throws IOException {
        Object mate;
        String type = jsonObj.type;
        if (type != null) {
            Class c = JsonReader.classForName(type);
            if (c.isArray()) {
                int size;
                Object[] items = jsonObj.getArray();
                int n = size = items == null ? 0 : items.length;
                if (c == char[].class) {
                    jsonObj.moveCharsToMate();
                    mate = jsonObj.target;
                } else {
                    mate = Array.newInstance(c.getComponentType(), size);
                }
            } else {
                mate = JsonReader.isPrimitive(c) ? JsonReader.newPrimitiveWrapper(c, jsonObj.get("value")) : (c == Class.class ? JsonReader.classForName((String)jsonObj.get("value")) : (c.isEnum() ? JsonReader.getEnum(c, jsonObj) : (Enum.class.isAssignableFrom(c) ? JsonReader.getEnum(c.getSuperclass(), jsonObj) : ("java.util.Arrays$ArrayList".equals(c.getName()) ? new ArrayList() : JsonReader.newInstance(c)))));
            }
        } else {
            Object[] items = jsonObj.getArray();
            if (clazz.isArray() || items != null && clazz == Object.class && !jsonObj.containsKey("@keys")) {
                int size = items == null ? 0 : items.length;
                mate = Array.newInstance(clazz.isArray() ? clazz.getComponentType() : Object.class, size);
            } else {
                mate = clazz.isEnum() ? JsonReader.getEnum(clazz, jsonObj) : (Enum.class.isAssignableFrom(clazz) ? JsonReader.getEnum(clazz.getSuperclass(), jsonObj) : ("java.util.Arrays$ArrayList".equals(clazz.getName()) ? new ArrayList() : (clazz == Object.class && !this._noObjects ? (jsonObj.isMap() || jsonObj.size() > 0 ? new JsonObject() : JsonReader.newInstance(clazz)) : JsonReader.newInstance(clazz))));
            }
        }
        jsonObj.target = mate;
        return jsonObj.target;
    }

    private static Object getEnum(Class c, JsonObject jsonObj) {
        try {
            return Enum.valueOf(c, (String)jsonObj.get("name"));
        }
        catch (Exception e) {
            return Enum.valueOf(c, (String)jsonObj.get("java.lang.Enum.name"));
        }
    }

    private Object readJsonObject() throws IOException {
        boolean done = false;
        String field = null;
        JsonObject<String, Object> object = new JsonObject<String, Object>();
        int state = 0;
        boolean objectRead = false;
        FastPushbackReader in = this._in;
        while (!done) {
            switch (state) {
                case 0: {
                    int c = this.skipWhitespaceRead();
                    if (c == 123) {
                        objectRead = true;
                        object.line = _line.get();
                        object.col = _col.get();
                        c = this.skipWhitespaceRead();
                        if (c == 125) {
                            return EMPTY_OBJECT;
                        }
                        in.unread(c);
                        state = 1;
                        break;
                    }
                    if (c == 91) {
                        in.unread(91);
                        state = 2;
                        break;
                    }
                    JsonReader.error("Input is invalid JSON; does not start with '{' or '[', c=" + c);
                    break;
                }
                case 1: {
                    int c = this.skipWhitespaceRead();
                    if (c == 34) {
                        field = this.readString();
                        c = this.skipWhitespaceRead();
                        if (c != 58) {
                            JsonReader.error("Expected ':' between string field and value");
                        }
                        this.skipWhitespace();
                        state = 2;
                        break;
                    }
                    JsonReader.error("Expected quote");
                    break;
                }
                case 2: {
                    if (field == null) {
                        field = "@items";
                    }
                    Object value = this.readValue(object);
                    object.put(field, value);
                    if ("@id".equals(field)) {
                        this._objsRead.put((Long)value, object);
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    int c = this.skipWhitespaceRead();
                    if (c == -1 && objectRead) {
                        JsonReader.error("EOF reached before closing '}'");
                    }
                    if (c == 125 || c == -1) {
                        done = true;
                        break;
                    }
                    if (c == 44) {
                        state = 1;
                        break;
                    }
                    JsonReader.error("Object not ended with '}' or ']'");
                }
            }
        }
        if (this._noObjects && object.isPrimitive()) {
            return object.getPrimitiveValue();
        }
        return object;
    }

    private Object readValue(JsonObject object) throws IOException {
        int c = this._in.read();
        if (c == 34) {
            return this.readString();
        }
        if (JsonReader.isDigit(c) || c == 45) {
            return this.readNumber(c);
        }
        if (c == 123) {
            this._in.unread(123);
            return this.readJsonObject();
        }
        if (c == 116 || c == 84) {
            this._in.unread(c);
            this.readToken("true");
            return Boolean.TRUE;
        }
        if (c == 102 || c == 70) {
            this._in.unread(c);
            this.readToken("false");
            return Boolean.FALSE;
        }
        if (c == 110 || c == 78) {
            this._in.unread(c);
            this.readToken("null");
            return null;
        }
        if (c == 91) {
            return this.readArray(object);
        }
        if (c == 93) {
            this._in.unread(93);
            return EMPTY_ARRAY;
        }
        if (c == -1) {
            JsonReader.error("EOF reached prematurely");
        }
        return JsonReader.error("Unknown JSON value type");
    }

    private Object readArray(JsonObject object) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        while (true) {
            int c;
            this.skipWhitespace();
            Object o = this.readValue(object);
            if (o != EMPTY_ARRAY) {
                array.add(o);
            }
            if ((c = this.skipWhitespaceRead()) == 93) break;
            if (c == 44) continue;
            JsonReader.error("Expected ',' or ']' inside array");
        }
        return array.toArray();
    }

    private String readToken(String token) throws IOException {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            int c = this._in.read();
            if (c == -1) {
                JsonReader.error("EOF reached while reading token: " + token);
            }
            c = Character.toLowerCase((char)c);
            char loTokenChar = token.charAt(i);
            if (loTokenChar == c) continue;
            JsonReader.error("Expected token: " + token);
        }
        return token;
    }

    private Number readNumber(int c) throws IOException {
        int i;
        FastPushbackReader in = this._in;
        char[] numBuf = this._numBuf;
        numBuf[0] = (char)c;
        int len = 1;
        boolean isFloat = false;
        try {
            while (true) {
                if ((c = in.read()) >= 48 && c <= 57 || c == 45 || c == 43) {
                    numBuf[len++] = (char)c;
                    continue;
                }
                if (c == 46 || c == 101 || c == 69) {
                    numBuf[len++] = (char)c;
                    isFloat = true;
                    continue;
                }
                if (c != -1) break;
                JsonReader.error("Reached EOF while reading number");
            }
            in.unread(c);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JsonReader.error("Too many digits in number");
        }
        if (isFloat) {
            String num = new String(numBuf, 0, len);
            try {
                return Double.parseDouble(num);
            }
            catch (NumberFormatException e) {
                JsonReader.error("Invalid floating point number: " + num, e);
            }
        }
        boolean isNeg = numBuf[0] == '-';
        long n = 0L;
        int n2 = i = isNeg ? 1 : 0;
        while (i < len) {
            n = (long)(numBuf[i] - 48) + n * 10L;
            ++i;
        }
        return isNeg ? -n : n;
    }

    private String readString() throws IOException {
        StringBuilder strBuf = this._strBuf;
        strBuf.setLength(0);
        StringBuilder hex = new StringBuilder();
        boolean done = false;
        boolean STATE_STRING_START = false;
        boolean STATE_STRING_SLASH = true;
        int STATE_HEX_DIGITS = 2;
        int state = 0;
        while (!done) {
            int c = this._in.read();
            if (c == -1) {
                JsonReader.error("EOF reached while reading JSON string");
            }
            switch (state) {
                case 0: {
                    if (c == 92) {
                        state = 1;
                        break;
                    }
                    if (c == 34) {
                        done = true;
                        break;
                    }
                    strBuf.append(JsonReader.toChars(c));
                    break;
                }
                case 1: {
                    if (c == 110) {
                        strBuf.append('\n');
                    } else if (c == 114) {
                        strBuf.append('\r');
                    } else if (c == 116) {
                        strBuf.append('\t');
                    } else if (c == 102) {
                        strBuf.append('\f');
                    } else if (c == 98) {
                        strBuf.append('\b');
                    } else if (c == 92) {
                        strBuf.append('\\');
                    } else if (c == 47) {
                        strBuf.append('/');
                    } else if (c == 34) {
                        strBuf.append('\"');
                    } else if (c == 39) {
                        strBuf.append('\'');
                    } else {
                        if (c == 117) {
                            state = 2;
                            hex.setLength(0);
                            break;
                        }
                        JsonReader.error("Invalid character escape sequence specified");
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (c == 97 || c == 65 || c == 98 || c == 66 || c == 99 || c == 67 || c == 100 || c == 68 || c == 101 || c == 69 || c == 102 || c == 70 || JsonReader.isDigit(c)) {
                        hex.append((char)c);
                        if (hex.length() != 4) break;
                        int value = Integer.parseInt(hex.toString(), 16);
                        strBuf.append(JsonReader.valueOf((char)value));
                        state = 0;
                        break;
                    }
                    JsonReader.error("Expected hexadecimal digits");
                }
            }
        }
        String s = strBuf.toString();
        String cacheHit = _stringCache.get(s);
        return cacheHit == null ? s : cacheHit;
    }

    private static Object newInstance(Class c) throws IOException {
        if (_factory.containsKey(c)) {
            return _factory.get(c).newInstance(c);
        }
        Object[] constructorInfo = _constructors.get(c);
        if (constructorInfo != null) {
            Constructor constructor = (Constructor)constructorInfo[0];
            Boolean useNull = (Boolean)constructorInfo[1];
            Class[] paramTypes = constructor.getParameterTypes();
            if (paramTypes == null || paramTypes.length == 0) {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    JsonReader.error("Could not instantiate " + c.getName(), e);
                }
            }
            Object[] values = JsonReader.fillArgs(paramTypes, useNull);
            try {
                return constructor.newInstance(values);
            }
            catch (Exception e) {
                JsonReader.error("Could not instantiate " + c.getName(), e);
            }
        }
        Object[] ret = JsonReader.newInstanceEx(c);
        _constructors.put(c, new Object[]{ret[1], ret[2]});
        return ret[0];
    }

    private static Object[] newInstanceEx(Class c) throws IOException {
        try {
            Constructor constructor = c.getConstructor(_emptyClassArray);
            if (constructor != null) {
                return new Object[]{constructor.newInstance(new Object[0]), constructor, true};
            }
            return JsonReader.tryOtherConstructors(c);
        }
        catch (Exception e) {
            return JsonReader.tryOtherConstructors(c);
        }
    }

    private static Object[] tryOtherConstructors(Class c) throws IOException {
        Object[] values;
        Class[] argTypes;
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        if (constructors.length == 0) {
            JsonReader.error("Cannot instantiate '" + c.getName() + "' - Primitive, interface, array[] or void");
        }
        for (Constructor<?> constructor : constructors) {
            constructor.setAccessible(true);
            argTypes = constructor.getParameterTypes();
            values = JsonReader.fillArgs(argTypes, true);
            try {
                return new Object[]{constructor.newInstance(values), constructor, true};
            }
            catch (Exception ignored) {
            }
        }
        for (Constructor<?> constructor : constructors) {
            constructor.setAccessible(true);
            argTypes = constructor.getParameterTypes();
            values = JsonReader.fillArgs(argTypes, false);
            try {
                return new Object[]{constructor.newInstance(values), constructor, false};
            }
            catch (Exception ignored) {
            }
        }
        JsonReader.error("Could not instantiate " + c.getName() + " using any constructor");
        return null;
    }

    private static Object[] fillArgs(Class[] argTypes, boolean useNull) throws IOException {
        Object[] values = new Object[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            Class argType = argTypes[i];
            values[i] = JsonReader.isPrimitive(argType) ? JsonReader.newPrimitiveWrapper(argType, null) : (useNull ? null : (argType == String.class ? "" : (argType == java.util.Date.class ? new java.util.Date() : (List.class.isAssignableFrom(argType) ? new ArrayList() : (SortedSet.class.isAssignableFrom(argType) ? new TreeSet() : (Set.class.isAssignableFrom(argType) ? new LinkedHashSet() : (SortedMap.class.isAssignableFrom(argType) ? new TreeMap() : (Map.class.isAssignableFrom(argType) ? new LinkedHashMap() : (Collection.class.isAssignableFrom(argType) ? new ArrayList() : (Calendar.class.isAssignableFrom(argType) ? Calendar.getInstance() : (TimeZone.class.isAssignableFrom(argType) ? TimeZone.getDefault() : (argType == BigInteger.class ? BigInteger.TEN : (argType == BigDecimal.class ? BigDecimal.TEN : (argType == StringBuilder.class ? new StringBuilder() : (argType == StringBuffer.class ? new StringBuffer() : (argType == Locale.class ? Locale.FRANCE : (argType == Class.class ? String.class : (argType == Timestamp.class ? new Timestamp(System.currentTimeMillis()) : (argType == Date.class ? new Date(System.currentTimeMillis()) : null)))))))))))))))))));
        }
        return values;
    }

    public static boolean isPrimitive(Class c) {
        return c.isPrimitive() || _prims.contains(c);
    }

    private static Object newPrimitiveWrapper(Class c, Object rhs) throws IOException {
        if (c == Byte.class || c == Byte.TYPE) {
            if (rhs instanceof String) {
                if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                    rhs = "0";
                }
                return Byte.parseByte((String)rhs);
            }
            return rhs != null ? _byteCache[((Number)rhs).byteValue() + 128] : (byte)0;
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            if (rhs instanceof String) {
                if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                    rhs = "false";
                }
                return Boolean.parseBoolean((String)rhs);
            }
            return rhs != null ? rhs : Boolean.FALSE;
        }
        if (c == Integer.class || c == Integer.TYPE) {
            if (rhs instanceof String) {
                if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                    rhs = "0";
                }
                return Integer.parseInt((String)rhs);
            }
            return rhs != null ? ((Number)rhs).intValue() : 0;
        }
        if (c == Long.class || c == Long.TYPE || c == Number.class) {
            if (rhs instanceof String) {
                if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                    rhs = "0";
                }
                return Long.parseLong((String)rhs);
            }
            return rhs != null ? rhs : Long.valueOf(0L);
        }
        if (c == Double.class || c == Double.TYPE) {
            if (rhs instanceof String) {
                if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                    rhs = "0.0";
                }
                return Double.parseDouble((String)rhs);
            }
            return rhs != null ? rhs : Double.valueOf(0.0);
        }
        if (c == Character.class || c == Character.TYPE) {
            if (rhs == null) {
                return Character.valueOf('\u0000');
            }
            if (rhs instanceof String) {
                if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                    rhs = "\u0000";
                }
                return JsonReader.valueOf(((String)rhs).charAt(0));
            }
            if (rhs instanceof Character) {
                return rhs;
            }
        }
        if (c == Short.class || c == Short.TYPE) {
            if (rhs instanceof String) {
                if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                    rhs = "0";
                }
                return Short.parseShort((String)rhs);
            }
            return rhs != null ? ((Number)rhs).shortValue() : (short)0;
        }
        if (c == Float.class || c == Float.TYPE) {
            if (rhs instanceof String) {
                if ("".equals(rhs = JsonReader.removeLeadingAndTrailingQuotes((String)rhs))) {
                    rhs = "0.0f";
                }
                return Float.valueOf(Float.parseFloat((String)rhs));
            }
            return Float.valueOf(rhs != null ? ((Number)rhs).floatValue() : 0.0f);
        }
        return JsonReader.error("Class '" + c.getName() + "' requested for special instantiation - isPrimitive() does not match newPrimitiveWrapper()");
    }

    static String removeLeadingAndTrailingQuotes(String s) {
        Matcher m = _extraQuotes.matcher(s);
        if (m.find()) {
            s = m.group(2);
        }
        return s;
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13;
    }

    private static Class classForName(String name) throws IOException {
        if (name == null || name.isEmpty()) {
            JsonReader.error("Invalid class name specified");
        }
        try {
            Class c = _nameToClass.get(name);
            return c == null ? JsonReader.loadClass(name) : c;
        }
        catch (ClassNotFoundException e) {
            return (Class)JsonReader.error("Class instance '" + name + "' could not be created", e);
        }
    }

    static Class classForName2(String name) throws IOException {
        if (name == null || name.isEmpty()) {
            JsonReader.error("Empty class name.");
        }
        try {
            Class c = _nameToClass.get(name);
            return c == null ? JsonReader.loadClass(name) : c;
        }
        catch (ClassNotFoundException e) {
            JsonReader.error("Class instance '" + name + "' could not be created.", e);
            return null;
        }
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        String className = name;
        boolean arrayType = false;
        Class primitiveArray = null;
        while (className.startsWith("[")) {
            arrayType = true;
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
            if (className.equals("[B")) {
                primitiveArray = byte[].class;
            } else if (className.equals("[S")) {
                primitiveArray = short[].class;
            } else if (className.equals("[I")) {
                primitiveArray = int[].class;
            } else if (className.equals("[J")) {
                primitiveArray = long[].class;
            } else if (className.equals("[F")) {
                primitiveArray = float[].class;
            } else if (className.equals("[D")) {
                primitiveArray = double[].class;
            } else if (className.equals("[Z")) {
                primitiveArray = boolean[].class;
            } else if (className.equals("[C")) {
                primitiveArray = char[].class;
            }
            int startpos = className.startsWith("[L") ? 2 : 1;
            className = className.substring(startpos);
        }
        Class<Object> currentClass = null;
        if (null == primitiveArray) {
            currentClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        if (arrayType) {
            Class clazz = currentClass = null != primitiveArray ? primitiveArray : Array.newInstance(currentClass, 0).getClass();
            while (name.startsWith("[[")) {
                currentClass = Array.newInstance(currentClass, 0).getClass();
                name = name.substring(1);
            }
        }
        return currentClass;
    }

    private static Field getDeclaredField(Class c, String fieldName) throws IOException {
        return (Field)JsonWriter.getDeepDeclaredFields(c).get(fieldName);
    }

    private int skipWhitespaceRead() throws IOException {
        FastPushbackReader in = this._in;
        int c = in.read();
        while (JsonReader.isWhitespace(c)) {
            c = in.read();
        }
        return c;
    }

    private void skipWhitespace() throws IOException {
        this._in.unread(this.skipWhitespaceRead());
    }

    @Override
    public void close() {
        try {
            if (this._in != null) {
                this._in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void patchUnresolvedReferences() throws IOException {
        Iterator<UnresolvedReference> i = this._unresolvedRefs.iterator();
        while (i.hasNext()) {
            UnresolvedReference ref = i.next();
            Object objToFix = ((UnresolvedReference)ref).referencingObj.target;
            JsonObject objReferenced = this._objsRead.get(ref.refId);
            if (objReferenced == null || objReferenced.target == null || objToFix == null) continue;
            if (ref.index >= 0) {
                if (objToFix instanceof List) {
                    List list = (List)objToFix;
                    list.set(ref.index, objReferenced.target);
                } else if (objToFix instanceof Collection) {
                    Collection col = (Collection)objToFix;
                    col.add(objReferenced.target);
                } else {
                    Array.set(objToFix, ref.index, objReferenced.target);
                }
            } else {
                Field field = JsonReader.getDeclaredField(objToFix.getClass(), ref.field);
                if (field != null) {
                    try {
                        field.set(objToFix, objReferenced.target);
                    }
                    catch (Exception e) {
                        JsonReader.error("Error setting field while resolving references '" + field.getName() + "', @ref = " + ref.refId, e);
                    }
                }
            }
            i.remove();
        }
        int count = this._unresolvedRefs.size();
        if (count > 0) {
            StringBuilder out = new StringBuilder();
            out.append(count);
            out.append(" unresolved references:\n");
            i = this._unresolvedRefs.iterator();
            count = 1;
            while (i.hasNext()) {
                UnresolvedReference ref = i.next();
                out.append("    Unresolved reference ");
                out.append(count);
                out.append('\n');
                out.append("        @ref ");
                out.append(ref.refId);
                out.append('\n');
                out.append("        field ");
                out.append(ref.field);
                out.append("\n\n");
                ++count;
            }
            JsonReader.error(out.toString());
        }
    }

    private void rehashMaps() {
        boolean useMaps = this._noObjects;
        for (Object[] mapPieces : this._prettyMaps) {
            Object[] javaValues;
            Object[] javaKeys;
            Map<Object, Object> map;
            JsonObject jObj = (JsonObject)mapPieces[0];
            if (useMaps) {
                map = jObj;
                javaKeys = (Object[])jObj.remove("@keys");
                javaValues = (Object[])jObj.remove("@items");
            } else {
                map = (Map)jObj.target;
                javaKeys = (Object[])mapPieces[1];
                javaValues = (Object[])mapPieces[2];
                jObj.clear();
            }
            for (int j = 0; javaKeys != null && j < javaKeys.length; ++j) {
                map.put(javaKeys[j], javaValues[j]);
            }
        }
    }

    private static String getErrorMessage(String msg) {
        return msg + "\nLast read: " + JsonReader.getLastReadSnippet() + "\nline: " + _line.get() + ", col: " + _col.get();
    }

    static Object error(String msg) throws IOException {
        throw new IOException(JsonReader.getErrorMessage(msg));
    }

    static Object error(String msg, Exception e) throws IOException {
        throw new IOException(JsonReader.getErrorMessage(msg), e);
    }

    private static String getLastReadSnippet() {
        StringBuilder s = new StringBuilder();
        for (char[] chars : _snippet.get()) {
            s.append(chars);
        }
        return s.toString();
    }

    private static Character valueOf(char c) {
        return Character.valueOf(c <= '\u007f' ? _charCache[c].charValue() : c);
    }

    private static char[] toChars(int codePoint) {
        if (codePoint < 0 || codePoint > 0x10FFFF) {
            throw new IllegalArgumentException("value ' + codePoint + ' outside UTF-8 range");
        }
        if (codePoint < 65536) {
            return new char[]{(char)codePoint};
        }
        char[] result = new char[2];
        int offset = codePoint - 65536;
        result[1] = (char)((offset & 0x3FF) + 56320);
        result[0] = (char)((offset >>> 10) + 55296);
        return result;
    }

    static {
        int i;
        _charCache = new Character[128];
        _byteCache = new Byte[256];
        _stringCache = new HashMap<String, String>();
        _prims = new HashSet<Class>();
        _constructors = new HashMap<Class, Object[]>();
        _nameToClass = new HashMap<String, Class>();
        _emptyClassArray = new Class[0];
        _readers = new ArrayList<Object[]>();
        _notCustom = new HashSet<Class>();
        _months = new LinkedHashMap<String, String>();
        _factory = new LinkedHashMap<Class, ClassFactory>();
        _datePattern1 = Pattern.compile("^(\\d{4})[\\./-](\\d{1,2})[\\./-](\\d{1,2})");
        _datePattern2 = Pattern.compile("^(\\d{1,2})[\\./-](\\d{1,2})[\\./-](\\d{4})");
        _datePattern3 = Pattern.compile("(Jan|Feb|Mar|March|Apr|April|May|Jun|June|Jul|July|Aug|Sep|Sept|Oct|Nov|Dec)[ ,]+(\\d{1,2})[ ,]+(\\d{4})", 2);
        _datePattern4 = Pattern.compile("(\\d{1,2})[ ,](Jan|Feb|Mar|March|Apr|April|May|Jun|June|Jul|July|Aug|Sep|Sept|Oct|Nov|Dec)[ ,]+(\\d{4})", 2);
        _timePattern1 = Pattern.compile("(\\d{2})[:.](\\d{2})[:.](\\d{2})[.](\\d{1,3})");
        _timePattern2 = Pattern.compile("(\\d{2})[:.](\\d{2})[:.](\\d{2})");
        _timePattern3 = Pattern.compile("(\\d{2})[:.](\\d{2})");
        _extraQuotes = Pattern.compile("([\"]*)([^\"]*)([\"]*)");
        _snippet = new ThreadLocal<Deque<char[]>>(){

            @Override
            public Deque<char[]> initialValue() {
                return new ArrayDeque<char[]>(128);
            }
        };
        _line = new ThreadLocal<Integer>(){

            @Override
            public Integer initialValue() {
                return 1;
            }
        };
        _col = new ThreadLocal<Integer>(){

            @Override
            public Integer initialValue() {
                return 1;
            }
        };
        for (i = 0; i < _charCache.length; ++i) {
            JsonReader._charCache[i] = Character.valueOf((char)i);
        }
        for (i = 0; i < _byteCache.length; ++i) {
            JsonReader._byteCache[i] = (byte)(i - 128);
        }
        _stringCache.put("", "");
        _stringCache.put("true", "true");
        _stringCache.put("True", "True");
        _stringCache.put("TRUE", "TRUE");
        _stringCache.put("false", "false");
        _stringCache.put("False", "False");
        _stringCache.put("FALSE", "FALSE");
        _stringCache.put("null", "null");
        _stringCache.put("yes", "yes");
        _stringCache.put("Yes", "Yes");
        _stringCache.put("YES", "YES");
        _stringCache.put("no", "no");
        _stringCache.put("No", "No");
        _stringCache.put("NO", "NO");
        _stringCache.put("on", "on");
        _stringCache.put("On", "On");
        _stringCache.put("ON", "ON");
        _stringCache.put("off", "off");
        _stringCache.put("Off", "Off");
        _stringCache.put("OFF", "OFF");
        _stringCache.put("@id", "@id");
        _stringCache.put("@ref", "@ref");
        _stringCache.put("@items", "@items");
        _stringCache.put("@type", "@type");
        _stringCache.put("@keys", "@keys");
        _stringCache.put("0", "0");
        _stringCache.put("1", "1");
        _stringCache.put("2", "2");
        _stringCache.put("3", "3");
        _stringCache.put("4", "4");
        _stringCache.put("5", "5");
        _stringCache.put("6", "6");
        _stringCache.put("7", "7");
        _stringCache.put("8", "8");
        _stringCache.put("9", "9");
        _prims.add(Byte.class);
        _prims.add(Integer.class);
        _prims.add(Long.class);
        _prims.add(Double.class);
        _prims.add(Character.class);
        _prims.add(Float.class);
        _prims.add(Boolean.class);
        _prims.add(Short.class);
        _nameToClass.put("string", String.class);
        _nameToClass.put("boolean", Boolean.TYPE);
        _nameToClass.put("char", Character.TYPE);
        _nameToClass.put("byte", Byte.TYPE);
        _nameToClass.put("short", Short.TYPE);
        _nameToClass.put("int", Integer.TYPE);
        _nameToClass.put("long", Long.TYPE);
        _nameToClass.put("float", Float.TYPE);
        _nameToClass.put("double", Double.TYPE);
        _nameToClass.put("date", java.util.Date.class);
        _nameToClass.put("class", Class.class);
        JsonReader.addReader(String.class, new StringReader());
        JsonReader.addReader(java.util.Date.class, new DateReader());
        JsonReader.addReader(BigInteger.class, new BigIntegerReader());
        JsonReader.addReader(BigDecimal.class, new BigDecimalReader());
        JsonReader.addReader(Date.class, new SqlDateReader());
        JsonReader.addReader(Timestamp.class, new TimestampReader());
        JsonReader.addReader(Calendar.class, new CalendarReader());
        JsonReader.addReader(TimeZone.class, new TimeZoneReader());
        JsonReader.addReader(Locale.class, new LocaleReader());
        JsonReader.addReader(Class.class, new ClassReader());
        JsonReader.addReader(StringBuilder.class, new StringBuilderReader());
        JsonReader.addReader(StringBuffer.class, new StringBufferReader());
        CollectionFactory colFactory = new CollectionFactory();
        JsonReader.assignInstantiator(Collection.class, colFactory);
        JsonReader.assignInstantiator(List.class, colFactory);
        JsonReader.assignInstantiator(Set.class, colFactory);
        JsonReader.assignInstantiator(SortedSet.class, colFactory);
        JsonReader.assignInstantiator(Collection.class, colFactory);
        MapFactory mapFactory = new MapFactory();
        JsonReader.assignInstantiator(Map.class, mapFactory);
        JsonReader.assignInstantiator(SortedMap.class, mapFactory);
        _months.put("jan", "1");
        _months.put("january", "1");
        _months.put("feb", "2");
        _months.put("february", "2");
        _months.put("mar", "3");
        _months.put("march", "3");
        _months.put("apr", "4");
        _months.put("april", "4");
        _months.put("may", "5");
        _months.put("jun", "6");
        _months.put("june", "6");
        _months.put("jul", "7");
        _months.put("july", "7");
        _months.put("aug", "8");
        _months.put("august", "8");
        _months.put("sep", "9");
        _months.put("sept", "9");
        _months.put("september", "9");
        _months.put("oct", "10");
        _months.put("october", "10");
        _months.put("nov", "11");
        _months.put("november", "11");
        _months.put("dec", "12");
        _months.put("december", "12");
    }

    private static class FastPushbackReader
    extends FilterReader {
        private final int[] _buf;
        private int _idx;

        private FastPushbackReader(Reader reader, int size) {
            super(reader);
            _snippet.get().clear();
            _line.set(1);
            _col.set(1);
            if (size <= 0) {
                throw new IllegalArgumentException("size <= 0");
            }
            this._buf = new int[size];
            this._idx = size;
        }

        private FastPushbackReader(Reader r) {
            this(r, 1);
        }

        public int read() throws IOException {
            int ch = this._idx < this._buf.length ? this._buf[this._idx++] : super.read();
            if (ch >= 0) {
                if (ch == 10) {
                    _line.set(_line.get() + 1);
                    _col.set(0);
                } else {
                    _col.set(_col.get() + 1);
                }
                Deque<char[]> buffer = _snippet.get();
                buffer.addLast(JsonReader.toChars(ch));
                if (buffer.size() > 100) {
                    buffer.removeFirst();
                }
            }
            return ch;
        }

        public void unread(int c) throws IOException {
            if (this._idx == 0) {
                JsonReader.error("unread(int c) called more than buffer size (" + this._buf.length + ")");
            }
            if (c == 10) {
                _line.set(_line.get() - 1);
            } else {
                _col.set(_col.get() - 1);
            }
            this._buf[--this._idx] = c;
            _snippet.get().removeLast();
        }

        public void close() throws IOException {
            super.close();
            _snippet.remove();
            _line.remove();
            _col.remove();
        }
    }

    private static class UnresolvedReference {
        private JsonObject referencingObj;
        private String field;
        private long refId;
        private int index = -1;

        private UnresolvedReference(JsonObject referrer, String fld, long id) {
            this.referencingObj = referrer;
            this.field = fld;
            this.refId = id;
        }

        private UnresolvedReference(JsonObject referrer, int idx, long id) {
            this.referencingObj = referrer;
            this.index = idx;
            this.refId = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimestampReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            Object nanos;
            JsonObject jObj = (JsonObject)o;
            Object time = jObj.get("time");
            if (time == null) {
                JsonReader.error("java.sql.Timestamp must specify 'time' field");
            }
            if ((nanos = jObj.get("nanos")) == null) {
                jObj.target = new Timestamp(Long.valueOf((String)time));
                return jObj.target;
            }
            Timestamp tstamp = new Timestamp(Long.valueOf((String)time));
            tstamp.setNanos(Integer.valueOf((String)nanos));
            jObj.target = tstamp;
            return jObj.target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBufferReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof String) {
                return new StringBuffer((String)o);
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = new StringBuffer((String)jObj.get("value"));
                return jObj.target;
            }
            return JsonReader.error("StringBuffer missing 'value' field");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBuilderReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof String) {
                return new StringBuilder((String)o);
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = new StringBuilder((String)jObj.get("value"));
                return jObj.target;
            }
            return JsonReader.error("StringBuilder missing 'value' field");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigDecimalReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            JsonObject jObj = null;
            Object value = o;
            if (o instanceof JsonObject) {
                jObj = (JsonObject)o;
                if (jObj.containsKey("value")) {
                    value = jObj.get("value");
                } else {
                    return JsonReader.error("BigDecimal missing 'value' field");
                }
            }
            BigDecimal x = null;
            if (value instanceof JsonObject) {
                JsonObject valueObj = (JsonObject)value;
                if ("java.math.BigInteger".equals(valueObj.type)) {
                    BigIntegerReader reader = new BigIntegerReader();
                    value = reader.read(value, stack);
                } else if ("java.math.BigDecimal".equals(valueObj.type)) {
                    value = this.read(value, stack);
                } else {
                    return JsonReader.error("Unknown object type attempted to be assigned to BigInteger field: " + value);
                }
            }
            if (value instanceof String) {
                x = new BigDecimal(JsonReader.removeLeadingAndTrailingQuotes((String)value));
            }
            if (value instanceof BigDecimal) {
                x = (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                x = new BigDecimal((BigInteger)value);
            }
            if (value instanceof Boolean) {
                x = new BigDecimal((Boolean)value != false ? "1" : "0");
            }
            if (value instanceof Long || value instanceof Double || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof Float || value instanceof BigInteger) {
                x = new BigDecimal(value.toString());
            }
            if (jObj != null) {
                jObj.target = x;
            }
            return x != null ? x : JsonReader.error("BigDecimal missing 'value' field not convertible to a BigDecimal: " + value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigIntegerReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            JsonObject jObj = null;
            Object value = o;
            if (o instanceof JsonObject) {
                jObj = (JsonObject)o;
                if (jObj.containsKey("value")) {
                    value = jObj.get("value");
                } else {
                    return JsonReader.error("BigInteger missing 'value' field");
                }
            }
            BigInteger x = null;
            if (value instanceof JsonObject) {
                JsonObject valueObj = (JsonObject)value;
                if ("java.math.BigDecimal".equals(valueObj.type)) {
                    BigDecimalReader reader = new BigDecimalReader();
                    value = reader.read(value, stack);
                } else if ("java.math.BigInteger".equals(valueObj.type)) {
                    value = this.read(value, stack);
                } else {
                    return JsonReader.error("Unknown object type attempted to be assigned to BigInteger field: " + value);
                }
            }
            if (value instanceof String) {
                x = new BigInteger(JsonReader.removeLeadingAndTrailingQuotes((String)value));
            }
            if (value instanceof BigInteger) {
                x = (BigInteger)value;
            }
            if (value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)value;
                String str = bd.toPlainString();
                if (str.contains(".")) {
                    return JsonReader.error("Cannot assign BigDecimal to BigInteger if BigDecimal has fractional part: " + value);
                }
                x = new BigInteger(str);
            }
            if (value instanceof Boolean) {
                x = new BigInteger((Boolean)value != false ? "1" : "0");
            }
            if (value instanceof Double || value instanceof Float) {
                return JsonReader.error("Cannot assign floating point value to a BigInteger: " + value);
            }
            if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
                x = new BigInteger(value.toString());
            }
            if (jObj != null) {
                jObj.target = x;
            }
            return x != null ? x : JsonReader.error("BigInteger 'value' convertible to a BigInteger: " + value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof String) {
                return JsonReader.classForName2((String)o);
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = JsonReader.classForName2((String)jObj.get("value"));
                return jObj.target;
            }
            return JsonReader.error("Class missing 'value' field");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof String) {
                return o;
            }
            if (JsonReader.isPrimitive(o.getClass())) {
                return o.toString();
            }
            JsonObject jObj = (JsonObject)o;
            if (jObj.containsKey("value")) {
                jObj.target = jObj.get("value");
                return jObj.target;
            }
            return JsonReader.error("String missing 'value' field");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SqlDateReader
    extends DateReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            return new Date(((java.util.Date)super.read(o, stack)).getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            if (o instanceof Long) {
                return new java.util.Date((Long)o);
            }
            if (o instanceof String) {
                return DateReader.parseDate((String)o);
            }
            if (o instanceof JsonObject) {
                JsonObject jObj = (JsonObject)o;
                Object val = jObj.get("value");
                if (val instanceof Long) {
                    return new java.util.Date((Long)val);
                }
                if (val instanceof String) {
                    return DateReader.parseDate((String)val);
                }
                return JsonReader.error("Unable to parse date: " + o);
            }
            return JsonReader.error("Unable to parse date, encountered unknown object: " + o);
        }

        private static java.util.Date parseDate(String dateStr) throws IOException {
            String day;
            String year;
            dateStr = dateStr.trim();
            Matcher matcher = _datePattern1.matcher(dateStr);
            String month = null;
            String mon = null;
            if (matcher.find()) {
                year = matcher.group(1);
                month = matcher.group(2);
                day = matcher.group(3);
            } else {
                matcher = _datePattern2.matcher(dateStr);
                if (matcher.find()) {
                    month = matcher.group(1);
                    day = matcher.group(2);
                    year = matcher.group(3);
                } else {
                    matcher = _datePattern3.matcher(dateStr);
                    if (matcher.find()) {
                        mon = matcher.group(1);
                        day = matcher.group(2);
                        year = matcher.group(3);
                    } else {
                        matcher = _datePattern4.matcher(dateStr);
                        if (!matcher.find()) {
                            JsonReader.error("Unable to parse: " + dateStr);
                        }
                        day = matcher.group(1);
                        mon = matcher.group(2);
                        year = matcher.group(3);
                    }
                }
            }
            if (mon != null && (month = (String)_months.get(mon.trim().toLowerCase())) == null) {
                JsonReader.error("Unable to parse month portion of date: " + dateStr);
            }
            if (!((matcher = _timePattern1.matcher(dateStr)).find() || (matcher = _timePattern2.matcher(dateStr)).find() || (matcher = _timePattern3.matcher(dateStr)).find())) {
                matcher = null;
            }
            Calendar c = Calendar.getInstance();
            c.clear();
            int y = 0;
            int m = 0;
            int d = 0;
            try {
                y = Integer.parseInt(year);
                m = Integer.parseInt(month) - 1;
                d = Integer.parseInt(day);
            }
            catch (Exception e) {
                JsonReader.error("Unable to parse: " + dateStr, e);
            }
            if (matcher == null) {
                c.set(y, m, d);
            } else {
                String hour = matcher.group(1);
                String min = matcher.group(2);
                String sec = "00";
                String milli = "000";
                if (matcher.groupCount() > 2) {
                    sec = matcher.group(3);
                }
                if (matcher.groupCount() > 3) {
                    milli = matcher.group(4);
                }
                int h = 0;
                int mn = 0;
                int s = 0;
                int ms = 0;
                try {
                    h = Integer.parseInt(hour);
                    mn = Integer.parseInt(min);
                    s = Integer.parseInt(sec);
                    ms = Integer.parseInt(milli);
                }
                catch (Exception e) {
                    JsonReader.error("Unable to parse time: " + dateStr, e);
                }
                c.set(y, m, d, h, mn, s);
                c.set(14, ms);
            }
            return c.getTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CalendarReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            String time = null;
            try {
                Class c;
                JsonObject jObj = (JsonObject)o;
                time = (String)jObj.get("time");
                if (time == null) {
                    JsonReader.error("Calendar missing 'time' field");
                }
                java.util.Date date = JsonWriter._dateFormat.get().parse(time);
                if (jObj.getTarget() != null) {
                    c = jObj.getTarget().getClass();
                } else {
                    String type = jObj.type;
                    c = JsonReader.classForName2(type);
                }
                Calendar calendar = (Calendar)JsonReader.newInstance(c);
                calendar.setTime(date);
                jObj.setTarget(calendar);
                String zone = (String)jObj.get("zone");
                if (zone != null) {
                    calendar.setTimeZone(TimeZone.getTimeZone(zone));
                }
                return calendar;
            }
            catch (Exception e) {
                return JsonReader.error("Failed to parse calendar, time: " + time);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocaleReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            JsonObject jObj = (JsonObject)o;
            Object language = jObj.get("language");
            if (language == null) {
                JsonReader.error("java.util.Locale must specify 'language' field");
            }
            Object country = jObj.get("country");
            Object variant = jObj.get("variant");
            if (country == null) {
                jObj.target = new Locale((String)language);
                return jObj.target;
            }
            if (variant == null) {
                jObj.target = new Locale((String)language, (String)country);
                return jObj.target;
            }
            jObj.target = new Locale((String)language, (String)country, (String)variant);
            return jObj.target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimeZoneReader
    implements JsonClassReader {
        @Override
        public Object read(Object o, LinkedList<JsonObject<String, Object>> stack) throws IOException {
            JsonObject jObj = (JsonObject)o;
            Object zone = jObj.get("zone");
            if (zone == null) {
                JsonReader.error("java.util.TimeZone must specify 'zone' field");
            }
            jObj.target = TimeZone.getTimeZone((String)zone);
            return jObj.target;
        }
    }

    public static class MapFactory
    implements ClassFactory {
        public Object newInstance(Class c) {
            if (SortedMap.class.isAssignableFrom(c)) {
                return new TreeMap();
            }
            if (Map.class.isAssignableFrom(c)) {
                return new LinkedHashMap();
            }
            throw new RuntimeException("MapFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static class CollectionFactory
    implements ClassFactory {
        public Object newInstance(Class c) {
            if (List.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(c)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(c)) {
                return new LinkedHashSet();
            }
            if (Collection.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            throw new RuntimeException("CollectionFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static interface ClassFactory {
        public Object newInstance(Class var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JsonClassReader {
        public Object read(Object var1, LinkedList<JsonObject<String, Object>> var2) throws IOException;
    }
}

