/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.repackaged.com.google.common.base.Function;
import com.bumptech.glide.repackaged.com.google.common.base.Preconditions;
import com.bumptech.glide.repackaged.com.google.common.collect.Lists;
import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.MethodSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class GlideGenerator {
    private final ProcessingEnvironment processingEnv;
    private final ProcessorUtil processorUtil;
    private final TypeElement glideType;
    private final TypeElement requestManagerType;

    GlideGenerator(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processingEnv = processingEnv;
        this.processorUtil = processorUtil;
        Elements elementUtils = processingEnv.getElementUtils();
        this.requestManagerType = elementUtils.getTypeElement("com.bumptech.glide.RequestManager");
        this.glideType = elementUtils.getTypeElement("com.bumptech.glide.Glide");
    }

    TypeSpec generate(String generatedCodePackageName, String glideName, TypeSpec generatedRequestManager) {
        return TypeSpec.classBuilder(glideName).addJavadoc("The entry point for interacting with Glide for Applications\n\n<p>Includes all generated APIs from all\n{@link $T}s in source and dependent libraries.\n\n<p>This class is generated and should not be modified\n@see $T\n", GlideExtension.class, this.glideType).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build()).addMethods(this.generateOverridesForGlideMethods(generatedCodePackageName, generatedRequestManager)).build();
    }

    private List<MethodSpec> generateOverridesForGlideMethods(final String generatedCodePackageName, final TypeSpec generatedRequestManager) {
        return Lists.transform(this.discoverGlideMethodsToOverride(), new Function<ExecutableElement, MethodSpec>(){

            @Override
            public MethodSpec apply(ExecutableElement input) {
                if (GlideGenerator.this.isGlideWithMethod(input)) {
                    return GlideGenerator.this.overrideGlideWithMethod(generatedCodePackageName, generatedRequestManager, input);
                }
                return GlideGenerator.this.overrideGlideStaticMethod(input);
            }
        });
    }

    private MethodSpec overrideGlideStaticMethod(ExecutableElement methodToOverride) {
        boolean returnsValue;
        List<ParameterSpec> parameters = this.processorUtil.getParameters(methodToOverride);
        TypeElement element = (TypeElement)this.processingEnv.getTypeUtils().asElement(methodToOverride.getReturnType());
        MethodSpec.Builder builder = MethodSpec.methodBuilder(methodToOverride.getSimpleName().toString()).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(methodToOverride)).addParameters(parameters);
        this.addReturnAnnotations(builder, methodToOverride);
        boolean bl = returnsValue = element != null;
        if (returnsValue) {
            builder.returns(ClassName.get(element));
        }
        StringBuilder code = new StringBuilder(returnsValue ? "return " : "");
        code.append("$T.$N(");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(ClassName.get(this.glideType));
        args.add(methodToOverride.getSimpleName());
        if (!parameters.isEmpty()) {
            for (ParameterSpec param : parameters) {
                code.append("$L, ");
                args.add(param.name);
            }
            code = new StringBuilder(code.substring(0, code.length() - 2));
        }
        code.append(")");
        builder.addStatement(code.toString(), args.toArray(new Object[0]));
        return builder.build();
    }

    private MethodSpec.Builder addReturnAnnotations(MethodSpec.Builder builder, ExecutableElement methodToOverride) {
        Elements elements = this.processingEnv.getElementUtils();
        TypeElement visibleForTestingTypeElement = elements.getTypeElement(this.processorUtil.visibleForTesting().reflectionName());
        String visibleForTestingTypeQualifiedName = visibleForTestingTypeElement.toString();
        for (AnnotationMirror annotationMirror : methodToOverride.getAnnotationMirrors()) {
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
            String annotationQualifiedName = annotationMirror.getAnnotationType().toString();
            if (!annotationQualifiedName.equals(visibleForTestingTypeQualifiedName)) continue;
            builder.addAnnotation(AnnotationSpec.builder(ClassName.get("android.annotation", "SuppressLint", new String[0])).addMember("value", "$S", "VisibleForTests").build());
        }
        return builder;
    }

    private List<ExecutableElement> discoverGlideMethodsToOverride() {
        return this.processorUtil.findStaticMethods(this.glideType);
    }

    private boolean isGlideWithMethod(ExecutableElement element) {
        return this.processorUtil.isReturnValueTypeMatching(element, this.requestManagerType);
    }

    private MethodSpec overrideGlideWithMethod(String packageName, TypeSpec generatedRequestManager, ExecutableElement methodToOverride) {
        ClassName generatedRequestManagerClassName = ClassName.get(packageName, generatedRequestManager.name, new String[0]);
        List<ParameterSpec> parameters = this.processorUtil.getParameters(methodToOverride);
        Preconditions.checkArgument(parameters.size() == 1, "Expected size of 1, but got %s", methodToOverride);
        ParameterSpec parameter = parameters.iterator().next();
        MethodSpec.Builder builder = MethodSpec.methodBuilder(methodToOverride.getSimpleName().toString()).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(methodToOverride)).addParameters(parameters).returns(generatedRequestManagerClassName).addStatement("return ($T) $T.$N($L)", generatedRequestManagerClassName, this.glideType, methodToOverride.getSimpleName().toString(), parameter.name);
        return this.addReturnAnnotations(builder, methodToOverride).build();
    }
}

