/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.annotation.compiler.RequestOptionsExtensionGenerator;
import com.bumptech.glide.annotation.compiler.RequestOptionsOverrideGenerator;
import com.bumptech.glide.repackaged.com.google.common.base.Function;
import com.bumptech.glide.repackaged.com.google.common.base.Objects;
import com.bumptech.glide.repackaged.com.google.common.base.Preconditions;
import com.bumptech.glide.repackaged.com.google.common.base.Predicate;
import com.bumptech.glide.repackaged.com.google.common.base.Strings;
import com.bumptech.glide.repackaged.com.google.common.collect.FluentIterable;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableList;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableSet;
import com.bumptech.glide.repackaged.com.google.common.collect.Iterables;
import com.bumptech.glide.repackaged.com.google.common.collect.Lists;
import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.CodeBlock;
import com.bumptech.glide.repackaged.com.squareup.javapoet.FieldSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.MethodSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;

final class RequestOptionsGenerator {
    private int nextFieldId;
    private final ClassName requestOptionsName;
    private final TypeElement requestOptionsType;
    private final ProcessorUtil processorUtil;
    private final RequestOptionsOverrideGenerator requestOptionsOverrideGenerator;
    private ClassName glideOptionsName;

    RequestOptionsGenerator(ProcessingEnvironment processingEnvironment, ProcessorUtil processorUtil) {
        this.processorUtil = processorUtil;
        this.requestOptionsName = ClassName.get("com.bumptech.glide.request", "RequestOptions", new String[0]);
        this.requestOptionsType = processingEnvironment.getElementUtils().getTypeElement("com.bumptech.glide.request.RequestOptions");
        this.requestOptionsOverrideGenerator = new RequestOptionsOverrideGenerator(processingEnvironment, processorUtil);
    }

    TypeSpec generate(String generatedCodePackageName, Set<String> glideExtensionClassNames) {
        this.glideOptionsName = ClassName.get(generatedCodePackageName, "GlideOptions", new String[0]);
        RequestOptionsExtensionGenerator requestOptionsExtensionGenerator = new RequestOptionsExtensionGenerator(this.glideOptionsName, this.processorUtil);
        ImmutableList<MethodAndStaticVar> instanceMethodsForExtensions = FluentIterable.from(requestOptionsExtensionGenerator.generateInstanceMethodsForExtensions(glideExtensionClassNames)).transform(new Function<MethodSpec, MethodAndStaticVar>(){

            @Override
            public MethodAndStaticVar apply(MethodSpec input) {
                return new MethodAndStaticVar(input);
            }
        }).toList();
        ImmutableList<MethodAndStaticVar> staticMethodsForExtensions = FluentIterable.from(requestOptionsExtensionGenerator.getRequestOptionExtensionMethods(glideExtensionClassNames)).filter(new Predicate<ExecutableElement>(){

            @Override
            public boolean apply(ExecutableElement input) {
                return !RequestOptionsGenerator.skipStaticMethod(input);
            }
        }).transform(new Function<ExecutableElement, MethodAndStaticVar>(){

            @Override
            public MethodAndStaticVar apply(ExecutableElement input) {
                return RequestOptionsGenerator.this.generateStaticMethodEquivalentForExtensionMethod(input);
            }
        }).toList();
        ArrayList<MethodAndStaticVar> methodsForExtensions = new ArrayList<MethodAndStaticVar>();
        methodsForExtensions.addAll(instanceMethodsForExtensions);
        methodsForExtensions.addAll(staticMethodsForExtensions);
        ImmutableSet<MethodSignature> extensionMethodSignatures = ImmutableSet.copyOf(Iterables.transform(methodsForExtensions, new Function<MethodAndStaticVar, MethodSignature>(){

            @Override
            public MethodSignature apply(MethodAndStaticVar f) {
                return new MethodSignature(f.method);
            }
        }));
        List<MethodAndStaticVar> staticOverrides = this.generateStaticMethodOverridesForRequestOptions();
        List<MethodSpec> instanceOverrides = this.requestOptionsOverrideGenerator.generateInstanceMethodOverridesForRequestOptions(this.glideOptionsName);
        ArrayList<MethodAndStaticVar> allMethodsAndStaticVars = new ArrayList<MethodAndStaticVar>();
        for (MethodAndStaticVar item : staticOverrides) {
            if (extensionMethodSignatures.contains(new MethodSignature(item.method))) continue;
            allMethodsAndStaticVars.add(item);
        }
        for (MethodSpec methodSpec : instanceOverrides) {
            if (extensionMethodSignatures.contains(new MethodSignature(methodSpec))) continue;
            allMethodsAndStaticVars.add(new MethodAndStaticVar(methodSpec));
        }
        allMethodsAndStaticVars.addAll(methodsForExtensions);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder("GlideOptions").addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "deprecation").build()).addJavadoc(this.generateClassJavadoc(glideExtensionClassNames)).addModifiers(Modifier.FINAL).addModifiers(Modifier.PUBLIC).addSuperinterface((Type)((Object)Cloneable.class)).superclass(this.requestOptionsName);
        for (MethodAndStaticVar methodAndStaticVar : allMethodsAndStaticVars) {
            if (methodAndStaticVar.method != null) {
                classBuilder.addMethod(methodAndStaticVar.method);
            }
            if (methodAndStaticVar.staticField == null) continue;
            classBuilder.addField(methodAndStaticVar.staticField);
        }
        return classBuilder.build();
    }

    private CodeBlock generateClassJavadoc(Set<String> glideExtensionClassNames) {
        CodeBlock.Builder builder = CodeBlock.builder().add("Automatically generated from {@link $T} annotated classes.\n", GlideExtension.class).add("\n", new Object[0]).add("@see $T\n", this.requestOptionsName);
        for (String glideExtensionClass : glideExtensionClassNames) {
            builder.add("@see $T\n", ClassName.bestGuess(glideExtensionClass));
        }
        return builder.build();
    }

    private List<MethodAndStaticVar> generateStaticMethodOverridesForRequestOptions() {
        List<ExecutableElement> staticMethodsThatReturnRequestOptions = this.processorUtil.findStaticMethodsReturning(this.requestOptionsType, this.requestOptionsType);
        ArrayList<MethodAndStaticVar> staticMethods = new ArrayList<MethodAndStaticVar>();
        for (ExecutableElement element : staticMethodsThatReturnRequestOptions) {
            if (element.getAnnotation(Deprecated.class) != null) continue;
            staticMethods.add(this.generateStaticMethodEquivalentForRequestOptionsStaticMethod(element));
        }
        return staticMethods;
    }

    private static String getInstanceMethodNameFromStaticMethodName(String staticMethodName) {
        String equivalentInstanceMethodName;
        if ("bitmapTransform".equals(staticMethodName)) {
            equivalentInstanceMethodName = "transform";
        } else if ("decodeTypeOf".equals(staticMethodName)) {
            equivalentInstanceMethodName = "decode";
        } else if (staticMethodName.endsWith("Transform")) {
            equivalentInstanceMethodName = staticMethodName.substring(0, staticMethodName.length() - 9);
        } else if (staticMethodName.endsWith("Of")) {
            equivalentInstanceMethodName = staticMethodName.substring(0, staticMethodName.length() - 2);
        } else if ("noTransformation".equals(staticMethodName)) {
            equivalentInstanceMethodName = "dontTransform";
        } else if ("noAnimation".equals(staticMethodName)) {
            equivalentInstanceMethodName = "dontAnimate";
        } else if (staticMethodName.equals("option")) {
            equivalentInstanceMethodName = "set";
        } else {
            throw new IllegalArgumentException("Unrecognized static method name: " + staticMethodName);
        }
        return equivalentInstanceMethodName;
    }

    private MethodAndStaticVar generateStaticMethodEquivalentForRequestOptionsStaticMethod(ExecutableElement staticMethod) {
        boolean memoize = RequestOptionsGenerator.memoizeStaticMethodFromArguments(staticMethod);
        String staticMethodName = staticMethod.getSimpleName().toString();
        String equivalentInstanceMethodName = RequestOptionsGenerator.getInstanceMethodNameFromStaticMethodName(staticMethodName);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder(staticMethodName).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(staticMethod)).returns(this.glideOptionsName);
        StringBuilder createNewOptionAndCall = this.createNewOptionAndCall(memoize, methodSpecBuilder, "new $T().$N(", ProcessorUtil.getParameters(staticMethod));
        FieldSpec requiredStaticField = null;
        if (memoize) {
            String staticVariableName = staticMethodName + this.nextFieldId++;
            requiredStaticField = FieldSpec.builder(this.glideOptionsName, staticVariableName, new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC).build();
            methodSpecBuilder.beginControlFlow("if ($T.$N == null)", this.glideOptionsName, staticVariableName).addStatement("$T.$N =\n" + createNewOptionAndCall + ".$N", this.glideOptionsName, staticVariableName, this.glideOptionsName, equivalentInstanceMethodName, "autoClone()").endControlFlow().addStatement("return $T.$N", this.glideOptionsName, staticVariableName);
        } else {
            methodSpecBuilder.addStatement("return " + createNewOptionAndCall, this.glideOptionsName, equivalentInstanceMethodName);
        }
        List<? extends TypeParameterElement> typeParameters = staticMethod.getTypeParameters();
        for (TypeParameterElement typeParameterElement : typeParameters) {
            methodSpecBuilder.addTypeVariable(TypeVariableName.get(typeParameterElement.getSimpleName().toString()));
        }
        methodSpecBuilder.addAnnotation(ProcessorUtil.checkResult()).addAnnotation(ProcessorUtil.nonNull());
        return new MethodAndStaticVar(methodSpecBuilder.build(), requiredStaticField);
    }

    private static boolean memoizeStaticMethodFromArguments(ExecutableElement staticMethod) {
        return staticMethod.getParameters().isEmpty() || staticMethod.getParameters().size() == 1 && staticMethod.getParameters().get(0).getSimpleName().toString().equals("android.content.Context");
    }

    private StringBuilder createNewOptionAndCall(boolean memoize, MethodSpec.Builder methodSpecBuilder, String start, List<ParameterSpec> specs) {
        StringBuilder createNewOptionAndCall = new StringBuilder(start);
        if (!specs.isEmpty()) {
            methodSpecBuilder.addParameters(specs);
            for (ParameterSpec parameter : specs) {
                createNewOptionAndCall.append(parameter.name);
                if (memoize && this.isAndroidContext(parameter)) {
                    createNewOptionAndCall.append(".getApplicationContext()");
                }
                createNewOptionAndCall.append(", ");
            }
            createNewOptionAndCall = new StringBuilder(createNewOptionAndCall.substring(0, createNewOptionAndCall.length() - 2));
        }
        createNewOptionAndCall.append(")");
        return createNewOptionAndCall;
    }

    private boolean isAndroidContext(ParameterSpec parameter) {
        return parameter.type.toString().equals("android.content.Context");
    }

    private MethodAndStaticVar generateStaticMethodEquivalentForExtensionMethod(ExecutableElement instanceMethod) {
        String staticMethodName = RequestOptionsGenerator.getStaticMethodName(instanceMethod);
        String instanceMethodName = instanceMethod.getSimpleName().toString();
        if (Strings.isNullOrEmpty(staticMethodName)) {
            staticMethodName = instanceMethodName.startsWith("dont") ? "no" + instanceMethodName.replace("dont", "") : instanceMethodName + "Of";
        }
        boolean memoize = RequestOptionsGenerator.memoizeStaticMethodFromAnnotation(instanceMethod);
        Preconditions.checkNotNull(staticMethodName);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder(staticMethodName).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(instanceMethod)).varargs(instanceMethod.isVarArgs()).returns(this.glideOptionsName);
        List<? extends VariableElement> parameters = instanceMethod.getParameters();
        if (parameters.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty parameters for: " + instanceMethod);
        }
        parameters = parameters.subList(1, parameters.size());
        StringBuilder createNewOptionAndCall = this.createNewOptionAndCall(memoize, methodSpecBuilder, "new $T().$L(", ProcessorUtil.getParameters(parameters));
        FieldSpec requiredStaticField = null;
        if (memoize) {
            String staticVariableName = staticMethodName + this.nextFieldId++;
            requiredStaticField = FieldSpec.builder(this.glideOptionsName, staticVariableName, new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC).build();
            methodSpecBuilder.beginControlFlow("if ($T.$N == null)", this.glideOptionsName, staticVariableName).addStatement("$T.$N =\n" + createNewOptionAndCall + ".$N", this.glideOptionsName, staticVariableName, this.glideOptionsName, instanceMethodName, "autoClone()").endControlFlow().addStatement("return $T.$N", this.glideOptionsName, staticVariableName);
        } else {
            methodSpecBuilder.addStatement("return " + createNewOptionAndCall, this.glideOptionsName, instanceMethodName);
        }
        List<? extends TypeParameterElement> typeParameters = instanceMethod.getTypeParameters();
        for (TypeParameterElement typeParameterElement : typeParameters) {
            methodSpecBuilder.addTypeVariable(TypeVariableName.get(typeParameterElement.getSimpleName().toString()));
        }
        methodSpecBuilder.addAnnotation(ProcessorUtil.checkResult());
        return new MethodAndStaticVar(methodSpecBuilder.build(), requiredStaticField);
    }

    private static String getStaticMethodName(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        String result = glideOption != null ? glideOption.staticMethodName() : null;
        return Strings.emptyToNull(result);
    }

    private static boolean memoizeStaticMethodFromAnnotation(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        return glideOption != null && glideOption.memoizeStaticMethod();
    }

    private static boolean skipStaticMethod(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        return glideOption != null && glideOption.skipStaticMethod();
    }

    private static final class MethodSignature {
        private final TypeName returnType;
        private final List<TypeName> parameterTypes;
        private final boolean isStatic;
        private final String name;

        MethodSignature(MethodSpec spec) {
            this.name = spec.name;
            this.isStatic = spec.modifiers.contains((Object)Modifier.STATIC);
            this.returnType = spec.returnType;
            this.parameterTypes = Lists.transform(spec.parameters, new Function<ParameterSpec, TypeName>(){

                @Override
                public TypeName apply(ParameterSpec parameterSpec) {
                    return parameterSpec.type;
                }
            });
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature other = (MethodSignature)o;
                return this.name.equals(other.name) && this.returnType.equals(other.returnType) && this.parameterTypes.equals(other.parameterTypes) && this.isStatic == other.isStatic;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.name, this.returnType, this.parameterTypes, this.isStatic);
        }
    }

    private static final class MethodAndStaticVar {
        final MethodSpec method;
        final FieldSpec staticField;

        MethodAndStaticVar(MethodSpec method) {
            this(method, null);
        }

        MethodAndStaticVar(MethodSpec method, FieldSpec staticField) {
            this.method = method;
            this.staticField = staticField;
        }
    }
}

