/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.status.transitor.bean.impl;

import com.godmonth.status.transitor.bean.intf.BeanStatusTransitor;
import com.godmonth.status.transitor.bean.intf.StatusEntry;
import com.godmonth.status.transitor.bean.intf.StatusExit;
import com.godmonth.status.transitor.core.intf.StatusTransitor;
import java.util.Collections;
import java.util.Map;
import jodd.bean.BeanUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanStatusTransitorImpl<MODEL, STATUS, TRIGGER>
implements BeanStatusTransitor<MODEL, TRIGGER> {
    private static final Logger logger = LoggerFactory.getLogger(BeanStatusTransitorImpl.class);
    private StatusTransitor<STATUS, TRIGGER> statusTransitor;
    protected String statusPropertyName;
    private Map<STATUS, StatusExit<MODEL>> statusExitMap = Collections.emptyMap();
    private Map<STATUS, StatusEntry<MODEL>> statusEntryMap = Collections.emptyMap();

    @Override
    public MODEL transit(MODEL model, TRIGGER trigger) {
        STATUS nextStatus = this.beforeChange(model, trigger);
        MODEL mergedModel = this.mergeModel(model, nextStatus);
        this.afterChange(mergedModel, nextStatus);
        return mergedModel;
    }

    protected MODEL mergeModel(MODEL model, STATUS nextStatus) {
        BeanUtil.silent.setProperty(model, this.statusPropertyName, nextStatus);
        return model;
    }

    protected STATUS beforeChange(MODEL model, TRIGGER trigger) {
        Object status = BeanUtil.silent.getProperty(model, this.statusPropertyName);
        Validate.notNull((Object)status, (String)"status is null", (Object[])new Object[0]);
        Object nextStatus = this.statusTransitor.transit(status, trigger);
        Validate.notNull((Object)nextStatus, (String)"nextStatus is null", (Object[])new Object[0]);
        if (this.statusExitMap.get(status) != null) {
            this.statusExitMap.get(status).previousStatusExit(model);
        }
        return (STATUS)nextStatus;
    }

    protected void afterChange(MODEL model, STATUS status) {
        if (this.statusEntryMap.get(status) != null) {
            this.statusEntryMap.get(status).nextStatusEntry(model);
        }
    }

    public void setStatusTransitor(StatusTransitor<STATUS, TRIGGER> statusTransitor) {
        this.statusTransitor = statusTransitor;
    }

    public void setStatusExitMap(Map<STATUS, StatusExit<MODEL>> statusExitMap) {
        this.statusExitMap = statusExitMap;
    }

    public void setStatusEntryMap(Map<STATUS, StatusEntry<MODEL>> statusEntryMap) {
        this.statusEntryMap = statusEntryMap;
    }

    public void setStatusPropertyName(String statusPropertyName) {
        this.statusPropertyName = statusPropertyName;
    }
}

