/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.status.transitor.definition.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.godmonth.status.transitor.definition.intf.StatusDefinition;
import com.godmonth.status.transitor.definition.intf.TriggerDefinition;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDefinition {
    private static final Logger logger = LoggerFactory.getLogger(JsonDefinition.class);

    public static <STATUS, TRIGGER> Map<STATUS, Map<TRIGGER, STATUS>> parse(String json, Class<? extends StatusDefinition<STATUS, TRIGGER>> definitionClass) {
        List statusDefinitions;
        logger.trace("json:{}", (Object)json);
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        ObjectMapper objectMapper = new ObjectMapper();
        CollectionType collectionType = typeFactory.constructCollectionType(List.class, definitionClass);
        try {
            statusDefinitions = (List)objectMapper.readValue(json, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
        HashMap statusConfigs = new HashMap();
        for (StatusDefinition statusDefinition : statusDefinitions) {
            Validate.notNull(statusDefinition.getStatus(), (String)"status is null", (Object[])new Object[0]);
            Validate.notNull(statusDefinition.getTriggers(), (String)"triggerDefinitions is null", (Object[])new Object[0]);
            HashMap triggerConfig = new HashMap();
            for (TriggerDefinition triggerDefinition : statusDefinition.getTriggers()) {
                Validate.notNull(triggerDefinition.getTrigger(), (String)"trigger is null", (Object[])new Object[0]);
                Validate.notNull(triggerDefinition.getNextStatus(), (String)"nextStatus is null", (Object[])new Object[0]);
                triggerConfig.put(triggerDefinition.getTrigger(), triggerDefinition.getNextStatus());
            }
            statusConfigs.put(statusDefinition.getStatus(), triggerConfig);
        }
        return statusConfigs;
    }
}

