/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.status.transitor.definition.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.godmonth.status.transitor.definition.intf.StatusDefinition;
import com.godmonth.status.transitor.definition.intf.TriggerDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.springframework.core.io.Resource;

public class JsonDefinitionBuilder<STATUS, TRIGGER> {
    private Resource resource;
    private Class<? extends StatusDefinition<STATUS, TRIGGER>> definitionClass;

    public Map<STATUS, Map<TRIGGER, STATUS>> build() {
        List statusDefinitions;
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        ObjectMapper objectMapper = new ObjectMapper();
        CollectionType collectionType = typeFactory.constructCollectionType(List.class, this.definitionClass);
        InputStream inputStream = null;
        try {
            inputStream = this.resource.getInputStream();
            statusDefinitions = (List)objectMapper.readValue(inputStream, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        HashMap statusConfigs = new HashMap();
        for (StatusDefinition statusDefinition : statusDefinitions) {
            Validate.notNull(statusDefinition.getStatus(), (String)"status is null", (Object[])new Object[0]);
            Validate.notNull(statusDefinition.getTriggers(), (String)"triggerDefinitions is null", (Object[])new Object[0]);
            HashMap triggerConfig = new HashMap();
            for (TriggerDefinition triggerDefinition : statusDefinition.getTriggers()) {
                Validate.notNull(triggerDefinition.getTrigger(), (String)"trigger is null", (Object[])new Object[0]);
                Validate.notNull(triggerDefinition.getNextStatus(), (String)"nextStatus is null", (Object[])new Object[0]);
                triggerConfig.put(triggerDefinition.getTrigger(), triggerDefinition.getNextStatus());
            }
            statusConfigs.put(statusDefinition.getStatus(), triggerConfig);
        }
        return statusConfigs;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setDefinitionClass(Class<? extends StatusDefinition<STATUS, TRIGGER>> definitionClass) {
        this.definitionClass = definitionClass;
    }
}

