/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.NetworkState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.android.internal.util.Objects;

public class NetworkIdentity {
    public static final boolean COMBINE_SUBTYPE_ENABLED = true;
    public static final int SUBTYPE_COMBINED = -1;
    final int mType;
    final int mSubType;
    final String mSubscriberId;
    final String mNetworkId;
    final boolean mRoaming;

    public NetworkIdentity(int type, int subType, String subscriberId, String networkId, boolean roaming) {
        this.mType = type;
        this.mSubType = -1;
        this.mSubscriberId = subscriberId;
        this.mNetworkId = networkId;
        this.mRoaming = roaming;
    }

    public static String getNetworkTypeName(int type) {
        switch (type) {
            case 0: {
                return "MOBILE";
            }
            case 1: {
                return "WIFI";
            }
            case 2: {
                return "MOBILE_MMS";
            }
            case 3: {
                return "MOBILE_SUPL";
            }
            case 4: {
                return "MOBILE_DUN";
            }
            case 5: {
                return "MOBILE_HIPRI";
            }
            case 6: {
                return "WIMAX";
            }
            case 7: {
                return "BLUETOOTH";
            }
            case 8: {
                return "DUMMY";
            }
            case 9: {
                return "ETHERNET";
            }
            case 10: {
                return "MOBILE_FOTA";
            }
            case 11: {
                return "MOBILE_IMS";
            }
            case 12: {
                return "MOBILE_CBS";
            }
            case 13: {
                return "WIFI_P2P";
            }
        }
        return Integer.toString(type);
    }

    public static boolean isNetworkTypeMobile(int networkType) {
        switch (networkType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.mType, this.mSubType, this.mSubscriberId, this.mNetworkId, this.mRoaming);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkIdentity) {
            NetworkIdentity ident = (NetworkIdentity)obj;
            return this.mType == ident.mType && this.mSubType == ident.mSubType && this.mRoaming == ident.mRoaming && Objects.equal(this.mSubscriberId, ident.mSubscriberId) && Objects.equal(this.mNetworkId, ident.mNetworkId);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("type=").append(NetworkIdentity.getNetworkTypeName(this.mType));
        builder.append(", subType=");
        builder.append("COMBINED");
        if (this.mSubscriberId != null) {
            builder.append(", subscriberId=").append(NetworkIdentity.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mNetworkId != null) {
            builder.append(", networkId=").append(this.mNetworkId);
        }
        if (this.mRoaming) {
            builder.append(", ROAMING");
        }
        return builder.append("]").toString();
    }

    public int getType() {
        return this.mType;
    }

    public int getSubType() {
        return this.mSubType;
    }

    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public String getNetworkId() {
        return this.mNetworkId;
    }

    public boolean getRoaming() {
        return this.mRoaming;
    }

    public static String scrubSubscriberId(String subscriberId) {
        if ("eng".equals(Build.TYPE)) {
            return subscriberId;
        }
        if (subscriberId != null) {
            return subscriberId.substring(0, Math.min(6, subscriberId.length())) + "...";
        }
        return "null";
    }

    public static NetworkIdentity buildNetworkIdentity(Context context, NetworkState state) {
        int type = state.networkInfo.getType();
        int subType = state.networkInfo.getSubtype();
        String subscriberId = null;
        String networkId = null;
        boolean roaming = false;
        if (NetworkIdentity.isNetworkTypeMobile(type)) {
            TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
            roaming = telephony.isNetworkRoaming();
            subscriberId = state.subscriberId != null ? state.subscriberId : telephony.getSubscriberId();
        } else if (type == 1) {
            WifiManager wifi;
            WifiInfo info;
            networkId = state.networkId != null ? state.networkId : ((info = (wifi = (WifiManager)context.getSystemService("wifi")).getConnectionInfo()) != null ? info.getSSID() : null);
        }
        return new NetworkIdentity(type, subType, subscriberId, networkId, roaming);
    }
}

