/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.layout;

import android.content.Context;
import android.content.res.Configuration;
import com.android.mms.layout.HVGALayoutParameters;
import com.android.mms.layout.LayoutParameters;
import com.klinker.android.logger.Log;

public class LayoutManager {
    private static final String TAG = "Mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private final Context mContext;
    private LayoutParameters mLayoutParams;
    private static LayoutManager sInstance;

    private LayoutManager(Context context) {
        this.mContext = context;
        this.initLayoutParameters(context.getResources().getConfiguration());
    }

    private void initLayoutParameters(Configuration configuration) {
        this.mLayoutParams = this.getLayoutParameters(configuration.orientation == 1 ? 11 : 10);
    }

    private LayoutParameters getLayoutParameters(int displayType) {
        switch (displayType) {
            case 10: {
                return new HVGALayoutParameters(this.mContext, 10);
            }
            case 11: {
                return new HVGALayoutParameters(this.mContext, 11);
            }
        }
        throw new IllegalArgumentException("Unsupported display type: " + displayType);
    }

    public static void init(Context context) {
        if (sInstance != null) {
            Log.w((String)TAG, (String)"Already initialized.");
        }
        sInstance = new LayoutManager(context);
    }

    public static LayoutManager getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("Uninitialized.");
        }
        return sInstance;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.initLayoutParameters(newConfig);
    }

    public int getLayoutType() {
        return this.mLayoutParams.getType();
    }

    public int getLayoutWidth() {
        return this.mLayoutParams.getWidth();
    }

    public int getLayoutHeight() {
        return this.mLayoutParams.getHeight();
    }

    public LayoutParameters getLayoutParameters() {
        return this.mLayoutParams;
    }
}

