/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.content.ContentValues;
import com.android.mms.service_alt.MmsConfig;
import com.klinker.android.logger.Log;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MmsConfigXmlProcessor {
    private static final String TAG = "MmsConfigXmlProcessor";
    private static final String TAG_MMS_CONFIG = "mms_config";
    private MmsConfigHandler mMmsConfigHandler;
    private final StringBuilder mLogStringBuilder = new StringBuilder();
    private final XmlPullParser mInputParser;

    private MmsConfigXmlProcessor(XmlPullParser parser) {
        this.mInputParser = parser;
        this.mMmsConfigHandler = null;
    }

    public static MmsConfigXmlProcessor get(XmlPullParser parser) {
        return new MmsConfigXmlProcessor(parser);
    }

    public MmsConfigXmlProcessor setMmsConfigHandler(MmsConfigHandler handler) {
        this.mMmsConfigHandler = handler;
        return this;
    }

    private int advanceToNextEvent(int eventType) throws XmlPullParserException, IOException {
        int nextEvent;
        while ((nextEvent = this.mInputParser.next()) != eventType && nextEvent != 1) {
        }
        return nextEvent;
    }

    public void process() {
        try {
            if (this.advanceToNextEvent(2) != 2) {
                throw new XmlPullParserException("MmsConfigXmlProcessor: expecting start tag @" + this.xmlParserDebugContext());
            }
            ContentValues values = new ContentValues();
            String tagName = this.mInputParser.getName();
            if (TAG_MMS_CONFIG.equals(tagName)) {
                this.processMmsConfig();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("MmsConfigXmlProcessor: I/O failure " + e), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            Log.e((String)TAG, (String)("MmsConfigXmlProcessor: parsing failure " + (Object)((Object)e)), (Throwable)e);
        }
    }

    private static String xmlParserEventString(int event) {
        switch (event) {
            case 0: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "START_TAG";
            }
            case 3: {
                return "END_TAG";
            }
            case 4: {
                return "TEXT";
            }
        }
        return Integer.toString(event);
    }

    private String xmlParserDebugContext() {
        this.mLogStringBuilder.setLength(0);
        if (this.mInputParser != null) {
            try {
                int eventType = this.mInputParser.getEventType();
                this.mLogStringBuilder.append(MmsConfigXmlProcessor.xmlParserEventString(eventType));
                if (eventType == 2 || eventType == 3 || eventType == 4) {
                    this.mLogStringBuilder.append('<').append(this.mInputParser.getName());
                    for (int i = 0; i < this.mInputParser.getAttributeCount(); ++i) {
                        this.mLogStringBuilder.append(' ').append(this.mInputParser.getAttributeName(i)).append('=').append(this.mInputParser.getAttributeValue(i));
                    }
                    this.mLogStringBuilder.append("/>");
                }
                return this.mLogStringBuilder.toString();
            }
            catch (XmlPullParserException e) {
                Log.e((String)TAG, (String)("xmlParserDebugContext: " + (Object)((Object)e)), (Throwable)e);
            }
        }
        return "Unknown";
    }

    private void processMmsConfig() throws IOException, XmlPullParserException {
        int nextEvent;
        while (true) {
            if ((nextEvent = this.mInputParser.next()) == 4) {
                continue;
            }
            if (nextEvent != 2) break;
            this.processMmsConfigKeyValue();
        }
        if (nextEvent != 3) {
            throw new XmlPullParserException("MmsConfig: expecting start or end tag @" + this.xmlParserDebugContext());
        }
    }

    private void processMmsConfigKeyValue() throws IOException, XmlPullParserException {
        String key = this.mInputParser.getAttributeValue(null, "name");
        String type = this.mInputParser.getName();
        int nextEvent = this.mInputParser.next();
        String value = null;
        if (nextEvent == 4) {
            value = this.mInputParser.getText();
            nextEvent = this.mInputParser.next();
        }
        if (nextEvent != 3) {
            throw new XmlPullParserException("MmsConfigXmlProcessor: expecting end tag @" + this.xmlParserDebugContext());
        }
        if (MmsConfig.isValidKey(key, type)) {
            if (this.mMmsConfigHandler != null) {
                this.mMmsConfigHandler.process(key, value, type);
            }
        } else {
            Log.w((String)TAG, (String)("MmsConfig: invalid key=" + key + " or type=" + type));
        }
    }

    public static interface MmsConfigHandler {
        public void process(String var1, String var2, String var3);
    }
}

