/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.service_alt.MmsConfig;
import com.android.mms.service_alt.MmsNetworkManager;
import com.android.mms.service_alt.exception.MmsHttpException;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.Network;
import com.squareup.okhttp.internal.huc.HttpURLConnectionImpl;
import com.squareup.okhttp.internal.huc.HttpsURLConnectionImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

public class MmsHttpClient {
    private static final String TAG = "MmsHttpClient";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_VALUE_ACCEPT = "*/*, application/vnd.wap.mms-message, application/vnd.wap.sic";
    private static final String HEADER_VALUE_CONTENT_TYPE_WITH_CHARSET = "application/vnd.wap.mms-message; charset=utf-8";
    private static final String HEADER_VALUE_CONTENT_TYPE_WITHOUT_CHARSET = "application/vnd.wap.mms-message";
    private final Context mContext;
    private final SocketFactory mSocketFactory;
    private final MmsNetworkManager mHostResolver;
    private final ConnectionPool mConnectionPool;
    private static final String ACCEPT_LANG_FOR_US_LOCALE = "en-US";
    private static final Pattern MACRO_P = Pattern.compile("##(\\S+)##");

    public MmsHttpClient(Context context, SocketFactory socketFactory, MmsNetworkManager hostResolver, ConnectionPool connectionPool) {
        this.mContext = context;
        this.mSocketFactory = socketFactory;
        this.mHostResolver = hostResolver;
        this.mConnectionPool = connectionPool;
    }

    public byte[] execute(String urlString, byte[] pdu, String method, boolean isProxySet, String proxyHost, int proxyPort, MmsConfig.Overridden mmsConfig) throws MmsHttpException {
        Log.d((String)TAG, (String)("HTTP: " + method + " " + MmsHttpClient.redactUrlForNonVerbose(urlString) + (isProxySet ? ", proxy=" + proxyHost + ":" + proxyPort : "") + ", PDU size=" + (pdu != null ? pdu.length : 0)));
        MmsHttpClient.checkMethod(method);
        HttpURLConnection connection = null;
        try {
            Proxy proxy = null;
            if (isProxySet) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            }
            URL url = new URL(urlString);
            connection = this.openConnection(url, proxy);
            connection.setDoInput(true);
            connection.setConnectTimeout(mmsConfig.getHttpSocketTimeout());
            connection.setRequestProperty(HEADER_ACCEPT, HEADER_VALUE_ACCEPT);
            connection.setRequestProperty(HEADER_ACCEPT_LANGUAGE, MmsHttpClient.getCurrentAcceptLanguage(Locale.getDefault()));
            String userAgent = mmsConfig.getUserAgent();
            Log.i((String)TAG, (String)("HTTP: User-Agent=" + userAgent));
            connection.setRequestProperty(HEADER_USER_AGENT, userAgent);
            String uaProfUrlTagName = mmsConfig.getUaProfTagName();
            String uaProfUrl = mmsConfig.getUaProfUrl();
            if (uaProfUrl != null) {
                Log.i((String)TAG, (String)("HTTP: UaProfUrl=" + uaProfUrl));
                connection.setRequestProperty(uaProfUrlTagName, uaProfUrl);
            }
            this.addExtraHeaders(connection, mmsConfig);
            if (METHOD_POST.equals(method)) {
                if (pdu == null || pdu.length < 1) {
                    Log.e((String)TAG, (String)"HTTP: empty pdu");
                    throw new MmsHttpException(0, "Sending empty PDU");
                }
                connection.setDoOutput(true);
                connection.setRequestMethod(METHOD_POST);
                if (mmsConfig.getSupportHttpCharsetHeader()) {
                    connection.setRequestProperty(HEADER_CONTENT_TYPE, HEADER_VALUE_CONTENT_TYPE_WITH_CHARSET);
                } else {
                    connection.setRequestProperty(HEADER_CONTENT_TYPE, HEADER_VALUE_CONTENT_TYPE_WITHOUT_CHARSET);
                }
                if (Log.isLoggable((String)TAG, (int)2)) {
                    MmsHttpClient.logHttpHeaders(connection.getRequestProperties());
                }
                connection.setFixedLengthStreamingMode(pdu.length);
                BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
                ((OutputStream)out).write(pdu);
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            } else if (METHOD_GET.equals(method)) {
                if (Log.isLoggable((String)TAG, (int)2)) {
                    MmsHttpClient.logHttpHeaders(connection.getRequestProperties());
                }
                connection.setRequestMethod(METHOD_GET);
            }
            int responseCode = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            Log.d((String)TAG, (String)("HTTP: " + responseCode + " " + responseMessage));
            if (Log.isLoggable((String)TAG, (int)2)) {
                MmsHttpClient.logHttpHeaders(connection.getHeaderFields());
            }
            if (responseCode / 100 != 2) {
                throw new MmsHttpException(responseCode, responseMessage);
            }
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int count = 0;
            while ((count = ((InputStream)in).read(buf)) > 0) {
                byteOut.write(buf, 0, count);
            }
            ((InputStream)in).close();
            byte[] responseBody = byteOut.toByteArray();
            Log.d((String)TAG, (String)("HTTP: response size=" + (responseBody != null ? responseBody.length : 0)));
            byte[] byArray = responseBody;
            return byArray;
        }
        catch (MalformedURLException e) {
            String redactedUrl = MmsHttpClient.redactUrlForNonVerbose(urlString);
            Log.e((String)TAG, (String)("HTTP: invalid URL " + redactedUrl), (Throwable)e);
            throw new MmsHttpException(0, "Invalid URL " + redactedUrl, e);
        }
        catch (ProtocolException e) {
            String redactedUrl = MmsHttpClient.redactUrlForNonVerbose(urlString);
            Log.e((String)TAG, (String)("HTTP: invalid URL protocol " + redactedUrl), (Throwable)e);
            throw new MmsHttpException(0, "Invalid URL protocol " + redactedUrl, e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"HTTP: IO failure", (Throwable)e);
            throw new MmsHttpException(0, (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpURLConnection openConnection(URL url, final Proxy proxy) throws MalformedURLException {
        String protocol = url.getProtocol();
        if (protocol.equals("http")) {
            OkHttpClient okHttpClient = new OkHttpClient();
            okHttpClient.setFollowRedirects(false);
            okHttpClient.setProtocols(Arrays.asList(Protocol.HTTP_1_1));
            okHttpClient.setProxySelector(new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    if (proxy != null) {
                        return Arrays.asList(proxy);
                    }
                    return new ArrayList<Proxy>();
                }

                @Override
                public void connectFailed(URI uri, SocketAddress address, IOException failure) {
                }
            });
            okHttpClient.setAuthenticator(new Authenticator(){

                public Request authenticate(Proxy proxy, Response response) throws IOException {
                    return null;
                }

                public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
                    return null;
                }
            });
            okHttpClient.setConnectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT));
            okHttpClient.setConnectionPool(new ConnectionPool(3, 60000L));
            okHttpClient.setSocketFactory(SocketFactory.getDefault());
            Internal.instance.setNetwork(okHttpClient, (Network)this.mHostResolver);
            if (proxy != null) {
                okHttpClient.setProxy(proxy);
            }
            return new HttpURLConnectionImpl(url, okHttpClient);
        }
        if (protocol.equals("https")) {
            OkHttpClient okHttpClient = new OkHttpClient();
            okHttpClient.setProtocols(Arrays.asList(Protocol.HTTP_1_1));
            HostnameVerifier verifier = HttpsURLConnection.getDefaultHostnameVerifier();
            okHttpClient.setHostnameVerifier(verifier);
            okHttpClient.setSslSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory());
            okHttpClient.setProxySelector(new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    return Arrays.asList(proxy);
                }

                @Override
                public void connectFailed(URI uri, SocketAddress address, IOException failure) {
                }
            });
            okHttpClient.setAuthenticator(new Authenticator(){

                public Request authenticate(Proxy proxy, Response response) throws IOException {
                    return null;
                }

                public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
                    return null;
                }
            });
            okHttpClient.setConnectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT));
            okHttpClient.setConnectionPool(new ConnectionPool(3, 60000L));
            Internal.instance.setNetwork(okHttpClient, (Network)this.mHostResolver);
            return new HttpsURLConnectionImpl(url, okHttpClient);
        }
        throw new MalformedURLException("Invalid URL or unrecognized protocol " + protocol);
    }

    private static void logHttpHeaders(Map<String, List<String>> headers) {
        StringBuilder sb = new StringBuilder();
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                List<String> values = entry.getValue();
                if (values == null) continue;
                for (String value : values) {
                    sb.append(key).append('=').append(value).append('\n');
                }
            }
            Log.v((String)TAG, (String)("HTTP: headers\n" + sb.toString()));
        }
    }

    private static void checkMethod(String method) throws MmsHttpException {
        if (!METHOD_GET.equals(method) && !METHOD_POST.equals(method)) {
            throw new MmsHttpException(0, "Invalid method " + method);
        }
    }

    public static String getCurrentAcceptLanguage(Locale locale) {
        StringBuilder buffer = new StringBuilder();
        MmsHttpClient.addLocaleToHttpAcceptLanguage(buffer, locale);
        if (!Locale.US.equals(locale)) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(ACCEPT_LANG_FOR_US_LOCALE);
        }
        return buffer.toString();
    }

    private static String convertObsoleteLanguageCodeToNew(String langCode) {
        if (langCode == null) {
            return null;
        }
        if ("iw".equals(langCode)) {
            return "he";
        }
        if ("in".equals(langCode)) {
            return "id";
        }
        if ("ji".equals(langCode)) {
            return "yi";
        }
        return langCode;
    }

    private static void addLocaleToHttpAcceptLanguage(StringBuilder builder, Locale locale) {
        String language = MmsHttpClient.convertObsoleteLanguageCodeToNew(locale.getLanguage());
        if (language != null) {
            builder.append(language);
            String country = locale.getCountry();
            if (country != null) {
                builder.append("-");
                builder.append(country);
            }
        }
    }

    private static String resolveMacro(Context context, String value, MmsConfig.Overridden mmsConfig) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        Matcher matcher = MACRO_P.matcher(value);
        int nextStart = 0;
        StringBuilder replaced = null;
        while (matcher.find()) {
            String macro;
            String macroValue;
            int matchedStart;
            if (replaced == null) {
                replaced = new StringBuilder();
            }
            if ((matchedStart = matcher.start()) > nextStart) {
                replaced.append(value.substring(nextStart, matchedStart));
            }
            if ((macroValue = mmsConfig.getHttpParamMacro(context, macro = matcher.group(1))) != null) {
                replaced.append(macroValue);
            } else {
                Log.w((String)TAG, (String)("HTTP: invalid macro " + macro));
            }
            nextStart = matcher.end();
        }
        if (replaced != null && nextStart < value.length()) {
            replaced.append(value.substring(nextStart));
        }
        return replaced == null ? value : replaced.toString();
    }

    private void addExtraHeaders(HttpURLConnection connection, MmsConfig.Overridden mmsConfig) {
        String extraHttpParams = mmsConfig.getHttpParams();
        if (!TextUtils.isEmpty((CharSequence)extraHttpParams)) {
            String[] paramList;
            for (String paramPair : paramList = extraHttpParams.split("\\|")) {
                String[] splitPair = paramPair.split(":", 2);
                if (splitPair.length != 2) continue;
                String name = splitPair[0].trim();
                String value = MmsHttpClient.resolveMacro(this.mContext, splitPair[1].trim(), mmsConfig);
                if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)value)) continue;
                connection.setRequestProperty(name, value);
            }
        }
    }

    public static String redactUrlForNonVerbose(String urlString) {
        if (Log.isLoggable((String)TAG, (int)2)) {
            return urlString;
        }
        if (TextUtils.isEmpty((CharSequence)urlString)) {
            return urlString;
        }
        String protocol = "http";
        String host = "";
        try {
            URL url = new URL(urlString);
            protocol = url.getProtocol();
            host = url.getHost();
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append(protocol).append("://").append(host).append("[").append(urlString.length()).append("]");
        return sb.toString();
    }
}

