/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.Context;
import android.net.http.AndroidHttpClient;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.mms.MmsConfig;
import com.android.mms.transaction.ProgressCallbackEntity;
import com.klinker.android.logger.Log;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpUtils {
    private static final String TAG = "Mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    public static final int HTTP_POST_METHOD = 1;
    public static final int HTTP_GET_METHOD = 2;
    private static final int MMS_READ_BUFFER = 4096;
    private static final String HDR_VALUE_ACCEPT_LANGUAGE = HttpUtils.getCurrentAcceptLanguage(Locale.getDefault());
    private static final String HDR_KEY_ACCEPT = "Accept";
    private static final String HDR_KEY_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String HDR_VALUE_ACCEPT = "*/*, application/vnd.wap.mms-message, application/vnd.wap.sic";
    private static final String ACCEPT_LANG_FOR_US_LOCALE = "en-US";

    private HttpUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] httpConnection(Context context, long token, String url, byte[] pdu, int method, boolean isProxySet, String proxyHost, int proxyPort) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null.");
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)"httpConnection: params list");
            Log.v((String)TAG, (String)("\ttoken\t\t= " + token));
            Log.v((String)TAG, (String)("\turl\t\t= " + url));
            Log.v((String)TAG, (String)("\tmethod\t\t= " + (method == 1 ? "POST" : (method == 2 ? "GET" : "UNKNOWN"))));
            Log.v((String)TAG, (String)("\tisProxySet\t= " + isProxySet));
            Log.v((String)TAG, (String)("\tproxyHost\t= " + proxyHost));
            Log.v((String)TAG, (String)("\tproxyPort\t= " + proxyPort));
        }
        try (AndroidHttpClient client = null;){
            byte[] body;
            block54: {
                String extraHttpParams;
                URI hostUrl = new URI(url);
                HttpHost target = new HttpHost(hostUrl.getHost(), hostUrl.getPort(), "http");
                client = HttpUtils.createHttpClient(context);
                HttpGet req = null;
                switch (method) {
                    case 1: {
                        ProgressCallbackEntity entity = new ProgressCallbackEntity(context, token, pdu);
                        entity.setContentType("application/vnd.wap.mms-message");
                        HttpPost post = new HttpPost(url);
                        post.setEntity((HttpEntity)entity);
                        req = post;
                        break;
                    }
                    case 2: {
                        req = new HttpGet(url);
                        break;
                    }
                    default: {
                        Log.e((String)TAG, (String)("Unknown HTTP method: " + method + ". Must be one of POST[" + 1 + "] or GET[" + 2 + "]."));
                        byte[] byArray = null;
                        return byArray;
                    }
                }
                HttpParams params = client.getParams();
                if (isProxySet) {
                    ConnRouteParams.setDefaultProxy((HttpParams)params, (HttpHost)new HttpHost(proxyHost, proxyPort));
                }
                req.setParams(params);
                req.addHeader(HDR_KEY_ACCEPT, HDR_VALUE_ACCEPT);
                String xWapProfileTagName = MmsConfig.getUaProfTagName();
                String xWapProfileUrl = MmsConfig.getUaProfUrl();
                if (xWapProfileUrl != null) {
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.d((String)TAG, (String)("[HttpUtils] httpConn: xWapProfUrl=" + xWapProfileUrl));
                    }
                    req.addHeader(xWapProfileTagName, xWapProfileUrl);
                }
                if ((extraHttpParams = MmsConfig.getHttpParams()) != null) {
                    String[] paramList;
                    String line1Number = ((TelephonyManager)context.getSystemService("phone")).getLine1Number();
                    String line1Key = MmsConfig.getHttpParamsLine1Key();
                    for (String paramPair : paramList = extraHttpParams.split("\\|")) {
                        String[] splitPair = paramPair.split(":", 2);
                        if (splitPair.length != 2) continue;
                        String name = splitPair[0].trim();
                        String value = splitPair[1].trim();
                        if (line1Key != null) {
                            value = value.replace(line1Key, line1Number);
                        }
                        if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)value)) continue;
                        req.addHeader(name, value);
                    }
                }
                req.addHeader(HDR_KEY_ACCEPT_LANGUAGE, HDR_VALUE_ACCEPT_LANGUAGE);
                HttpResponse response = client.execute(target, (HttpRequest)req);
                StatusLine status = response.getStatusLine();
                if (status.getStatusCode() != 200) {
                    throw new IOException("HTTP error: " + status.getReasonPhrase());
                }
                HttpEntity entity = response.getEntity();
                body = null;
                if (entity != null) {
                    try {
                        if (entity.getContentLength() > 0L) {
                            body = new byte[(int)entity.getContentLength()];
                            DataInputStream dis = new DataInputStream(entity.getContent());
                            try {
                                dis.readFully(body);
                            }
                            finally {
                                try {
                                    dis.close();
                                }
                                catch (IOException e) {
                                    Log.e((String)TAG, (String)("Error closing input stream: " + e.getMessage()));
                                }
                            }
                        }
                        if (!entity.isChunked()) break block54;
                        Log.v((String)TAG, (String)"httpConnection: transfer encoding is chunked");
                        int bytesTobeRead = MmsConfig.getMaxMessageSize();
                        byte[] tempBody = new byte[bytesTobeRead];
                        DataInputStream dis = new DataInputStream(entity.getContent());
                        try {
                            int bytesRead = 0;
                            int offset = 0;
                            boolean readError = false;
                            do {
                                try {
                                    bytesRead = dis.read(tempBody, offset, bytesTobeRead);
                                }
                                catch (IOException e) {
                                    readError = true;
                                    Log.e((String)TAG, (String)("httpConnection: error reading input stream" + e.getMessage()));
                                    break;
                                }
                                if (bytesRead <= 0) continue;
                                bytesTobeRead -= bytesRead;
                                offset += bytesRead;
                            } while (bytesRead >= 0 && bytesTobeRead > 0);
                            if (bytesRead == -1 && offset > 0 && !readError) {
                                body = new byte[offset];
                                System.arraycopy(tempBody, 0, body, 0, offset);
                                Log.v((String)TAG, (String)("httpConnection: Chunked response length [" + Integer.toString(offset) + "]"));
                            } else {
                                Log.e((String)TAG, (String)"httpConnection: Response entity too large or empty");
                            }
                        }
                        finally {
                            try {
                                dis.close();
                            }
                            catch (IOException e) {
                                Log.e((String)TAG, (String)("Error closing input stream: " + e.getMessage()));
                            }
                        }
                    }
                    finally {
                        if (entity != null) {
                            entity.consumeContent();
                        }
                    }
                }
            }
            byte[] byArray = body;
            return byArray;
        }
        return null;
    }

    private static void handleHttpConnectionException(Exception exception, String url) throws IOException {
        Log.e((String)TAG, (String)("Url: " + url + "\n" + exception.getMessage()));
        IOException e = new IOException(exception.getMessage());
        e.initCause(exception);
        throw e;
    }

    private static AndroidHttpClient createHttpClient(Context context) {
        String userAgent = MmsConfig.getUserAgent();
        AndroidHttpClient client = AndroidHttpClient.newInstance((String)userAgent, (Context)context);
        HttpParams params = client.getParams();
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        int soTimeout = MmsConfig.getHttpSocketTimeout();
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("[HttpUtils] createHttpClient w/ socket timeout " + soTimeout + " ms, " + ", UA=" + userAgent));
        }
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)soTimeout);
        return client;
    }

    public static String getCurrentAcceptLanguage(Locale locale) {
        StringBuilder buffer = new StringBuilder();
        HttpUtils.addLocaleToHttpAcceptLanguage(buffer, locale);
        if (!Locale.US.equals(locale)) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(ACCEPT_LANG_FOR_US_LOCALE);
        }
        return buffer.toString();
    }

    private static String convertObsoleteLanguageCodeToNew(String langCode) {
        if (langCode == null) {
            return null;
        }
        if ("iw".equals(langCode)) {
            return "he";
        }
        if ("in".equals(langCode)) {
            return "id";
        }
        if ("ji".equals(langCode)) {
            return "yi";
        }
        return langCode;
    }

    private static void addLocaleToHttpAcceptLanguage(StringBuilder builder, Locale locale) {
        String language = HttpUtils.convertObsoleteLanguageCodeToNew(locale.getLanguage());
        if (language != null) {
            builder.append(language);
            String country = locale.getCountry();
            if (country != null) {
                builder.append("-");
                builder.append(country);
            }
        }
    }
}

