/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.widget.Toast;
import com.google.android.mms.APN;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class APNHelper {
    private Context context;

    public APNHelper(Context context) {
        this.context = context;
    }

    public List<APN> getMMSApns() {
        try {
            Cursor apnCursor = this.context.getContentResolver().query(Uri.withAppendedPath((Uri)Uri.parse((String)"content://telephony/carriers"), (String)"current"), null, null, null, null);
            if (apnCursor == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<APN> results = new ArrayList<APN>();
            if (apnCursor.moveToFirst()) {
                do {
                    String type;
                    if (TextUtils.isEmpty((CharSequence)(type = apnCursor.getString(apnCursor.getColumnIndex("type")))) || !type.equalsIgnoreCase("*") && !type.equalsIgnoreCase("mms")) continue;
                    String mmsc = apnCursor.getString(apnCursor.getColumnIndex("mmsc"));
                    String mmsProxy = apnCursor.getString(apnCursor.getColumnIndex("mmsproxy"));
                    String port = apnCursor.getString(apnCursor.getColumnIndex("mmsport"));
                    APN apn = new APN();
                    apn.MMSCenterUrl = mmsc;
                    apn.MMSProxy = mmsProxy;
                    apn.MMSPort = port;
                    results.add(apn);
                    Toast.makeText((Context)this.context, (CharSequence)(mmsc + " " + mmsProxy + " " + port), (int)1).show();
                } while (apnCursor.moveToNext());
            }
            apnCursor.close();
            return results;
        }
        catch (Exception e) {
            return Collections.EMPTY_LIST;
        }
    }
}

