/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu_alt;

import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.MultimediaMessagePdu;
import com.google.android.mms.pdu_alt.PduBody;
import com.google.android.mms.pdu_alt.PduHeaders;
import com.klinker.android.logger.Log;

public class SendReq
extends MultimediaMessagePdu {
    private static final String TAG = "SendReq";

    public SendReq() {
        try {
            this.setMessageType(128);
            this.setMmsVersion(18);
            this.setContentType("application/vnd.wap.multipart.related".getBytes());
            this.setFrom(new EncodedStringValue("insert-address-token".getBytes()));
            this.setTransactionId(this.generateTransactionId());
        }
        catch (InvalidHeaderValueException e) {
            Log.e((String)TAG, (String)"Unexpected InvalidHeaderValueException.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private byte[] generateTransactionId() {
        String transactionId = "T" + Long.toHexString(System.currentTimeMillis());
        return transactionId.getBytes();
    }

    public SendReq(byte[] contentType, EncodedStringValue from, int mmsVersion, byte[] transactionId) throws InvalidHeaderValueException {
        this.setMessageType(128);
        this.setContentType(contentType);
        this.setFrom(from);
        this.setMmsVersion(mmsVersion);
        this.setTransactionId(transactionId);
    }

    SendReq(PduHeaders headers) {
        super(headers);
    }

    SendReq(PduHeaders headers, PduBody body) {
        super(headers, body);
    }

    public EncodedStringValue[] getBcc() {
        return this.mPduHeaders.getEncodedStringValues(129);
    }

    public void addBcc(EncodedStringValue value) {
        this.mPduHeaders.appendEncodedStringValue(value, 129);
    }

    public void setBcc(EncodedStringValue[] value) {
        this.mPduHeaders.setEncodedStringValues(value, 129);
    }

    public EncodedStringValue[] getCc() {
        return this.mPduHeaders.getEncodedStringValues(130);
    }

    public void addCc(EncodedStringValue value) {
        this.mPduHeaders.appendEncodedStringValue(value, 130);
    }

    public void setCc(EncodedStringValue[] value) {
        this.mPduHeaders.setEncodedStringValues(value, 130);
    }

    public byte[] getContentType() {
        return this.mPduHeaders.getTextString(132);
    }

    public void setContentType(byte[] value) {
        this.mPduHeaders.setTextString(value, 132);
    }

    public int getDeliveryReport() {
        return this.mPduHeaders.getOctet(134);
    }

    public void setDeliveryReport(int value) throws InvalidHeaderValueException {
        this.mPduHeaders.setOctet(value, 134);
    }

    public long getExpiry() {
        return this.mPduHeaders.getLongInteger(136);
    }

    public void setExpiry(long value) {
        this.mPduHeaders.setLongInteger(value, 136);
    }

    public long getMessageSize() {
        return this.mPduHeaders.getLongInteger(142);
    }

    public void setMessageSize(long value) {
        this.mPduHeaders.setLongInteger(value, 142);
    }

    public byte[] getMessageClass() {
        return this.mPduHeaders.getTextString(138);
    }

    public void setMessageClass(byte[] value) {
        this.mPduHeaders.setTextString(value, 138);
    }

    public int getReadReport() {
        return this.mPduHeaders.getOctet(144);
    }

    public void setReadReport(int value) throws InvalidHeaderValueException {
        this.mPduHeaders.setOctet(value, 144);
    }

    public void setTo(EncodedStringValue[] value) {
        this.mPduHeaders.setEncodedStringValues(value, 151);
    }

    public byte[] getTransactionId() {
        return this.mPduHeaders.getTextString(152);
    }

    public void setTransactionId(byte[] value) {
        this.mPduHeaders.setTextString(value, 152);
    }
}

