/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.smil;

import com.android.mms.dom.smil.SmilDocumentImpl;
import com.google.android.mms.ContentType;
import com.google.android.mms.pdu_alt.PduBody;
import com.google.android.mms.pdu_alt.PduPart;
import com.klinker.android.logger.Log;
import org.w3c.dom.smil.SMILDocument;
import org.w3c.dom.smil.SMILElement;
import org.w3c.dom.smil.SMILLayoutElement;
import org.w3c.dom.smil.SMILMediaElement;
import org.w3c.dom.smil.SMILParElement;

public class SmilHelper {
    public static final String ELEMENT_TAG_TEXT = "text";
    public static final String ELEMENT_TAG_IMAGE = "img";
    public static final String ELEMENT_TAG_AUDIO = "audio";
    public static final String ELEMENT_TAG_VIDEO = "video";
    public static final String ELEMENT_TAG_VCARD = "vcard";

    public static SMILDocument createSmilDocument(PduBody pb) {
        SmilDocumentImpl document = new SmilDocumentImpl();
        SMILElement smil = (SMILElement)document.createElement("smil");
        smil.setAttribute("xmlns", "http://www.w3.org/2001/SMIL20/Language");
        document.appendChild(smil);
        SMILElement head = (SMILElement)document.createElement("head");
        smil.appendChild(head);
        SMILLayoutElement layout = (SMILLayoutElement)document.createElement("layout");
        head.appendChild(layout);
        SMILElement body = (SMILElement)document.createElement("body");
        smil.appendChild(body);
        SMILParElement par = SmilHelper.addPar(document);
        int partsNum = pb.getPartsNum();
        if (partsNum == 0) {
            return document;
        }
        boolean hasText = false;
        boolean hasMedia = false;
        for (int i = 0; i < partsNum; ++i) {
            SMILMediaElement textElement;
            PduPart part;
            String contentType;
            if (par == null || hasMedia && hasText) {
                par = SmilHelper.addPar(document);
                hasText = false;
                hasMedia = false;
            }
            if ((contentType = new String((part = pb.getPart(i)).getContentType())).equals("text/plain") || contentType.equalsIgnoreCase("application/vnd.wap.xhtml+xml") || contentType.equals("text/html")) {
                textElement = SmilHelper.createMediaElement(ELEMENT_TAG_TEXT, document, part.generateLocation());
                par.appendChild(textElement);
                hasText = true;
                continue;
            }
            if (ContentType.isImageType(contentType)) {
                SMILMediaElement imageElement = SmilHelper.createMediaElement(ELEMENT_TAG_IMAGE, document, part.generateLocation());
                par.appendChild(imageElement);
                hasMedia = true;
                continue;
            }
            if (ContentType.isVideoType(contentType)) {
                SMILMediaElement videoElement = SmilHelper.createMediaElement(ELEMENT_TAG_VIDEO, document, part.generateLocation());
                par.appendChild(videoElement);
                hasMedia = true;
                continue;
            }
            if (ContentType.isAudioType(contentType)) {
                SMILMediaElement audioElement = SmilHelper.createMediaElement(ELEMENT_TAG_AUDIO, document, part.generateLocation());
                par.appendChild(audioElement);
                hasMedia = true;
                continue;
            }
            if (contentType.equals("text/x-vCard")) {
                textElement = SmilHelper.createMediaElement(ELEMENT_TAG_VCARD, document, part.generateLocation());
                par.appendChild(textElement);
                hasMedia = true;
                continue;
            }
            Log.e((String)"creating_smil_document", (String)"unknown mimetype");
        }
        return document;
    }

    public static SMILParElement addPar(SMILDocument document) {
        SMILParElement par = (SMILParElement)document.createElement("par");
        par.setDur(8.0f);
        document.getBody().appendChild(par);
        return par;
    }

    public static SMILMediaElement createMediaElement(String tag, SMILDocument document, String src) {
        SMILMediaElement mediaElement = (SMILMediaElement)document.createElement(tag);
        mediaElement.setSrc(SmilHelper.escapeXML(src));
        return mediaElement;
    }

    public static String escapeXML(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }
}

