/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.util_alt;

import android.content.Context;
import android.drm.DrmConvertedStatus;
import android.drm.DrmManagerClient;
import com.klinker.android.logger.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DrmConvertSession {
    private DrmManagerClient mDrmClient;
    private int mConvertSessionId;
    private static final String TAG = "DrmConvertSession";

    private DrmConvertSession(DrmManagerClient drmClient, int convertSessionId) {
        this.mDrmClient = drmClient;
        this.mConvertSessionId = convertSessionId;
    }

    public static DrmConvertSession open(Context context, String mimeType) {
        DrmManagerClient drmClient = null;
        int convertSessionId = -1;
        if (context != null && mimeType != null && !mimeType.equals("")) {
            try {
                drmClient = new DrmManagerClient(context);
                try {
                    convertSessionId = drmClient.openConvertSession(mimeType);
                }
                catch (IllegalArgumentException e) {
                    Log.w((String)TAG, (String)("Conversion of Mimetype: " + mimeType + " is not supported."), (Throwable)e);
                }
                catch (IllegalStateException e) {
                    Log.w((String)TAG, (String)"Could not access Open DrmFramework.", (Throwable)e);
                }
            }
            catch (IllegalArgumentException e) {
                Log.w((String)TAG, (String)"DrmManagerClient instance could not be created, context is Illegal.");
            }
            catch (IllegalStateException e) {
                Log.w((String)TAG, (String)"DrmManagerClient didn't initialize properly.");
            }
        }
        if (drmClient == null || convertSessionId < 0) {
            return null;
        }
        return new DrmConvertSession(drmClient, convertSessionId);
    }

    public byte[] convert(byte[] inBuffer, int size) {
        byte[] result = null;
        if (inBuffer != null) {
            DrmConvertedStatus convertedStatus = null;
            try {
                if (size != inBuffer.length) {
                    byte[] buf = new byte[size];
                    System.arraycopy(inBuffer, 0, buf, 0, size);
                    convertedStatus = this.mDrmClient.convertData(this.mConvertSessionId, buf);
                } else {
                    convertedStatus = this.mDrmClient.convertData(this.mConvertSessionId, inBuffer);
                }
                if (convertedStatus != null && convertedStatus.statusCode == 1 && convertedStatus.convertedData != null) {
                    result = convertedStatus.convertedData;
                }
            }
            catch (IllegalArgumentException e) {
                Log.w((String)TAG, (String)("Buffer with data to convert is illegal. Convertsession: " + this.mConvertSessionId), (Throwable)e);
            }
            catch (IllegalStateException e) {
                Log.w((String)TAG, (String)("Could not convert data. Convertsession: " + this.mConvertSessionId), (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Parameter inBuffer is null");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close(String filename) {
        int result;
        block28: {
            DrmConvertedStatus convertedStatus = null;
            result = 491;
            if (this.mDrmClient != null && this.mConvertSessionId >= 0) {
                try {
                    convertedStatus = this.mDrmClient.closeConvertSession(this.mConvertSessionId);
                    if (convertedStatus == null || convertedStatus.statusCode != 1 || convertedStatus.convertedData == null) {
                        result = 406;
                        break block28;
                    }
                    RandomAccessFile rndAccessFile = null;
                    try {
                        rndAccessFile = new RandomAccessFile(filename, "rw");
                        rndAccessFile.seek(convertedStatus.offset);
                        rndAccessFile.write(convertedStatus.convertedData);
                        result = 200;
                    }
                    catch (FileNotFoundException e) {
                        result = 492;
                        Log.w((String)TAG, (String)("File: " + filename + " could not be found."), (Throwable)e);
                    }
                    catch (IOException e) {
                        result = 492;
                        Log.w((String)TAG, (String)("Could not access File: " + filename + " ."), (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        result = 492;
                        Log.w((String)TAG, (String)"Could not open file in mode: rw", (Throwable)e);
                    }
                    catch (SecurityException e) {
                        Log.w((String)TAG, (String)("Access to File: " + filename + " was denied denied by SecurityManager."), (Throwable)e);
                    }
                    finally {
                        if (rndAccessFile != null) {
                            try {
                                rndAccessFile.close();
                            }
                            catch (IOException e) {
                                result = 492;
                                Log.w((String)TAG, (String)("Failed to close File:" + filename + "."), (Throwable)e);
                            }
                        }
                    }
                }
                catch (IllegalStateException e) {
                    Log.w((String)TAG, (String)("Could not close convertsession. Convertsession: " + this.mConvertSessionId), (Throwable)e);
                }
            }
        }
        return result;
    }
}

