/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.util_alt;

import android.content.ContentUris;
import android.content.UriMatcher;
import android.net.Uri;
import android.provider.Telephony;
import com.google.android.mms.util_alt.AbstractCache;
import com.google.android.mms.util_alt.PduCacheEntry;
import java.util.HashMap;
import java.util.HashSet;

public final class PduCache
extends AbstractCache<Uri, PduCacheEntry> {
    private static final String TAG = "PduCache";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int MMS_ALL = 0;
    private static final int MMS_ALL_ID = 1;
    private static final int MMS_INBOX = 2;
    private static final int MMS_INBOX_ID = 3;
    private static final int MMS_SENT = 4;
    private static final int MMS_SENT_ID = 5;
    private static final int MMS_DRAFTS = 6;
    private static final int MMS_DRAFTS_ID = 7;
    private static final int MMS_OUTBOX = 8;
    private static final int MMS_OUTBOX_ID = 9;
    private static final int MMS_CONVERSATION = 10;
    private static final int MMS_CONVERSATION_ID = 11;
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final HashMap<Integer, Integer> MATCH_TO_MSGBOX_ID_MAP;
    private static PduCache sInstance;
    private final HashMap<Integer, HashSet<Uri>> mMessageBoxes = new HashMap();
    private final HashMap<Long, HashSet<Uri>> mThreads = new HashMap();
    private final HashSet<Uri> mUpdating = new HashSet();

    private PduCache() {
    }

    public static final synchronized PduCache getInstance() {
        if (sInstance == null) {
            sInstance = new PduCache();
        }
        return sInstance;
    }

    @Override
    public synchronized boolean put(Uri uri, PduCacheEntry entry) {
        Uri finalKey;
        boolean result;
        long threadId;
        HashSet<Object> thread;
        int msgBoxId = entry.getMessageBox();
        HashSet<Object> msgBox = this.mMessageBoxes.get(msgBoxId);
        if (msgBox == null) {
            msgBox = new HashSet();
            this.mMessageBoxes.put(msgBoxId, msgBox);
        }
        if ((thread = this.mThreads.get(threadId = entry.getThreadId())) == null) {
            thread = new HashSet();
            this.mThreads.put(threadId, thread);
        }
        if (result = super.put(finalKey = this.normalizeKey(uri), entry)) {
            msgBox.add(finalKey);
            thread.add(finalKey);
        }
        this.setUpdating(uri, false);
        return result;
    }

    public synchronized void setUpdating(Uri uri, boolean updating) {
        if (updating) {
            this.mUpdating.add(uri);
        } else {
            this.mUpdating.remove(uri);
        }
    }

    public synchronized boolean isUpdating(Uri uri) {
        return this.mUpdating.contains(uri);
    }

    @Override
    public synchronized PduCacheEntry purge(Uri uri) {
        int match = URI_MATCHER.match(uri);
        switch (match) {
            case 1: {
                return this.purgeSingleEntry(uri);
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                String msgId = uri.getLastPathSegment();
                return this.purgeSingleEntry(Uri.withAppendedPath((Uri)Telephony.Mms.CONTENT_URI, (String)msgId));
            }
            case 0: 
            case 10: {
                this.purgeAll();
                return null;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                this.purgeByMessageBox(MATCH_TO_MSGBOX_ID_MAP.get(match));
                return null;
            }
            case 11: {
                this.purgeByThreadId(ContentUris.parseId((Uri)uri));
                return null;
            }
        }
        return null;
    }

    private PduCacheEntry purgeSingleEntry(Uri key) {
        this.mUpdating.remove(key);
        PduCacheEntry entry = (PduCacheEntry)super.purge(key);
        if (entry != null) {
            this.removeFromThreads(key, entry);
            this.removeFromMessageBoxes(key, entry);
            return entry;
        }
        return null;
    }

    @Override
    public synchronized void purgeAll() {
        super.purgeAll();
        this.mMessageBoxes.clear();
        this.mThreads.clear();
        this.mUpdating.clear();
    }

    private Uri normalizeKey(Uri uri) {
        int match = URI_MATCHER.match(uri);
        Uri normalizedKey = null;
        switch (match) {
            case 1: {
                normalizedKey = uri;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                String msgId = uri.getLastPathSegment();
                normalizedKey = Uri.withAppendedPath((Uri)Telephony.Mms.CONTENT_URI, (String)msgId);
                break;
            }
            default: {
                return null;
            }
        }
        return normalizedKey;
    }

    private void purgeByMessageBox(Integer msgBoxId) {
        HashSet<Uri> msgBox;
        if (msgBoxId != null && (msgBox = this.mMessageBoxes.remove(msgBoxId)) != null) {
            for (Uri key : msgBox) {
                this.mUpdating.remove(key);
                PduCacheEntry entry = (PduCacheEntry)super.purge(key);
                if (entry == null) continue;
                this.removeFromThreads(key, entry);
            }
        }
    }

    private void removeFromThreads(Uri key, PduCacheEntry entry) {
        HashSet<Uri> thread = this.mThreads.get(entry.getThreadId());
        if (thread != null) {
            thread.remove(key);
        }
    }

    private void purgeByThreadId(long threadId) {
        HashSet<Uri> thread = this.mThreads.remove(threadId);
        if (thread != null) {
            for (Uri key : thread) {
                this.mUpdating.remove(key);
                PduCacheEntry entry = (PduCacheEntry)super.purge(key);
                if (entry == null) continue;
                this.removeFromMessageBoxes(key, entry);
            }
        }
    }

    private void removeFromMessageBoxes(Uri key, PduCacheEntry entry) {
        HashSet<Uri> msgBox = this.mThreads.get(entry.getMessageBox());
        if (msgBox != null) {
            msgBox.remove(key);
        }
    }

    static {
        URI_MATCHER.addURI("mms", null, 0);
        URI_MATCHER.addURI("mms", "#", 1);
        URI_MATCHER.addURI("mms", "inbox", 2);
        URI_MATCHER.addURI("mms", "inbox/#", 3);
        URI_MATCHER.addURI("mms", "sent", 4);
        URI_MATCHER.addURI("mms", "sent/#", 5);
        URI_MATCHER.addURI("mms", "drafts", 6);
        URI_MATCHER.addURI("mms", "drafts/#", 7);
        URI_MATCHER.addURI("mms", "outbox", 8);
        URI_MATCHER.addURI("mms", "outbox/#", 9);
        URI_MATCHER.addURI("mms-sms", "conversations", 10);
        URI_MATCHER.addURI("mms-sms", "conversations/#", 11);
        MATCH_TO_MSGBOX_ID_MAP = new HashMap();
        MATCH_TO_MSGBOX_ID_MAP.put(2, 1);
        MATCH_TO_MSGBOX_ID_MAP.put(4, 2);
        MATCH_TO_MSGBOX_ID_MAP.put(6, 3);
        MATCH_TO_MSGBOX_ID_MAP.put(8, 4);
    }
}

