/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.solana4j.client.jsonrpc;

import java.util.function.Function;

final class Result<L, R> {
    private final L error;
    private final R success;

    private Result(L error, R success) {
        this.error = error;
        this.success = success;
    }

    static <L, R> Result<L, R> error(L error) {
        return new Result<L, Object>(error, null);
    }

    static <L, R> Result<L, R> success(R success) {
        return new Result<Object, R>(null, success);
    }

    boolean isError() {
        return this.error != null;
    }

    boolean isSuccess() {
        return this.success != null;
    }

    L getError() {
        return this.error;
    }

    R getSuccess() {
        return this.success;
    }

    <S> Result<L, S> onSuccess(Function<R, Result<L, S>> onSuccess) {
        if (this.isSuccess()) {
            Result<L, S> intermediateResult = onSuccess.apply(this.success);
            if (intermediateResult.isError()) {
                return Result.error(intermediateResult.getError());
            }
            return Result.success(intermediateResult.success);
        }
        return Result.error(this.error);
    }
}

