/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.solana4j.client.jsonrpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.lmax.solana4j.client.api.AccountInfo;
import com.lmax.solana4j.client.api.BlockResponse;
import com.lmax.solana4j.client.api.Blockhash;
import com.lmax.solana4j.client.api.ClusterNode;
import com.lmax.solana4j.client.api.SignatureForAddress;
import com.lmax.solana4j.client.api.SignatureStatus;
import com.lmax.solana4j.client.api.SimulateTransactionResponse;
import com.lmax.solana4j.client.api.SolanaApi;
import com.lmax.solana4j.client.api.SolanaClientOptionalParams;
import com.lmax.solana4j.client.api.SolanaClientResponse;
import com.lmax.solana4j.client.api.SolanaVersion;
import com.lmax.solana4j.client.api.TokenAccount;
import com.lmax.solana4j.client.api.TokenAmount;
import com.lmax.solana4j.client.api.TransactionResponse;
import com.lmax.solana4j.client.jsonrpc.AccountInfoDTO;
import com.lmax.solana4j.client.jsonrpc.BalanceDTO;
import com.lmax.solana4j.client.jsonrpc.BlockResponseDTO;
import com.lmax.solana4j.client.jsonrpc.BlockhashDTO;
import com.lmax.solana4j.client.jsonrpc.ClusterNodeDTO;
import com.lmax.solana4j.client.jsonrpc.Result;
import com.lmax.solana4j.client.jsonrpc.RpcWrapperDTO;
import com.lmax.solana4j.client.jsonrpc.SignatureForAddressDTO;
import com.lmax.solana4j.client.jsonrpc.SignatureStatusesDTO;
import com.lmax.solana4j.client.jsonrpc.SimulateTransactionResponseDTO;
import com.lmax.solana4j.client.jsonrpc.SolanaCodec;
import com.lmax.solana4j.client.jsonrpc.SolanaJsonRpcClientError;
import com.lmax.solana4j.client.jsonrpc.SolanaJsonRpcClientException;
import com.lmax.solana4j.client.jsonrpc.SolanaJsonRpcClientOptionalParams;
import com.lmax.solana4j.client.jsonrpc.SolanaJsonRpcClientResponse;
import com.lmax.solana4j.client.jsonrpc.SolanaVersionDTO;
import com.lmax.solana4j.client.jsonrpc.TokenAccountsByOwnerDTO;
import com.lmax.solana4j.client.jsonrpc.TokenAmountDTO;
import com.lmax.solana4j.client.jsonrpc.TransactionResponseDTO;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class SolanaJsonRpcClient
implements SolanaApi {
    private final String rpcUrl;
    private final HttpClient httpClient;
    private final SolanaCodec solanaCodec;
    private final Duration socketTimeout;

    public SolanaJsonRpcClient(HttpClient httpClient, String rpcUrl) {
        this.rpcUrl = Objects.requireNonNull(rpcUrl);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.socketTimeout = null;
        this.solanaCodec = new SolanaCodec(false);
    }

    public SolanaJsonRpcClient(HttpClient httpClient, String rpcUrl, Duration socketTimeout) {
        this.rpcUrl = Objects.requireNonNull(rpcUrl);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.socketTimeout = Objects.requireNonNull(socketTimeout);
        this.solanaCodec = new SolanaCodec(false);
    }

    SolanaJsonRpcClient(HttpClient httpClient, String rpcUrl, boolean failOnUnknownProperties) {
        this.rpcUrl = rpcUrl;
        this.httpClient = httpClient;
        this.solanaCodec = new SolanaCodec(failOnUnknownProperties);
        this.socketTimeout = null;
    }

    @Override
    public SolanaClientResponse<String> requestAirdrop(String address, long amountLamports) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<String>>(){}, dto -> dto, "requestAirdrop", address, amountLamports, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<String> requestAirdrop(String address, long amountLamports, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<String>>(){}, dto -> dto, "requestAirdrop", address, amountLamports, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<String> sendTransaction(String transactionBlob) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<String>>(){}, dto -> dto, "sendTransaction", transactionBlob, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<String> sendTransaction(String transactionBlob, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<String>>(){}, dto -> dto, "sendTransaction", transactionBlob, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<BlockResponse> getBlock(long slot) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<BlockResponseDTO>>(){}, dto -> dto, "getBlock", slot, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<BlockResponse> getBlock(long slot, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        Object transactionDetails = optionalParams.getParams().get("transactionDetails");
        if ("accounts".equals(transactionDetails) || "signatures".equals(transactionDetails)) {
            throw new UnsupportedOperationException("Solana4J does not support the transactionDetails value " + String.valueOf(transactionDetails));
        }
        return this.queryForObject(new TypeReference<RpcWrapperDTO<BlockResponseDTO>>(){}, dto -> dto, "getBlock", slot, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<TransactionResponse> getTransaction(String transactionSignature) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<TransactionResponseDTO>>(){}, dto -> dto, "getTransaction", transactionSignature, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<TransactionResponse> getTransaction(String transactionSignature, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<TransactionResponseDTO>>(){}, dto -> dto, "getTransaction", transactionSignature, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<Long> getBalance(String address) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<BalanceDTO>>(){}, BalanceDTO::getValue, "getBalance", address, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<Long> getBalance(String address, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<BalanceDTO>>(){}, BalanceDTO::getValue, "getBalance", address, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<TokenAmount> getTokenAccountBalance(String address) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<TokenAmountDTO>>(){}, TokenAmountDTO::getValue, "getTokenAccountBalance", address, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<TokenAmount> getTokenAccountBalance(String address, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<TokenAmountDTO>>(){}, TokenAmountDTO::getValue, "getTokenAccountBalance", address, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<AccountInfo> getAccountInfo(String address) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<AccountInfoDTO>>(){}, AccountInfoDTO::getValue, "getAccountInfo", address, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<AccountInfo> getAccountInfo(String address, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<AccountInfoDTO>>(){}, AccountInfoDTO::getValue, "getAccountInfo", address, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<Long> getBlockHeight() throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<Long>>(){}, dto -> dto, "getBlockHeight", SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<Long> getBlockHeight(SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<Long>>(){}, dto -> dto, "getBlockHeight", optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<Long> getSlot() throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<Long>>(){}, dto -> dto, "getSlot", SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<Long> getSlot(SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<Long>>(){}, dto -> dto, "getSlot", optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<Blockhash> getLatestBlockhash() throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<BlockhashDTO>>(){}, BlockhashDTO::getValue, "getLatestBlockhash", SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<Blockhash> getLatestBlockhash(SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<BlockhashDTO>>(){}, BlockhashDTO::getValue, "getLatestBlockhash", optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<Long> getMinimumBalanceForRentExemption(int size) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<Long>>(){}, dto -> dto, "getMinimumBalanceForRentExemption", size, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<Long> getMinimumBalanceForRentExemption(int size, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<Long>>(){}, dto -> dto, "getMinimumBalanceForRentExemption", size, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<Long> minimumLedgerSlot() throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<Long>>(){}, dto -> dto, "minimumLedgerSlot", new Object[0]);
    }

    @Override
    public SolanaClientResponse<String> getHealth() throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<String>>(){}, dto -> dto, "getHealth", new Object[0]);
    }

    @Override
    public SolanaClientResponse<List<SignatureForAddress>> getSignaturesForAddress(String address) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<List<SignatureForAddressDTO>>>(){}, ArrayList::new, "getSignaturesForAddress", address);
    }

    @Override
    public SolanaClientResponse<List<SignatureForAddress>> getSignaturesForAddress(String address, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<List<SignatureForAddressDTO>>>(){}, ArrayList::new, "getSignaturesForAddress", address, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<List<SignatureStatus>> getSignatureStatuses(List<String> transactionSignatures) throws SolanaJsonRpcClientException {
        Map<String, Object> defaultOptionalParams = SolanaJsonRpcClientOptionalParams.defaultOptionalParams();
        defaultOptionalParams.put("searchTransactionHistory", false);
        return this.queryForObject(new TypeReference<RpcWrapperDTO<SignatureStatusesDTO>>(){}, SignatureStatusesDTO::getValue, "getSignatureStatuses", transactionSignatures, defaultOptionalParams);
    }

    @Override
    public SolanaClientResponse<List<SignatureStatus>> getSignatureStatuses(List<String> transactionSignatures, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<SignatureStatusesDTO>>(){}, SignatureStatusesDTO::getValue, "getSignatureStatuses", transactionSignatures, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<List<TokenAccount>> getTokenAccountsByOwner(String accountDelegate, Map.Entry<String, String> filter) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<TokenAccountsByOwnerDTO>>(){}, TokenAccountsByOwnerDTO::getValue, "getTokenAccountsByOwner", accountDelegate, filter, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<List<TokenAccount>> getTokenAccountsByOwner(String accountDelegate, Map.Entry<String, String> filter, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<TokenAccountsByOwnerDTO>>(){}, TokenAccountsByOwnerDTO::getValue, "getTokenAccountsByOwner", accountDelegate, filter, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<SimulateTransactionResponse> simulateTransaction(String transaction) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<SimulateTransactionResponseDTO>>(){}, SimulateTransactionResponseDTO::getValue, "simulateTransaction", transaction, SolanaJsonRpcClientOptionalParams.defaultOptionalParams());
    }

    @Override
    public SolanaClientResponse<SimulateTransactionResponse> simulateTransaction(String transaction, SolanaClientOptionalParams optionalParams) throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<SimulateTransactionResponseDTO>>(){}, SimulateTransactionResponseDTO::getValue, "simulateTransaction", transaction, optionalParams.getParams());
    }

    @Override
    public SolanaClientResponse<SolanaVersion> getVersion() throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<SolanaVersionDTO>>(){}, dto -> dto, "getVersion", new Object[0]);
    }

    @Override
    public SolanaClientResponse<List<ClusterNode>> getClusterNodes() throws SolanaJsonRpcClientException {
        return this.queryForObject(new TypeReference<RpcWrapperDTO<List<ClusterNodeDTO>>>(){}, ArrayList::new, "getClusterNodes", new Object[0]);
    }

    private <S, T> SolanaClientResponse<S> queryForObject(TypeReference<RpcWrapperDTO<T>> type, Function<T, S> dtoMapper, String method, Object ... params) throws SolanaJsonRpcClientException {
        HttpRequest request = this.prepareRequest(method, params);
        HttpResponse<String> httpResponse = this.sendRequest(request);
        Result<SolanaClientResponse.SolanaClientError, T> response = this.decodeResponse(type, httpResponse);
        if (response.isError()) {
            return SolanaJsonRpcClientResponse.creatErrorResponse(response.getError());
        }
        return SolanaJsonRpcClientResponse.createSuccessResponse(dtoMapper.apply(response.getSuccess()));
    }

    private HttpRequest prepareRequest(String method, Object[] params) throws SolanaJsonRpcClientException {
        try {
            return this.buildPostRequest(this.solanaCodec.encodeRequest(method, params));
        }
        catch (JsonProcessingException e) {
            throw new SolanaJsonRpcClientException(String.format("An error occurred building the JSON RPC request for method %s.", method), e);
        }
    }

    private HttpResponse<String> sendRequest(HttpRequest request) throws SolanaJsonRpcClientException {
        try {
            HttpResponse<String> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() != 200) {
                throw new SolanaJsonRpcClientException(String.format("Unexpected status code %s returned from the JSON RPC for request %s.", httpResponse.statusCode(), request));
            }
            return httpResponse;
        }
        catch (IOException | InterruptedException e) {
            throw new SolanaJsonRpcClientException(String.format("Unable to communicate with the JSON RPC for request %s.", request), e, true);
        }
    }

    private <T> Result<SolanaClientResponse.SolanaClientError, T> decodeResponse(TypeReference<RpcWrapperDTO<T>> type, HttpResponse<String> httpResponse) throws SolanaJsonRpcClientException {
        try {
            RpcWrapperDTO<T> rpcResult = this.solanaCodec.decodeResponse(httpResponse.body().getBytes(StandardCharsets.UTF_8), type);
            if (rpcResult.getError() != null) {
                return Result.error(new SolanaJsonRpcClientError(rpcResult.getError().getCode(), rpcResult.getError().getMessage()));
            }
            return Result.success(rpcResult.getResult());
        }
        catch (IOException e) {
            throw new SolanaJsonRpcClientException(String.format("Unable to decode JSON RPC response %s.", httpResponse), e);
        }
    }

    private HttpRequest buildPostRequest(String payload) {
        HttpRequest.Builder request = HttpRequest.newBuilder();
        request.uri(URI.create(this.rpcUrl));
        request.setHeader("Content-Type", "application/json");
        request.POST(HttpRequest.BodyPublishers.ofString(payload));
        if (this.socketTimeout != null) {
            request.timeout(this.socketTimeout);
        }
        return request.build();
    }
}

