/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.Sha256Hash;
import org.p2p.solanaj.utils.ByteUtils;
import org.p2p.solanaj.utils.PublicKeySerializer;
import org.p2p.solanaj.utils.TweetNaclFast;

@JsonSerialize(using=PublicKeySerializer.class)
public class PublicKey {
    public static final int PUBLIC_KEY_LENGTH = 32;
    private final byte[] pubkey;

    public PublicKey(String pubkey) {
        if (pubkey.length() < 32) {
            throw new IllegalArgumentException("Invalid public key input: length must be at least 32");
        }
        this.pubkey = Base58.decode((String)pubkey);
    }

    public PublicKey(byte[] pubkey) {
        if (pubkey.length != 32) {
            throw new IllegalArgumentException("Invalid public key input: length must be exactly 32");
        }
        this.pubkey = Arrays.copyOf(pubkey, 32);
    }

    public static PublicKey readPubkey(byte[] bytes, int offset) {
        byte[] buf = ByteUtils.readBytes(bytes, offset, 32);
        return new PublicKey(buf);
    }

    public byte[] toByteArray() {
        return this.pubkey;
    }

    public String toBase58() {
        return Base58.encode((byte[])this.pubkey);
    }

    public boolean equals(PublicKey pubkey) {
        return Arrays.equals(this.pubkey, pubkey.toByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.pubkey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey)o;
        return Arrays.equals(this.pubkey, other.pubkey);
    }

    public String toString() {
        return this.toBase58();
    }

    public static PublicKey createProgramAddress(List<byte[]> seeds, PublicKey programId) {
        PublicKey publicKey;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            for (byte[] seed : seeds) {
                if (seed.length > 32) {
                    throw new IllegalArgumentException("Max seed length exceeded: " + seed.length);
                }
                buffer.write(seed);
            }
            buffer.write(programId.toByteArray());
            buffer.write("ProgramDerivedAddress".getBytes());
            byte[] hash = Sha256Hash.hash((byte[])buffer.toByteArray());
            if (TweetNaclFast.is_on_curve(hash) != 0) {
                throw new IllegalStateException("Invalid seeds, address must fall off the curve");
            }
            publicKey = new PublicKey(hash);
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating program address", e);
            }
        }
        buffer.close();
        return publicKey;
    }

    public static ProgramDerivedAddress findProgramAddress(List<byte[]> seeds, PublicKey programId) {
        for (int nonce = 255; nonce >= 0; --nonce) {
            try {
                ArrayList<byte[]> seedsWithNonce = new ArrayList<byte[]>(seeds);
                seedsWithNonce.add(new byte[]{(byte)nonce});
                PublicKey address = PublicKey.createProgramAddress(seedsWithNonce, programId);
                return new ProgramDerivedAddress(address, nonce);
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
        }
        throw new IllegalStateException("Unable to find a viable program address nonce");
    }

    public static PublicKey valueOf(String publicKey) {
        return new PublicKey(publicKey);
    }

    public static class ProgramDerivedAddress {
        private PublicKey address;
        private int nonce;

        public ProgramDerivedAddress(PublicKey address, int nonce) {
            this.address = address;
            this.nonce = nonce;
        }

        public PublicKey getAddress() {
            return this.address;
        }

        public int getNonce() {
            return this.nonce;
        }
    }
}

