/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.utils.bip32.crypto;

import java.math.BigInteger;
import java.util.Arrays;
import org.p2p.solanaj.utils.bip32.crypto.Hash;
import org.p2p.solanaj.utils.bip32.crypto.Secp256k1;

public class HdUtil {
    public static byte[] ser32(long i) {
        byte[] ser = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return ser;
    }

    public static byte[] ser256(BigInteger p) {
        byte[] byteArray = p.toByteArray();
        byte[] ret = new byte[32];
        Arrays.fill(ret, (byte)0);
        if (byteArray.length <= ret.length) {
            System.arraycopy(byteArray, 0, ret, ret.length - byteArray.length, byteArray.length);
        } else {
            System.arraycopy(byteArray, byteArray.length - ret.length, ret, 0, ret.length);
        }
        return ret;
    }

    public static BigInteger parse256(byte[] p) {
        return new BigInteger(1, p);
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static byte[] append(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] getFingerprint(byte[] keyData) {
        byte[] point = Secp256k1.serP(Secp256k1.point(HdUtil.parse256(keyData)));
        byte[] h160 = Hash.h160(point);
        return new byte[]{h160[0], h160[1], h160[2], h160[3]};
    }
}

