/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.client.ErrorCodeException;
import io.bitexpress.openapi.client.GatewayClient;
import io.bitexpress.openapi.client.RequestFactory;
import io.bitexpress.openapi.model.content.OpenApiResponseContent;
import io.bitexpress.openapi.model.content.ServiceIndex;
import io.bitexpress.openapi.model.envelope.OpenApiEnvelope;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.springframework.web.client.RestTemplate;

public class GatewayClientImpl
implements GatewayClient {
    public static final String DEFAULT_SUCCESS_RESPONSE_CODE = "SUCCESS";
    public static final BigDecimal DEFAULT_SIGNATURE_VERSION = new BigDecimal("1.0");
    private RestTemplate restTemplate;
    private String url;
    private ObjectMapper objectMapper;
    private String successResponseCode = "SUCCESS";
    private RequestFactory requestFactory;

    @Override
    public <REQ, RES> RES invoke(ServiceIndex serviceIndex, REQ req, Class<RES> responseClass) {
        return this.invoke(serviceIndex, req, this.objectMapper.constructType(responseClass));
    }

    @Override
    public <REQ, RES> OpenApiResponseContent<RES> invokeSilently(ServiceIndex serviceIndex, REQ req, Class<RES> responseClass) {
        return this.invokeSilently(serviceIndex, req, this.objectMapper.constructType(responseClass));
    }

    @Override
    public <REQ, RES> RES invoke(ServiceIndex serviceIndex, REQ req, JavaType responseJavaType) {
        OpenApiResponseContent<RES> invokeSilently = this.invokeSilently(serviceIndex, req, responseJavaType);
        if (!this.successResponseCode.equals(invokeSilently.getHeader().getResponseCode())) {
            throw new ErrorCodeException(invokeSilently.getHeader().getResponseCode(), invokeSilently.getHeader().getErrorMessage());
        }
        return (RES)invokeSilently.getBody();
    }

    @Override
    public <REQ, RES> OpenApiResponseContent<RES> invokeSilently(ServiceIndex serviceIndex, REQ req, JavaType responseBodyJavaType) {
        OpenApiEnvelope requestEnvelope = this.requestFactory.createRequestEnvelope(serviceIndex, req);
        JavaType responseContentType = this.objectMapper.getTypeFactory().constructParametricType(OpenApiResponseContent.class, new JavaType[]{responseBodyJavaType});
        String resposneContentStr = (String)this.restTemplate.postForObject(this.url, (Object)requestEnvelope, String.class, new Object[0]);
        try {
            return (OpenApiResponseContent)this.objectMapper.readValue(resposneContentStr, responseContentType);
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setRequestFactory(RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }
}

