/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.client.FromHolder;
import io.bitexpress.openapi.client.sign.OaRsaSignatureTool;
import io.bitexpress.openapi.model.content.OpenApiRequestContent;
import io.bitexpress.openapi.model.content.OpenApiRequestHeader;
import io.bitexpress.openapi.model.content.ServiceIndex;
import io.bitexpress.openapi.model.envelope.OpenApiEnvelope;
import java.math.BigDecimal;
import java.security.PrivateKey;
import java.util.Date;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class RequestFactory
extends FromHolder {
    public static final BigDecimal DEFAULT_SIGNATURE_VERSION = new BigDecimal("1.0");
    private BigDecimal signatureVersion = DEFAULT_SIGNATURE_VERSION;
    private ObjectMapper objectMapper;
    private PrivateKey privateKey;

    public <REQ> OpenApiEnvelope createRequestEnvelope(ServiceIndex serviceIndex, REQ req) {
        String contentJson;
        OpenApiRequestContent requestContent = new OpenApiRequestContent();
        requestContent.setBody(req);
        requestContent.setHeader(this.createHeader(serviceIndex));
        try {
            contentJson = this.objectMapper.writeValueAsString((Object)requestContent);
        }
        catch (JsonProcessingException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
        String signHex = OaRsaSignatureTool.signUtf8ToHex(contentJson, this.privateKey);
        OpenApiEnvelope envelope = new OpenApiEnvelope();
        envelope.setSignatureVersion(this.signatureVersion);
        envelope.setSignature(signHex);
        envelope.setContent(contentJson);
        envelope.setUid(this.uid);
        envelope.setIssuerCode(this.issuerCode);
        envelope.setIssuer(this.issuer);
        return envelope;
    }

    public OpenApiRequestHeader createHeader(ServiceIndex serviceIndex) {
        OpenApiRequestHeader apiRequestHeader = new OpenApiRequestHeader();
        apiRequestHeader.setPreserved(this.getPreserved());
        apiRequestHeader.setRequestTime(new Date());
        apiRequestHeader.setServiceIndex(serviceIndex);
        return apiRequestHeader;
    }

    public String getPreserved() {
        return null;
    }

    public void setSignatureVersion(BigDecimal signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }
}

