/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client.sign;

import io.bitexpress.openapi.client.sign.KeyReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractKeyReader
implements KeyReader {
    @Override
    public Pair<PrivateKey, PublicKey> readKeyPair(Reader reader) {
        return this.readPkcs1KeyPair(reader);
    }

    @Override
    public Pair<PrivateKey, PublicKey> readKeyPair(String pem) {
        try (StringReader stringReader = new StringReader(pem);){
            Pair<PrivateKey, PublicKey> pair = this.readKeyPair(stringReader);
            return pair;
        }
    }

    @Override
    public PublicKey readPublicKey(String pem) {
        try (StringReader stringReader = new StringReader(pem);){
            PublicKey publicKey = this.readPublicKey(stringReader);
            return publicKey;
        }
    }

    @Override
    public Pair<PrivateKey, PublicKey> readPkcs1KeyPair(String pem) {
        try (StringReader stringReader = new StringReader(pem);){
            Pair<PrivateKey, PublicKey> pair = this.readPkcs1KeyPair(stringReader);
            return pair;
        }
    }

    @Override
    public PrivateKey readPkcs8PrivateKey(String pem) {
        try (StringReader stringReader = new StringReader(pem);){
            PrivateKey privateKey = this.readPkcs8PrivateKey(stringReader);
            return privateKey;
        }
    }
}

