/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.abi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tron.trident.abi.FunctionReturnDecoder;
import org.tron.trident.abi.TypeDecoder;
import org.tron.trident.abi.TypeReference;
import org.tron.trident.abi.datatypes.Array;
import org.tron.trident.abi.datatypes.Bytes;
import org.tron.trident.abi.datatypes.BytesType;
import org.tron.trident.abi.datatypes.DynamicArray;
import org.tron.trident.abi.datatypes.DynamicBytes;
import org.tron.trident.abi.datatypes.DynamicStruct;
import org.tron.trident.abi.datatypes.StaticArray;
import org.tron.trident.abi.datatypes.StaticStruct;
import org.tron.trident.abi.datatypes.Type;
import org.tron.trident.abi.datatypes.Utf8String;
import org.tron.trident.abi.datatypes.generated.Bytes32;
import org.tron.trident.utils.Numeric;
import org.tron.trident.utils.Strings;

public class DefaultFunctionReturnDecoder
extends FunctionReturnDecoder {
    @Override
    public List<Type> decodeFunctionResult(String rawInput, List<TypeReference<Type>> outputParameters) {
        String input = Numeric.cleanHexPrefix(rawInput);
        if (Strings.isEmpty(input)) {
            return Collections.emptyList();
        }
        return DefaultFunctionReturnDecoder.build(input, outputParameters);
    }

    @Override
    public <T extends Type> Type decodeEventParameter(String rawInput, TypeReference<T> typeReference) {
        String input = Numeric.cleanHexPrefix(rawInput);
        try {
            Class<T> type = typeReference.getClassType();
            if (Bytes.class.isAssignableFrom(type)) {
                Class<?> bytesClass = Class.forName(type.getName());
                return TypeDecoder.decodeBytes(input, bytesClass);
            }
            if (Array.class.isAssignableFrom(type) || BytesType.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
                return TypeDecoder.decodeBytes(input, Bytes32.class);
            }
            return TypeDecoder.decode(input, type);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static List<Type> build(String input, List<TypeReference<Type>> outputParameters) {
        ArrayList<Type> results = new ArrayList<Type>(outputParameters.size());
        int offset = 0;
        for (TypeReference<Type> typeReference : outputParameters) {
            try {
                int length;
                Type result;
                Class<Type> classType = typeReference.getClassType();
                int hexStringDataOffset = DefaultFunctionReturnDecoder.getDataOffset(input, offset, classType);
                if (DynamicStruct.class.isAssignableFrom(classType)) {
                    if (outputParameters.size() != 1) {
                        throw new UnsupportedOperationException("Multiple return objects containing a struct is not supported");
                    }
                    result = TypeDecoder.decodeDynamicStruct(input, hexStringDataOffset, typeReference);
                    offset += 64;
                } else if (DynamicArray.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeDynamicArray(input, hexStringDataOffset, typeReference);
                    offset += 64;
                } else if (typeReference instanceof TypeReference.StaticArrayTypeReference) {
                    length = ((TypeReference.StaticArrayTypeReference)typeReference).getSize();
                    result = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length);
                    offset += length * 64;
                } else if (StaticStruct.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeStaticStruct(input, hexStringDataOffset, typeReference);
                    offset += classType.getDeclaredFields().length * 64;
                } else if (StaticArray.class.isAssignableFrom(classType)) {
                    length = Integer.parseInt(classType.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                    result = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length);
                    offset += length * 64;
                } else {
                    result = TypeDecoder.decode(input, hexStringDataOffset, classType);
                    offset += 64;
                }
                results.add(result);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Invalid class reference provided", e);
            }
        }
        return results;
    }

    private static <T extends Type> int getDataOffset(String input, int offset, Class<T> type) {
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type) || DynamicArray.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeUintAsInt(input, offset) << 1;
        }
        return offset;
    }
}

