/*
 * Decompiled with CFR 0.152.
 */
package io.setl.rdf.normalization;

import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfValue;
import io.setl.rdf.normalization.InputMappings;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class IdentifierIssuer {
    private final LinkedHashMap<RdfResource, RdfResource> existing = new LinkedHashMap();
    private final HashSet<RdfResource> generated = new HashSet();
    private final String prefix;
    private int counter = 0;

    IdentifierIssuer(String prefix) {
        this.prefix = prefix;
    }

    public void assign(IdentifierIssuer other) {
        this.existing.forEach((k, v) -> other.getId((RdfResource)k));
    }

    public IdentifierIssuer copy() {
        IdentifierIssuer newIssuer = new IdentifierIssuer(this.prefix);
        newIssuer.existing.putAll(this.existing);
        newIssuer.counter = this.counter;
        newIssuer.generated.addAll(this.generated);
        return newIssuer;
    }

    private RdfResource getForBlank(RdfResource value, AtomicBoolean flag) {
        if (this.hasId(value)) {
            flag.set(true);
            return this.getId(value);
        }
        return value;
    }

    public RdfResource getId(RdfResource id) {
        RdfResource v = this.existing.get(id);
        if (v != null) {
            return v;
        }
        while (this.generated.contains(v = Rdf.createBlankNode((String)(this.prefix + this.counter++)))) {
        }
        this.existing.put(id, v);
        this.generated.add(v);
        return v;
    }

    RdfValue getIfExists(RdfValue value, AtomicBoolean flag) {
        return value != null && value.isBlankNode() ? this.getForBlank((RdfResource)value, flag) : value;
    }

    public RdfResource getIfExists(RdfResource value, AtomicBoolean flag) {
        return value != null && value.isBlankNode() ? this.getForBlank(value, flag) : value;
    }

    public Map<RdfResource, RdfResource> getMappings() {
        LinkedHashMap<RdfResource, RdfResource> copy = new LinkedHashMap<RdfResource, RdfResource>(this.existing);
        return Collections.unmodifiableMap(copy);
    }

    public boolean hasId(RdfResource id) {
        return this.existing.containsKey(id);
    }

    IdentifierIssuer withMappings(InputMappings mappings) {
        if (mappings != null) {
            mappings.getMappings().forEach((k, v) -> {
                this.existing.put((RdfResource)k, (RdfResource)v);
                this.generated.add((RdfResource)v);
            });
        }
        return this;
    }
}

