/*
 * Decompiled with CFR 0.152.
 */
package io.setl.rdf.normalization;

import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfResource;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class InputMappings {
    private final Set<RdfResource> assigned = new HashSet<RdfResource>();
    private final Map<RdfResource, RdfResource> mappings = new LinkedHashMap<RdfResource, RdfResource>();

    private void add(RdfResource key, RdfResource value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null resource in mapping");
        }
        if (!key.isBlankNode()) {
            throw new IllegalArgumentException("Resource is not a blank node: " + key);
        }
        if (!value.isBlankNode()) {
            throw new IllegalArgumentException("Resource is not a blank node: " + value);
        }
        if (this.mappings.containsKey(key)) {
            if (this.mappings.get(key).equals(value)) {
                return;
            }
            throw new IllegalArgumentException("Resource already mapped: " + key);
        }
        if (!this.assigned.add(value)) {
            throw new IllegalArgumentException("Resource already assigned: " + value);
        }
        this.mappings.put(key, value);
    }

    public void addNameMapping(String key, String value) {
        this.add(Rdf.createBlankNode((String)key), Rdf.createBlankNode((String)value));
    }

    public void addNameMappings(Map<String, String> nameMappings) {
        for (Map.Entry<String, String> entry : nameMappings.entrySet()) {
            this.add(Rdf.createBlankNode((String)entry.getKey()), Rdf.createBlankNode((String)entry.getValue()));
        }
    }

    public void addResourceMapping(RdfResource key, RdfResource value) {
        this.add(key, value);
    }

    public void addResourceMappings(Map<RdfResource, RdfResource> nameMappings) {
        for (Map.Entry<RdfResource, RdfResource> entry : nameMappings.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public Map<RdfResource, RdfResource> getMappings() {
        return Collections.unmodifiableMap(this.mappings);
    }
}

