/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import java.util.List;
import java.util.Set;

public abstract class SignatureCertificateSource
extends TokenCertificateSource {
    protected CandidatesForSigningCertificate candidatesForSigningCertificate;

    protected SignatureCertificateSource() {
    }

    public List<CertificateToken> getSignedDataCertificates() {
        return this.getCertificateTokensByOrigin(CertificateOrigin.SIGNED_DATA);
    }

    public List<CertificateToken> getKeyInfoCertificates() {
        return this.getCertificateTokensByOrigin(CertificateOrigin.KEY_INFO);
    }

    public List<CertificateToken> getCertificateValues() {
        return this.getCertificateTokensByOrigin(CertificateOrigin.CERTIFICATE_VALUES);
    }

    public List<CertificateToken> getAttrAuthoritiesCertValues() {
        return this.getCertificateTokensByOrigin(CertificateOrigin.ATTR_AUTHORITIES_CERT_VALUES);
    }

    public List<CertificateToken> getTimeStampValidationDataCertValues() {
        return this.getCertificateTokensByOrigin(CertificateOrigin.TIMESTAMP_VALIDATION_DATA);
    }

    public List<CertificateToken> getDSSDictionaryCertValues() {
        return this.getCertificateTokensByOrigin(CertificateOrigin.DSS_DICTIONARY);
    }

    public List<CertificateToken> getVRIDictionaryCertValues() {
        return this.getCertificateTokensByOrigin(CertificateOrigin.VRI_DICTIONARY);
    }

    public List<CertificateRef> getSigningCertificateRefs() {
        return this.getCertificateRefsByOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
    }

    public List<CertificateRef> getCompleteCertificateRefs() {
        return this.getCertificateRefsByOrigin(CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS);
    }

    public List<CertificateRef> getAttributeCertificateRefs() {
        return this.getCertificateRefsByOrigin(CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS);
    }

    public Set<CertificateToken> getSigningCertificates() {
        return this.findTokensFromRefs(this.getSigningCertificateRefs());
    }

    public Set<CertificateToken> getCompleteCertificates() {
        return this.findTokensFromRefs(this.getCompleteCertificateRefs());
    }

    public Set<CertificateToken> getAttributeCertificates() {
        return this.findTokensFromRefs(this.getAttributeCertificateRefs());
    }

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate(CertificateSource signingCertificateSource) {
        if (this.candidatesForSigningCertificate == null) {
            this.candidatesForSigningCertificate = this.extractCandidatesForSigningCertificate(signingCertificateSource);
        }
        return this.candidatesForSigningCertificate;
    }

    protected abstract CandidatesForSigningCertificate extractCandidatesForSigningCertificate(CertificateSource var1);

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.SIGNATURE;
    }
}

