/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.extension.SubjectKeyIdentifier;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;

public class SignerIdentifier
implements Serializable {
    private static final long serialVersionUID = 8539151269599455910L;
    private X500Principal issuerName;
    private BigInteger serialNumber;
    private byte[] ski;
    private boolean current;

    public X500Principal getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(X500Principal name) {
        this.issuerName = name;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public byte[] getSki() {
        return this.ski;
    }

    public void setSki(byte[] ski) {
        this.ski = ski;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public byte[] getIssuerSerialEncoded() {
        if (this.issuerName != null && this.serialNumber != null) {
            X500Name issuerX500Name = X500Name.getInstance((Object)this.issuerName.getEncoded());
            GeneralName generalName = new GeneralName(issuerX500Name);
            GeneralNames generalNames = new GeneralNames(generalName);
            IssuerSerial issuerSerial = new IssuerSerial(generalNames, this.serialNumber);
            return DSSASN1Utils.getDEREncoded((ASN1Encodable)issuerSerial);
        }
        return null;
    }

    public boolean isRelatedToCertificate(CertificateToken certificateToken) {
        SignerIdentifier id = new SignerIdentifier();
        id.setIssuerName(certificateToken.getIssuerX500Principal());
        id.setSerialNumber(certificateToken.getSerialNumber());
        SubjectKeyIdentifier certSki = CertificateExtensionsUtils.getSubjectKeyIdentifier(certificateToken);
        if (certSki != null) {
            id.setSki(certSki.getSki());
        }
        return this.isEquivalent(id);
    }

    public boolean isEquivalent(SignerIdentifier signerIdentifier) {
        if (this.issuerName != null && this.serialNumber != null) {
            if (!DSSASN1Utils.x500PrincipalAreEquals(this.issuerName, signerIdentifier.getIssuerName())) {
                return false;
            }
            return this.serialNumber.equals(signerIdentifier.getSerialNumber());
        }
        return Arrays.equals(this.ski, signerIdentifier.getSki());
    }

    public boolean isEmpty() {
        return this.issuerName == null && this.serialNumber == null && Utils.isArrayEmpty((byte[])this.ski);
    }

    public String toString() {
        if (this.issuerName != null || this.serialNumber != null) {
            return "IssuerSerialInfo [issuerName=" + this.issuerName + ", serialNumber=" + this.serialNumber + "]";
        }
        return "IssuerSerialInfo [ski=" + Utils.toBase64((byte[])this.ski) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.issuerName == null ? 0 : this.issuerName.hashCode());
        result = 31 * result + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = 31 * result + Arrays.hashCode(this.ski);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignerIdentifier other = (SignerIdentifier)obj;
        if (this.issuerName == null ? other.issuerName != null : !this.issuerName.equals(other.issuerName)) {
            return false;
        }
        if (this.serialNumber == null ? other.serialNumber != null : !this.serialNumber.equals(other.serialNumber)) {
            return false;
        }
        return Arrays.equals(this.ski, other.ski);
    }
}

