/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.aia;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.NativeHTTPDataLoader;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.spi.x509.aia.OnlineAIASource;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAIASource
implements AIASource {
    private static final long serialVersionUID = 3968373722847675203L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAIASource.class);
    private DataLoader dataLoader;
    private Collection<Protocol> acceptedProtocols = Arrays.asList(Protocol.values());

    public DefaultAIASource() {
        this(new NativeHTTPDataLoader());
    }

    public DefaultAIASource(DataLoader dataLoader) {
        Objects.requireNonNull(dataLoader, "dataLoader cannot be null!");
        this.dataLoader = dataLoader;
    }

    public void setDataLoader(DataLoader dataLoader) {
        Objects.requireNonNull(dataLoader, "dataLoader cannot be null!");
        this.dataLoader = dataLoader;
    }

    public void setAcceptedProtocols(Collection<Protocol> acceptedProtocols) {
        this.acceptedProtocols = acceptedProtocols;
    }

    @Override
    public Set<CertificateToken> getCertificatesByAIA(CertificateToken certificateToken) {
        Objects.requireNonNull(certificateToken, "CertificateToken cannot be null!");
        Objects.requireNonNull(this.dataLoader, "DataLoader is not provided!");
        List<String> caIssuersUrls = this.getCAIssuersUrls(certificateToken);
        for (String caIssuersUrl : caIssuersUrls) {
            LinkedHashSet<CertificateToken> linkedHashSet;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to retrieve CA issuers from URL '{}'...", (Object)caIssuersUrl);
            }
            byte[] bytes = this.executeCAIssuersRequest(caIssuersUrl);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                List<CertificateToken> loadedCertificates = DSSUtils.loadCertificateFromP7c(is);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} certificate(s) loaded from '{}'", (Object)loadedCertificates.size(), (Object)caIssuersUrl);
                }
                for (CertificateToken certificate : loadedCertificates) {
                    certificate.setSourceURL(caIssuersUrl);
                }
                linkedHashSet = new LinkedHashSet<CertificateToken>(loadedCertificates);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Unable to retrieve AIA certificates with URL '{}' : {}", (Object)caIssuersUrl, (Object)e.getMessage());
                }
            }
            ((InputStream)is).close();
            return linkedHashSet;
        }
        return Collections.emptySet();
    }

    protected List<String> getCAIssuersUrls(CertificateToken certificateToken) {
        List<String> urls = CertificateExtensionsUtils.getCAIssuersAccessUrls(certificateToken);
        if (Utils.isCollectionEmpty(urls)) {
            LOG.info("There is no AIA extension for certificate download.");
            return Collections.emptyList();
        }
        return this.filterURLs(urls);
    }

    private List<String> filterURLs(List<String> urls) {
        return urls.stream().filter(this::isUrlAccepted).collect(Collectors.toList());
    }

    protected byte[] executeCAIssuersRequest(String caIssuersUrl) {
        byte[] bytes = this.dataLoader.get(caIssuersUrl);
        if (Utils.isArrayNotEmpty((byte[])bytes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Base64 content : {}", (Object)Utils.toBase64((byte[])bytes));
            }
            return bytes;
        }
        throw new DSSExternalResourceException(String.format("AIA DataLoader for certificate with url '%s' responded with an empty byte array!", caIssuersUrl));
    }

    @Deprecated
    public List<OnlineAIASource.CertificatesAndAIAUrl> getCertificatesAndAIAUrls(CertificateToken certificateToken) {
        ArrayList<OnlineAIASource.CertificatesAndAIAUrl> result = new ArrayList<OnlineAIASource.CertificatesAndAIAUrl>();
        List<String> caIssuersUrls = this.getCAIssuersUrls(certificateToken);
        for (String caIssuersUrl : caIssuersUrls) {
            try {
                List<CertificateToken> loadedCertificates;
                byte[] bytes = this.executeCAIssuersRequest(caIssuersUrl);
                try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
                    loadedCertificates = DSSUtils.loadCertificateFromP7c(is);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} certificate(s) loaded from '{}'", (Object)loadedCertificates.size(), (Object)caIssuersUrl);
                    }
                }
                result.add(new OnlineAIASource.CertificatesAndAIAUrl(caIssuersUrl, loadedCertificates));
            }
            catch (Exception e) {
                LOG.warn("Unable to retrieve AIA certificates with URL '{}' : {}", (Object)caIssuersUrl, (Object)e.getMessage());
            }
        }
        return result;
    }

    private boolean isUrlAccepted(String url) {
        if (Utils.isCollectionNotEmpty(this.acceptedProtocols)) {
            for (Protocol protocol : this.acceptedProtocols) {
                if (!protocol.isTheSame(url)) continue;
                return true;
            }
        }
        return false;
    }
}

