/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import ethereum.ckzg4844.CKZG4844JNI;
import org.apache.tuweni.bytes.Bytes;
import org.web3j.crypto.Blob;
import org.web3j.crypto.Hash;

public class BlobUtils {
    private static final byte blobCommitmentVersionKZG = 1;
    private static final String trustedSetupFilePath = "/trusted_setup.txt";

    private static void loadTrustedSetupParameters() {
        CKZG4844JNI.loadTrustedSetupFromResource((String)trustedSetupFilePath, BlobUtils.class, (long)0L);
    }

    public static Bytes getCommitment(Blob blobData) {
        return Bytes.wrap((byte[])CKZG4844JNI.blobToKzgCommitment((byte[])blobData.data.toArray()));
    }

    public static Bytes getProof(Blob blobData, Bytes commitment) {
        return Bytes.wrap((byte[])CKZG4844JNI.computeBlobKzgProof((byte[])blobData.data.toArray(), (byte[])commitment.toArray()));
    }

    public static boolean checkProofValidity(Blob blobData, Bytes commitment, Bytes proof) {
        return CKZG4844JNI.verifyBlobKzgProof((byte[])blobData.data.toArray(), (byte[])commitment.toArray(), (byte[])proof.toArray());
    }

    public static Bytes kzgToVersionedHash(Bytes commitment) {
        byte[] hash = Hash.sha256((byte[])commitment.toArray());
        hash[0] = 1;
        return Bytes.wrap((byte[])hash);
    }

    static {
        CKZG4844JNI.loadNativeLibrary();
        BlobUtils.loadTrustedSetupParameters();
    }
}

