/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal;

import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.logging.Log;
import org.whispersystems.libsignal.protocol.PreKeySignalMessage;
import org.whispersystems.libsignal.ratchet.AliceSignalProtocolParameters;
import org.whispersystems.libsignal.ratchet.BobSignalProtocolParameters;
import org.whispersystems.libsignal.ratchet.RatchetingSession;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignalProtocolStore;
import org.whispersystems.libsignal.state.SignedPreKeyStore;
import org.whispersystems.libsignal.util.guava.Optional;

public class SessionBuilder {
    private static final String TAG = SessionBuilder.class.getSimpleName();
    private final SessionStore sessionStore;
    private final PreKeyStore preKeyStore;
    private final SignedPreKeyStore signedPreKeyStore;
    private final IdentityKeyStore identityKeyStore;
    private final SignalProtocolAddress remoteAddress;

    public SessionBuilder(SessionStore sessionStore, PreKeyStore preKeyStore, SignedPreKeyStore signedPreKeyStore, IdentityKeyStore identityKeyStore, SignalProtocolAddress remoteAddress) {
        this.sessionStore = sessionStore;
        this.preKeyStore = preKeyStore;
        this.signedPreKeyStore = signedPreKeyStore;
        this.identityKeyStore = identityKeyStore;
        this.remoteAddress = remoteAddress;
    }

    public SessionBuilder(SignalProtocolStore store, SignalProtocolAddress remoteAddress) {
        this(store, store, store, store, remoteAddress);
    }

    Optional<Integer> process(SessionRecord sessionRecord, PreKeySignalMessage message) throws InvalidKeyIdException, InvalidKeyException, UntrustedIdentityException {
        IdentityKey theirIdentityKey = message.getIdentityKey();
        if (!this.identityKeyStore.isTrustedIdentity(this.remoteAddress, theirIdentityKey, IdentityKeyStore.Direction.RECEIVING)) {
            throw new UntrustedIdentityException(this.remoteAddress.getName(), theirIdentityKey);
        }
        Optional<Integer> unsignedPreKeyId = this.processV3(sessionRecord, message);
        this.identityKeyStore.saveIdentity(this.remoteAddress, theirIdentityKey);
        return unsignedPreKeyId;
    }

    private Optional<Integer> processV3(SessionRecord sessionRecord, PreKeySignalMessage message) throws UntrustedIdentityException, InvalidKeyIdException, InvalidKeyException {
        if (sessionRecord.hasSessionState(message.getMessageVersion(), message.getBaseKey().serialize())) {
            Log.w(TAG, "We've already setup a session for this V3 message, letting bundled message fall through...");
            return Optional.absent();
        }
        ECKeyPair ourSignedPreKey = this.signedPreKeyStore.loadSignedPreKey(message.getSignedPreKeyId()).getKeyPair();
        BobSignalProtocolParameters.Builder parameters = BobSignalProtocolParameters.newBuilder();
        parameters.setTheirBaseKey(message.getBaseKey()).setTheirIdentityKey(message.getIdentityKey()).setOurIdentityKey(this.identityKeyStore.getIdentityKeyPair()).setOurSignedPreKey(ourSignedPreKey).setOurRatchetKey(ourSignedPreKey);
        if (message.getPreKeyId().isPresent()) {
            parameters.setOurOneTimePreKey(Optional.of(this.preKeyStore.loadPreKey(message.getPreKeyId().get()).getKeyPair()));
        } else {
            parameters.setOurOneTimePreKey(Optional.absent());
        }
        if (!sessionRecord.isFresh()) {
            sessionRecord.archiveCurrentState();
        }
        RatchetingSession.initializeSession(sessionRecord.getSessionState(), parameters.create());
        sessionRecord.getSessionState().setLocalRegistrationId(this.identityKeyStore.getLocalRegistrationId());
        sessionRecord.getSessionState().setRemoteRegistrationId(message.getRegistrationId());
        sessionRecord.getSessionState().setAliceBaseKey(message.getBaseKey().serialize());
        if (message.getPreKeyId().isPresent()) {
            return message.getPreKeyId();
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(PreKeyBundle preKey) throws InvalidKeyException, UntrustedIdentityException {
        Object object = SessionCipher.SESSION_LOCK;
        synchronized (object) {
            if (!this.identityKeyStore.isTrustedIdentity(this.remoteAddress, preKey.getIdentityKey(), IdentityKeyStore.Direction.SENDING)) {
                throw new UntrustedIdentityException(this.remoteAddress.getName(), preKey.getIdentityKey());
            }
            if (preKey.getSignedPreKey() != null && !Curve.verifySignature(preKey.getIdentityKey().getPublicKey(), preKey.getSignedPreKey().serialize(), preKey.getSignedPreKeySignature())) {
                throw new InvalidKeyException("Invalid signature on device key!");
            }
            if (preKey.getSignedPreKey() == null) {
                throw new InvalidKeyException("No signed prekey!");
            }
            SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
            ECKeyPair ourBaseKey = Curve.generateKeyPair();
            ECPublicKey theirSignedPreKey = preKey.getSignedPreKey();
            Optional<ECPublicKey> theirOneTimePreKey = Optional.fromNullable(preKey.getPreKey());
            Optional<Integer> theirOneTimePreKeyId = theirOneTimePreKey.isPresent() ? Optional.of(preKey.getPreKeyId()) : Optional.absent();
            AliceSignalProtocolParameters.Builder parameters = AliceSignalProtocolParameters.newBuilder();
            parameters.setOurBaseKey(ourBaseKey).setOurIdentityKey(this.identityKeyStore.getIdentityKeyPair()).setTheirIdentityKey(preKey.getIdentityKey()).setTheirSignedPreKey(theirSignedPreKey).setTheirRatchetKey(theirSignedPreKey).setTheirOneTimePreKey(theirOneTimePreKey);
            if (!sessionRecord.isFresh()) {
                sessionRecord.archiveCurrentState();
            }
            RatchetingSession.initializeSession(sessionRecord.getSessionState(), parameters.create());
            sessionRecord.getSessionState().setUnacknowledgedPreKeyMessage(theirOneTimePreKeyId, preKey.getSignedPreKeyId(), ourBaseKey.getPublicKey());
            sessionRecord.getSessionState().setLocalRegistrationId(this.identityKeyStore.getLocalRegistrationId());
            sessionRecord.getSessionState().setRemoteRegistrationId(preKey.getRegistrationId());
            sessionRecord.getSessionState().setAliceBaseKey(ourBaseKey.getPublicKey().serialize());
            this.identityKeyStore.saveIdentity(this.remoteAddress, preKey.getIdentityKey());
            this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
        }
    }
}

