/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.ecc;

import org.whispersystems.curve25519.Curve25519;
import org.whispersystems.curve25519.Curve25519KeyPair;
import org.whispersystems.curve25519.VrfSignatureVerificationFailedException;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.DjbECPrivateKey;
import org.whispersystems.libsignal.ecc.DjbECPublicKey;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPrivateKey;
import org.whispersystems.libsignal.ecc.ECPublicKey;

public class Curve {
    public static final int DJB_TYPE = 5;

    public static boolean isNative() {
        return Curve25519.getInstance((String)"best").isNative();
    }

    public static ECKeyPair generateKeyPair() {
        Curve25519KeyPair keyPair = Curve25519.getInstance((String)"best").generateKeyPair();
        return new ECKeyPair(new DjbECPublicKey(keyPair.getPublicKey()), new DjbECPrivateKey(keyPair.getPrivateKey()));
    }

    public static ECPublicKey decodePoint(byte[] bytes, int offset) throws InvalidKeyException {
        if (bytes == null || bytes.length - offset < 1) {
            throw new InvalidKeyException("No key type identifier");
        }
        int type = bytes[offset] & 0xFF;
        switch (type) {
            case 5: {
                if (bytes.length - offset < 33) {
                    throw new InvalidKeyException("Bad key length: " + bytes.length);
                }
                byte[] keyBytes = new byte[32];
                System.arraycopy(bytes, offset + 1, keyBytes, 0, keyBytes.length);
                return new DjbECPublicKey(keyBytes);
            }
        }
        throw new InvalidKeyException("Bad key type: " + type);
    }

    public static ECPrivateKey decodePrivatePoint(byte[] bytes) {
        return new DjbECPrivateKey(bytes);
    }

    public static byte[] calculateAgreement(ECPublicKey publicKey, ECPrivateKey privateKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("public value is null");
        }
        if (privateKey == null) {
            throw new InvalidKeyException("private value is null");
        }
        if (publicKey.getType() != privateKey.getType()) {
            throw new InvalidKeyException("Public and private keys must be of the same type!");
        }
        if (publicKey.getType() == 5) {
            return Curve25519.getInstance((String)"best").calculateAgreement(((DjbECPublicKey)publicKey).getPublicKey(), ((DjbECPrivateKey)privateKey).getPrivateKey());
        }
        throw new InvalidKeyException("Unknown type: " + publicKey.getType());
    }

    public static boolean verifySignature(ECPublicKey signingKey, byte[] message, byte[] signature) throws InvalidKeyException {
        if (signingKey == null || message == null || signature == null) {
            throw new InvalidKeyException("Values must not be null");
        }
        if (signingKey.getType() == 5) {
            return Curve25519.getInstance((String)"best").verifySignature(((DjbECPublicKey)signingKey).getPublicKey(), message, signature);
        }
        throw new InvalidKeyException("Unknown type: " + signingKey.getType());
    }

    public static byte[] calculateSignature(ECPrivateKey signingKey, byte[] message) throws InvalidKeyException {
        if (signingKey == null || message == null) {
            throw new InvalidKeyException("Values must not be null");
        }
        if (signingKey.getType() == 5) {
            return Curve25519.getInstance((String)"best").calculateSignature(((DjbECPrivateKey)signingKey).getPrivateKey(), message);
        }
        throw new InvalidKeyException("Unknown type: " + signingKey.getType());
    }

    public static byte[] calculateVrfSignature(ECPrivateKey signingKey, byte[] message) throws InvalidKeyException {
        if (signingKey == null || message == null) {
            throw new InvalidKeyException("Values must not be null");
        }
        if (signingKey.getType() == 5) {
            return Curve25519.getInstance((String)"best").calculateVrfSignature(((DjbECPrivateKey)signingKey).getPrivateKey(), message);
        }
        throw new InvalidKeyException("Unknown type: " + signingKey.getType());
    }

    public static byte[] verifyVrfSignature(ECPublicKey signingKey, byte[] message, byte[] signature) throws InvalidKeyException, VrfSignatureVerificationFailedException {
        if (signingKey == null || message == null || signature == null) {
            throw new InvalidKeyException("Values must not be null");
        }
        if (signingKey.getType() == 5) {
            return Curve25519.getInstance((String)"best").verifyVrfSignature(((DjbECPublicKey)signingKey).getPublicKey(), message, signature);
        }
        throw new InvalidKeyException("Unknown type: " + signingKey.getType());
    }
}

