/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPrivateKey;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.state.StorageProtos;

public class SignedPreKeyRecord {
    private StorageProtos.SignedPreKeyRecordStructure structure;

    public SignedPreKeyRecord(int id, long timestamp, ECKeyPair keyPair, byte[] signature) {
        this.structure = (StorageProtos.SignedPreKeyRecordStructure)StorageProtos.SignedPreKeyRecordStructure.newBuilder().setId(id).setPublicKey(ByteString.copyFrom((byte[])keyPair.getPublicKey().serialize())).setPrivateKey(ByteString.copyFrom((byte[])keyPair.getPrivateKey().serialize())).setSignature(ByteString.copyFrom((byte[])signature)).setTimestamp(timestamp).build();
    }

    public SignedPreKeyRecord(byte[] serialized) throws IOException {
        this.structure = StorageProtos.SignedPreKeyRecordStructure.parseFrom(serialized);
    }

    public int getId() {
        return this.structure.getId();
    }

    public long getTimestamp() {
        return this.structure.getTimestamp();
    }

    public ECKeyPair getKeyPair() {
        try {
            ECPublicKey publicKey = Curve.decodePoint(this.structure.getPublicKey().toByteArray(), 0);
            ECPrivateKey privateKey = Curve.decodePrivatePoint(this.structure.getPrivateKey().toByteArray());
            return new ECKeyPair(publicKey, privateKey);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] getSignature() {
        return this.structure.getSignature().toByteArray();
    }

    public byte[] serialize() {
        return this.structure.toByteArray();
    }
}

