/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state.impl;

import java.util.HashMap;
import java.util.Map;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.state.IdentityKeyStore;

public class InMemoryIdentityKeyStore
implements IdentityKeyStore {
    private final Map<SignalProtocolAddress, IdentityKey> trustedKeys = new HashMap<SignalProtocolAddress, IdentityKey>();
    private final IdentityKeyPair identityKeyPair;
    private final int localRegistrationId;

    public InMemoryIdentityKeyStore(IdentityKeyPair identityKeyPair, int localRegistrationId) {
        this.identityKeyPair = identityKeyPair;
        this.localRegistrationId = localRegistrationId;
    }

    @Override
    public IdentityKeyPair getIdentityKeyPair() {
        return this.identityKeyPair;
    }

    @Override
    public int getLocalRegistrationId() {
        return this.localRegistrationId;
    }

    @Override
    public boolean saveIdentity(SignalProtocolAddress address, IdentityKey identityKey) {
        IdentityKey existing = this.trustedKeys.get(address);
        if (!identityKey.equals(existing)) {
            this.trustedKeys.put(address, identityKey);
            return true;
        }
        return false;
    }

    @Override
    public boolean isTrustedIdentity(SignalProtocolAddress address, IdentityKey identityKey, IdentityKeyStore.Direction direction) {
        IdentityKey trusted = this.trustedKeys.get(address);
        return trusted == null || trusted.equals(identityKey);
    }

    @Override
    public IdentityKey getIdentity(SignalProtocolAddress address) {
        return this.trustedKeys.get(address);
    }
}

