/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.PreKeyStore;

public class InMemoryPreKeyStore
implements PreKeyStore {
    private final Map<Integer, byte[]> store = new HashMap<Integer, byte[]>();

    @Override
    public PreKeyRecord loadPreKey(int preKeyId) throws InvalidKeyIdException {
        try {
            if (!this.store.containsKey(preKeyId)) {
                throw new InvalidKeyIdException("No such prekeyrecord!");
            }
            return new PreKeyRecord(this.store.get(preKeyId));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void storePreKey(int preKeyId, PreKeyRecord record) {
        this.store.put(preKeyId, record.serialize());
    }

    @Override
    public boolean containsPreKey(int preKeyId) {
        return this.store.containsKey(preKeyId);
    }

    @Override
    public void removePreKey(int preKeyId) {
        this.store.remove(preKeyId);
    }
}

