/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsoniter;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Base64;
import systems.comodal.jsoniter.BytesJsonIterator;
import systems.comodal.jsoniter.JsonIterator;

final class BufferedStreamJsonIterator
extends BytesJsonIterator {
    private InputStream in;

    BufferedStreamJsonIterator(InputStream in, byte[] buf, int head, int tail) {
        super(buf, head, tail);
        this.in = in;
    }

    BufferedStreamJsonIterator(InputStream in, byte[] buf, int head, int tail, int charBufferLength) {
        super(buf, head, tail, charBufferLength);
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public boolean supportsMarkReset() {
        return false;
    }

    @Override
    public int mark() {
        throw new UnsupportedOperationException("Mark is not supported when using an InputStream.");
    }

    @Override
    public JsonIterator reset(int mark) {
        throw new UnsupportedOperationException("Reset via mark is not supported when using an InputStream.");
    }

    @Override
    public JsonIterator reset(byte[] buf) {
        return new BytesJsonIterator(buf, 0, buf.length);
    }

    @Override
    public JsonIterator reset(byte[] buf, int head, int tail) {
        return new BytesJsonIterator(buf, head, tail);
    }

    @Override
    public JsonIterator reset(InputStream in) {
        this.in = in;
        this.head = 0;
        this.tail = 0;
        return this;
    }

    @Override
    public JsonIterator reset(InputStream in, int bufSize) {
        if (this.buf.length != bufSize) {
            this.buf = new byte[bufSize];
        }
        this.in = in;
        this.head = 0;
        this.tail = 0;
        return this;
    }

    @Override
    boolean loadMore() {
        try {
            int n = this.in.read(this.buf);
            if (n < 1) {
                if (n == -1) {
                    return false;
                }
                throw this.reportError("loadMore", "read from input stream returned " + n);
            }
            this.head = 0;
            this.tail = n;
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    byte read() {
        if (this.head == this.tail && !this.loadMore()) {
            throw this.reportError("read", "no more to read");
        }
        return this.buf[this.head++];
    }

    @Override
    public byte[] decodeBase64String() {
        return Base64.getDecoder().decode(this.readString());
    }
}

