/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsoniter;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.math.BigDecimal;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import systems.comodal.jsoniter.BaseJsonIterator;
import systems.comodal.jsoniter.BufferedStreamJsonIterator;
import systems.comodal.jsoniter.CharBufferConsumer;
import systems.comodal.jsoniter.CharBufferFunction;
import systems.comodal.jsoniter.CharBufferPredicate;
import systems.comodal.jsoniter.CharBufferToIntFunction;
import systems.comodal.jsoniter.CharBufferToLongFunction;
import systems.comodal.jsoniter.CharsJsonIterator;
import systems.comodal.jsoniter.ContextCharBufferConsumer;
import systems.comodal.jsoniter.ContextCharBufferFunction;
import systems.comodal.jsoniter.ContextCharBufferPredicate;
import systems.comodal.jsoniter.ContextCharBufferToIntFunction;
import systems.comodal.jsoniter.ContextCharBufferToLongFunction;
import systems.comodal.jsoniter.ContextFieldBufferFunction;
import systems.comodal.jsoniter.ContextFieldBufferMaskedPredicate;
import systems.comodal.jsoniter.ContextFieldBufferPredicate;
import systems.comodal.jsoniter.FieldBufferFunction;
import systems.comodal.jsoniter.FieldBufferPredicate;
import systems.comodal.jsoniter.JHex;
import systems.comodal.jsoniter.JIUtil;
import systems.comodal.jsoniter.JsonException;
import systems.comodal.jsoniter.JsonIterator;

class BytesJsonIterator
extends BaseJsonIterator {
    private static final VarHandle TO_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final long QUOTE_PATTERN = JIUtil.compileReplacePattern((byte)34);
    private static final long ESCAPE_PATTERN = JIUtil.compileReplacePattern((byte)92);
    private static final long MULTI_BYTE_CHAR_PATTERN = JIUtil.compileReplacePattern((byte)-128);
    byte[] buf;
    private char[] charBuf;
    private static final BytesFunction<byte[]> BASE64_DECODER = (buf, from, to) -> Base64.getDecoder().decode(Arrays.copyOfRange(buf, from, to));

    BytesJsonIterator(byte[] buf, int head, int tail) {
        this(buf, head, tail, 64);
    }

    BytesJsonIterator(byte[] buf, int head, int tail, int charBufferLength) {
        super(head, tail);
        this.buf = buf;
        this.charBuf = new char[charBufferLength];
    }

    private static long matchPattern(long input) {
        return ((input & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL | input | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static boolean containsPattern(long input) {
        return BytesJsonIterator.matchPattern(input) != 0L;
    }

    private static long matchQuotePattern(long word) {
        return BytesJsonIterator.matchPattern(word ^ QUOTE_PATTERN);
    }

    private static boolean containsMultiByteOrEscapePattern(long word) {
        return BytesJsonIterator.containsPattern(word ^ MULTI_BYTE_CHAR_PATTERN) || BytesJsonIterator.containsPattern(word ^ ESCAPE_PATTERN);
    }

    @Override
    public boolean supportsMarkReset() {
        return true;
    }

    @Override
    public JsonIterator reset(byte[] buf) {
        this.buf = buf;
        this.head = 0;
        this.tail = buf.length;
        return this;
    }

    @Override
    public JsonIterator reset(byte[] buf, int head, int tail) {
        this.buf = buf;
        this.head = head;
        this.tail = tail;
        return this;
    }

    @Override
    public JsonIterator reset(char[] buf) {
        return this.reset(buf, 0, buf.length);
    }

    @Override
    public JsonIterator reset(char[] buf, int head, int tail) {
        return new CharsJsonIterator(buf, head, tail);
    }

    @Override
    public JsonIterator reset(InputStream in) {
        return new BufferedStreamJsonIterator(in, this.buf, 0, 0);
    }

    @Override
    public JsonIterator reset(InputStream in, int bufSize) {
        return new BufferedStreamJsonIterator(in, this.buf.length == bufSize ? this.buf : new byte[bufSize], 0, 0);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    final String getBufferString(int from, int to) {
        return new String(this.buf, from, Math.min(to, this.tail) - from);
    }

    @Override
    final char nextToken() {
        byte c;
        int i = this.head;
        block3: while (true) {
            if (i == this.tail) {
                if (this.loadMore()) {
                    i = this.head;
                } else {
                    throw this.reportError("nextToken", "unexpected end");
                }
            }
            c = this.buf[i++];
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        this.head = i;
        return (char)(c & 0xFF);
    }

    @Override
    final char peekToken() {
        int i = this.head;
        while (true) {
            if (i == this.tail) {
                if (this.loadMore()) {
                    i = this.head;
                } else {
                    throw this.reportError("peekToken", "unexpected end");
                }
            }
            byte c = this.buf[i];
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    this.head = i;
                    return (char)(c & 0xFF);
                }
            }
            ++i;
        }
    }

    byte read() {
        return this.buf[this.head++];
    }

    @Override
    final char readChar() {
        return (char)(this.read() & 0xFF);
    }

    @Override
    final char peekChar() {
        return (char)(this.buf[this.head] & 0xFF);
    }

    @Override
    final char peekChar(int offset) {
        return (char)(this.buf[offset] & 0xFF);
    }

    @Override
    final int peekIntDigitChar(int offset) {
        return INT_DIGITS[this.buf[offset]];
    }

    private void doubleReusableCharBuffer() {
        char[] newBuf = new char[this.charBuf.length << 1];
        System.arraycopy(this.charBuf, 0, newBuf, 0, this.charBuf.length);
        this.charBuf = newBuf;
    }

    @Override
    final int parse() {
        int j = 0;
        while (this.head < this.tail || this.loadMore()) {
            byte c = this.buf[this.head];
            if (c == 34) {
                ++this.head;
                return j;
            }
            if ((c ^ 0x5C) < 1) {
                return this.parseMultiByteString(j);
            }
            ++this.head;
            if (j == this.charBuf.length) {
                this.doubleReusableCharBuffer();
            }
            this.charBuf[j++] = (char)(c & 0xFF);
        }
        throw this.reportError("parse", "incomplete string");
    }

    final void skipPastSingleByteEndQuote() {
        while (this.head < this.tail || this.loadMore()) {
            byte c = this.buf[this.head];
            if (c == 34) {
                ++this.head;
                return;
            }
            if ((c ^ 0x5C) < 1) {
                this.skipPastMultiByteEndQuote();
                return;
            }
            ++this.head;
        }
        throw this.reportError("skipPastSingleByteEndQuote", "incomplete string");
    }

    @Override
    final void skipPastEndQuote() {
        int nextOffset = this.head + 8;
        if (nextOffset <= this.tail) {
            block5: {
                while (true) {
                    long word;
                    if (BytesJsonIterator.containsMultiByteOrEscapePattern(word = TO_LONG.get(this.buf, this.head))) {
                        this.skipPastMultiByteEndQuote();
                        return;
                    }
                    long tmp = BytesJsonIterator.matchQuotePattern(word);
                    if (tmp != 0L) {
                        this.head += Long.numberOfTrailingZeros(tmp << 1) >>> 3;
                        return;
                    }
                    this.head = nextOffset;
                    if ((nextOffset += 8) <= this.tail) continue;
                    if (this.head < this.tail) {
                        this.head = this.tail - 8;
                        continue;
                    }
                    if (!this.loadMore()) break block5;
                    nextOffset = this.head + 8;
                    if (nextOffset > this.tail) break;
                }
                this.skipPastSingleByteEndQuote();
                return;
            }
            throw this.reportError("skipPastEndQuote", "incomplete string");
        }
        this.skipPastSingleByteEndQuote();
    }

    @Override
    public byte[] decodeBase64String() {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parseBase64String();
        }
        if (c == 'n') {
            this.skip(3);
            return null;
        }
        throw this.reportError("decodeBase64String", "expected string or null, but " + c);
    }

    final byte[] parseBase64String() {
        int from = this.head;
        int nextOffset = this.head + 8;
        if (nextOffset > this.tail) {
            int len = this.parse();
            return BASE64_DECODER.apply(this.buf, from, from + len);
        }
        int i = this.head;
        while (true) {
            long word;
            long tmp;
            if ((tmp = BytesJsonIterator.matchQuotePattern(word = TO_LONG.get(this.buf, i))) != 0L) {
                int to = (i += Long.numberOfTrailingZeros(tmp << 1) >>> 3) - 1;
                byte[] data = BASE64_DECODER.apply(this.buf, this.head, to);
                this.head = i;
                return data;
            }
            i = nextOffset;
            if ((nextOffset += 8) <= this.tail) continue;
            if (i >= this.tail) break;
            i = this.tail - 8;
        }
        throw this.reportError("decodeBase64String", "incomplete string");
    }

    @Override
    protected final String parseString() {
        int nextOffset = this.head + 8;
        if (nextOffset > this.tail) {
            int len = this.parse();
            return new String(this.charBuf, 0, len);
        }
        int i = this.head;
        while (true) {
            long word;
            if (BytesJsonIterator.containsMultiByteOrEscapePattern(word = TO_LONG.get(this.buf, i))) {
                int len = this.parseMultiByteString(0);
                return new String(this.charBuf, 0, len);
            }
            long tmp = BytesJsonIterator.matchQuotePattern(word);
            if (tmp != 0L) {
                String str = new String(this.buf, this.head, (i += Long.numberOfTrailingZeros(tmp << 1) >>> 3) - 1 - this.head, StandardCharsets.US_ASCII);
                this.head = i;
                return str;
            }
            i = nextOffset;
            if ((nextOffset += 8) <= this.tail) continue;
            if (i >= this.tail) break;
            i = this.tail - 8;
        }
        if (this.supportsMarkReset()) {
            throw this.reportError("parseString", "incomplete string");
        }
        int len = this.parseMultiByteString(0);
        return new String(this.charBuf, 0, len);
    }

    @Override
    final <R> R parse(CharBufferFunction<R> applyChars) {
        int len = this.parse();
        return applyChars.apply(this.charBuf, 0, len);
    }

    @Override
    final <C, R> R parse(C context, ContextCharBufferFunction<C, R> applyChars) {
        int len = this.parse();
        return applyChars.apply(context, this.charBuf, 0, len);
    }

    @Override
    final int parse(CharBufferToIntFunction applyChars) {
        int len = this.parse();
        return applyChars.applyAsInt(this.charBuf, 0, len);
    }

    @Override
    final <C> int parse(C context, ContextCharBufferToIntFunction<C> applyChars) {
        int len = this.parse();
        return applyChars.applyAsInt(context, this.charBuf, 0, len);
    }

    @Override
    final long parse(CharBufferToLongFunction applyChars) {
        int len = this.parse();
        return applyChars.applyAsLong(this.charBuf, 0, len);
    }

    @Override
    final <C> long parse(C context, ContextCharBufferToLongFunction<C> applyChars) {
        int len = this.parse();
        return applyChars.applyAsLong(context, this.charBuf, 0, len);
    }

    @Override
    final boolean parse(CharBufferPredicate testChars) {
        int len = this.parse();
        return testChars.apply(this.charBuf, 0, len);
    }

    @Override
    final <C> boolean parse(C context, ContextCharBufferPredicate<C> testChars) {
        int len = this.parse();
        return testChars.apply(context, this.charBuf, 0, len);
    }

    @Override
    final void parse(CharBufferConsumer testChars) {
        int len = this.parse();
        testChars.accept(this.charBuf, 0, len);
    }

    @Override
    final <C> void parse(C context, ContextCharBufferConsumer<C> testChars) {
        int len = this.parse();
        testChars.accept(context, this.charBuf, 0, len);
    }

    @Override
    final boolean fieldEquals(String field, int offset, int len) {
        return JsonIterator.fieldEquals(field, this.charBuf, 0, len);
    }

    @Override
    final boolean breakOut(FieldBufferPredicate fieldBufferFunction, int offset, int len) {
        return !fieldBufferFunction.test(this.charBuf, 0, len, this);
    }

    @Override
    final <C> boolean breakOut(C context, ContextFieldBufferPredicate<C> fieldBufferFunction, int offset, int len) {
        return !fieldBufferFunction.test(context, this.charBuf, 0, len, this);
    }

    @Override
    final <C> long test(C context, long mask, ContextFieldBufferMaskedPredicate<C> fieldBufferFunction, int offset, int len) {
        return fieldBufferFunction.test(context, mask, this.charBuf, 0, len, this);
    }

    @Override
    final <R> R apply(FieldBufferFunction<R> fieldBufferFunction, int offset, int len) {
        return fieldBufferFunction.apply(this.charBuf, 0, len, this);
    }

    @Override
    final <C, R> R apply(C context, ContextFieldBufferFunction<C, R> fieldBufferFunction, int offset, int len) {
        return fieldBufferFunction.apply(context, this.charBuf, 0, len, this);
    }

    @Override
    final BigDecimal parseBigDecimal(CharBufferFunction<BigDecimal> parseChars) {
        return parseChars.apply(this.charBuf, 0, this.parseNumber());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseMultiByteString(int j) {
        boolean isExpectingLowSurrogate = false;
        while (this.head < this.tail || this.loadMore()) {
            int bc;
            block32: {
                block31: {
                    if ((bc = this.buf[this.head++]) == 34) {
                        return j;
                    }
                    if (bc != 92) break block31;
                    if (this.head == this.tail && !this.loadMore()) throw this.reportError("parseMultiByteString", "incomplete string");
                    bc = this.buf[this.head++];
                    switch (bc) {
                        case 98: {
                            bc = 8;
                            break block32;
                        }
                        case 116: {
                            bc = 9;
                            break block32;
                        }
                        case 110: {
                            bc = 10;
                            break block32;
                        }
                        case 102: {
                            bc = 12;
                            break block32;
                        }
                        case 114: {
                            bc = 13;
                            break block32;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            break block32;
                        }
                        case 117: {
                            if (this.head == this.tail && !this.loadMore()) {
                                throw this.reportError("parseMultiByteString", "incomplete string");
                            }
                            bc = JHex.decode(this.buf[this.head++]) << 12;
                            if (this.head == this.tail && !this.loadMore()) {
                                throw this.reportError("parseMultiByteString", "incomplete string");
                            }
                            bc += JHex.decode(this.buf[this.head++]) << 8;
                            if (this.head == this.tail && !this.loadMore()) {
                                throw this.reportError("parseMultiByteString", "incomplete string");
                            }
                            bc += JHex.decode(this.buf[this.head++]) << 4;
                            if (this.head == this.tail && !this.loadMore()) {
                                throw this.reportError("parseMultiByteString", "incomplete string");
                            }
                            bc += JHex.decode(this.buf[this.head++]);
                            if (isExpectingLowSurrogate) {
                                if (!Character.isLowSurrogate((char)bc)) throw new JsonException("invalid surrogate");
                                isExpectingLowSurrogate = false;
                            } else if (Character.isHighSurrogate((char)bc)) {
                                isExpectingLowSurrogate = true;
                            } else if (Character.isLowSurrogate((char)bc)) {
                                throw new JsonException("invalid surrogate");
                            }
                            break block32;
                        }
                        default: {
                            throw this.reportError("parseMultiByteString", "invalid escape character: " + bc);
                        }
                    }
                }
                if ((bc & 0x80) != 0) {
                    if (this.head == this.tail && !this.loadMore()) throw this.reportError("parseMultiByteString", "incomplete string");
                    byte u2 = this.buf[this.head++];
                    if ((bc & 0xE0) == 192) {
                        bc = ((bc & 0x1F) << 6) + (u2 & 0x3F);
                    } else {
                        if (this.head == this.tail && !this.loadMore()) throw this.reportError("parseMultiByteString", "incomplete string");
                        byte u3 = this.buf[this.head++];
                        if ((bc & 0xF0) == 224) {
                            bc = ((bc & 0xF) << 12) + ((u2 & 0x3F) << 6) + (u3 & 0x3F);
                        } else {
                            if (this.head == this.tail && !this.loadMore()) throw this.reportError("parseMultiByteString", "incomplete string");
                            byte u4 = this.buf[this.head++];
                            if ((bc & 0xF8) != 240) {
                                throw this.reportError("parseMultiByteString", "invalid unicode character");
                            }
                            bc = ((bc & 7) << 18) + ((u2 & 0x3F) << 12) + ((u3 & 0x3F) << 6) + (u4 & 0x3F);
                            if (bc >= 65536) {
                                if (bc >= 0x110000) {
                                    throw this.reportError("parseMultiByteString", "invalid unicode character");
                                }
                                int sup = bc - 65536;
                                if (this.charBuf.length == j) {
                                    this.doubleReusableCharBuffer();
                                }
                                this.charBuf[j++] = (char)((sup >>> 10) + 55296);
                                if (this.charBuf.length == j) {
                                    this.doubleReusableCharBuffer();
                                }
                                this.charBuf[j++] = (char)((sup & 0x3FF) + 56320);
                                continue;
                            }
                        }
                    }
                }
            }
            if (this.charBuf.length == j) {
                this.doubleReusableCharBuffer();
            }
            this.charBuf[j++] = (char)bc;
        }
        throw this.reportError("parseMultiByteString", "incomplete string");
    }

    private void skipPastMultiByteEndQuote() {
        boolean isExpectingLowSurrogate = false;
        block4: while (this.head < this.tail || this.loadMore()) {
            int bc;
            if ((bc = this.buf[this.head++]) == 34) {
                return;
            }
            if (bc == 92) {
                if (this.head == this.tail && !this.loadMore()) break;
                bc = this.buf[this.head++];
                switch (bc) {
                    case 34: 
                    case 47: 
                    case 92: 
                    case 98: 
                    case 102: 
                    case 110: 
                    case 114: 
                    case 116: {
                        continue block4;
                    }
                    case 117: {
                        if (this.head == this.tail && !this.loadMore()) {
                            throw this.reportError("skipPastMultiByteEndQuote", "incomplete string");
                        }
                        bc = JHex.decode(this.buf[this.head++]) << 12;
                        if (this.head == this.tail && !this.loadMore()) {
                            throw this.reportError("skipPastMultiByteEndQuote", "incomplete string");
                        }
                        bc += JHex.decode(this.buf[this.head++]) << 8;
                        if (this.head == this.tail && !this.loadMore()) {
                            throw this.reportError("skipPastMultiByteEndQuote", "incomplete string");
                        }
                        bc += JHex.decode(this.buf[this.head++]) << 4;
                        if (this.head == this.tail && !this.loadMore()) {
                            throw this.reportError("skipPastMultiByteEndQuote", "incomplete string");
                        }
                        bc += JHex.decode(this.buf[this.head++]);
                        if (isExpectingLowSurrogate) {
                            if (Character.isLowSurrogate((char)bc)) {
                                isExpectingLowSurrogate = false;
                                continue block4;
                            }
                            throw new JsonException("invalid surrogate");
                        }
                        if (Character.isHighSurrogate((char)bc)) {
                            isExpectingLowSurrogate = true;
                            continue block4;
                        }
                        if (!Character.isLowSurrogate((char)bc)) continue block4;
                        throw new JsonException("invalid surrogate");
                    }
                }
                throw this.reportError("skipPastMultiByteEndQuote", "invalid escape character: " + bc);
            }
            if ((bc & 0x80) == 0) continue;
            if (this.head == this.tail && !this.loadMore()) break;
            byte u2 = this.buf[this.head++];
            if ((bc & 0xE0) == 192) continue;
            if (this.head == this.tail && !this.loadMore()) break;
            byte u3 = this.buf[this.head++];
            if ((bc & 0xF0) == 224) continue;
            if (this.head == this.tail && !this.loadMore()) break;
            byte u4 = this.buf[this.head++];
            if ((bc & 0xF8) != 240) {
                throw this.reportError("skipPastMultiByteEndQuote", "invalid unicode character");
            }
            bc = ((bc & 7) << 18) + ((u2 & 0x3F) << 12) + ((u3 & 0x3F) << 6) + (u4 & 0x3F);
            if (bc < 65536 || bc < 0x110000) continue;
            throw this.reportError("skipPastMultiByteEndQuote", "invalid unicode character");
        }
        throw this.reportError("skipPastMultiByteEndQuote", "incomplete string");
    }

    @Override
    final String parsedNumberAsString(int len) {
        return new String(this.charBuf, 0, len);
    }

    @Override
    final <R> R parseNumber(CharBufferFunction<R> applyChars, int len) {
        return applyChars.apply(this.charBuf, 0, len);
    }

    @Override
    final <C, R> R parseNumber(C context, ContextCharBufferFunction<C, R> applyChars, int len) {
        return applyChars.apply(context, this.charBuf, 0, len);
    }

    @Override
    final int parseNumber(CharBufferToIntFunction applyChars, int len) {
        return applyChars.applyAsInt(this.charBuf, 0, len);
    }

    @Override
    final <C> int parseNumber(C context, ContextCharBufferToIntFunction<C> applyChars, int len) {
        return applyChars.applyAsInt(context, this.charBuf, 0, len);
    }

    @Override
    final long parseNumber(CharBufferToLongFunction applyChars, int len) {
        return applyChars.applyAsLong(this.charBuf, 0, len);
    }

    @Override
    final <C> long parseNumber(C context, ContextCharBufferToLongFunction<C> applyChars, int len) {
        return applyChars.applyAsLong(context, this.charBuf, 0, len);
    }

    @Override
    final int parseNumber() {
        int i = this.head;
        int len = 0;
        while (true) {
            if (i == this.tail) {
                if (this.loadMore()) {
                    i = this.head;
                } else {
                    this.head = this.tail;
                    return len;
                }
            }
            if (len == this.charBuf.length) {
                this.doubleReusableCharBuffer();
            }
            char c = this.peekChar(i);
            switch (c) {
                case ' ': {
                    break;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'E': 
                case 'e': {
                    this.charBuf[len++] = c;
                    break;
                }
                default: {
                    this.head = i;
                    return len;
                }
            }
            ++i;
        }
    }

    @FunctionalInterface
    private static interface BytesFunction<T> {
        public T apply(byte[] var1, int var2, int var3);
    }
}

