/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsoniter;

import java.io.InputStream;
import java.math.BigDecimal;
import systems.comodal.jsoniter.BaseJsonIterator;
import systems.comodal.jsoniter.CharBufferConsumer;
import systems.comodal.jsoniter.CharBufferFunction;
import systems.comodal.jsoniter.CharBufferPredicate;
import systems.comodal.jsoniter.CharBufferToIntFunction;
import systems.comodal.jsoniter.CharBufferToLongFunction;
import systems.comodal.jsoniter.ContextCharBufferConsumer;
import systems.comodal.jsoniter.ContextCharBufferFunction;
import systems.comodal.jsoniter.ContextCharBufferPredicate;
import systems.comodal.jsoniter.ContextCharBufferToIntFunction;
import systems.comodal.jsoniter.ContextCharBufferToLongFunction;
import systems.comodal.jsoniter.ContextFieldBufferFunction;
import systems.comodal.jsoniter.ContextFieldBufferMaskedPredicate;
import systems.comodal.jsoniter.ContextFieldBufferPredicate;
import systems.comodal.jsoniter.FieldBufferFunction;
import systems.comodal.jsoniter.FieldBufferPredicate;
import systems.comodal.jsoniter.JsonIterator;

final class CharsJsonIterator
extends BaseJsonIterator {
    private char[] buf;
    private int numEscapes = 0;

    CharsJsonIterator(char[] buf, int head, int tail) {
        super(head, tail);
        this.buf = buf;
    }

    @Override
    public boolean supportsMarkReset() {
        return true;
    }

    @Override
    public JsonIterator reset(byte[] buf) {
        return JsonIterator.parse(buf);
    }

    @Override
    public JsonIterator reset(byte[] buf, int head, int tail) {
        return JsonIterator.parse(buf, head, tail);
    }

    @Override
    public JsonIterator reset(char[] buf) {
        this.buf = buf;
        this.head = 0;
        this.tail = buf.length;
        return this;
    }

    @Override
    public JsonIterator reset(char[] buf, int head, int tail) {
        this.buf = buf;
        this.head = head;
        this.tail = tail;
        return this;
    }

    @Override
    public JsonIterator reset(InputStream in) {
        return JsonIterator.parse(in, this.buf.length);
    }

    @Override
    public JsonIterator reset(InputStream in, int bufSize) {
        return JsonIterator.parse(in, bufSize);
    }

    @Override
    public void close() {
    }

    @Override
    String getBufferString(int from, int to) {
        return new String(this.buf, from, Math.min(to, this.tail) - from);
    }

    @Override
    char nextToken() {
        char c;
        int i = this.head;
        block3: while (true) {
            c = this.buf[i++];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        this.head = i;
        return c;
    }

    @Override
    char peekToken() {
        int i = this.head;
        while (true) {
            char c = this.buf[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    this.head = i;
                    return c;
                }
            }
            ++i;
        }
    }

    @Override
    char readChar() {
        return this.buf[this.head++];
    }

    @Override
    char peekChar() {
        return this.buf[this.head];
    }

    @Override
    char peekChar(int offset) {
        return this.buf[offset];
    }

    @Override
    int peekIntDigitChar(int offset) {
        return INT_DIGITS[this.buf[offset]];
    }

    @Override
    int parse() {
        return this.parse(this.head);
    }

    private int parse(int from) {
        this.numEscapes = 0;
        int i = from;
        while (true) {
            if (i >= this.tail) {
                throw this.reportError("parse", "incomplete string");
            }
            char c = this.peekChar(i);
            if (c == '\"') {
                this.head = i + 1;
                return i - from;
            }
            if (c == '\\') {
                ++this.numEscapes;
                ++i;
            }
            ++i;
        }
    }

    @Override
    void skipPastEndQuote() {
        while (this.head < this.tail) {
            char c;
            if ((c = this.buf[this.head++]) == '\"') {
                return;
            }
            if (c != '\\') continue;
            ++this.head;
        }
        throw this.reportError("skipPastEndQuote", "incomplete string");
    }

    @Override
    int parseNumber() {
        int i = this.head;
        int len = 0;
        while (true) {
            if (i == this.tail) {
                this.head = this.tail;
                return len;
            }
            switch (this.peekChar(i)) {
                case ' ': {
                    break;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'E': 
                case 'e': {
                    ++len;
                    break;
                }
                default: {
                    this.head = i;
                    return len;
                }
            }
            ++i;
        }
    }

    private char[] handleEscapes(int from, int len) {
        char[] chars = new char[len - this.numEscapes];
        int i = 0;
        int j = from;
        while (i < chars.length) {
            char c = this.buf[j];
            if (c == '\\') {
                c = this.buf[++j];
            }
            chars[i] = c;
            ++i;
            ++j;
        }
        return chars;
    }

    @Override
    <R> R parse(CharBufferFunction<R> applyChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            return applyChars.apply(chars, 0, chars.length);
        }
        return applyChars.apply(this.buf, from, len);
    }

    @Override
    <C, R> R parse(C context, ContextCharBufferFunction<C, R> applyChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            return applyChars.apply(context, chars, 0, chars.length);
        }
        return applyChars.apply(context, this.buf, from, len);
    }

    @Override
    int parse(CharBufferToIntFunction applyChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            return applyChars.applyAsInt(chars, 0, chars.length);
        }
        return applyChars.applyAsInt(this.buf, from, len);
    }

    @Override
    <C> int parse(C context, ContextCharBufferToIntFunction<C> applyChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            return applyChars.applyAsInt(context, chars, 0, chars.length);
        }
        return applyChars.applyAsInt(context, this.buf, from, len);
    }

    @Override
    long parse(CharBufferToLongFunction applyChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            return applyChars.applyAsLong(chars, 0, chars.length);
        }
        return applyChars.applyAsLong(this.buf, from, len);
    }

    @Override
    <C> long parse(C context, ContextCharBufferToLongFunction<C> applyChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            return applyChars.applyAsLong(context, chars, 0, chars.length);
        }
        return applyChars.applyAsLong(context, this.buf, from, len);
    }

    @Override
    boolean parse(CharBufferPredicate testChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            return testChars.apply(chars, 0, chars.length);
        }
        return testChars.apply(this.buf, from, len);
    }

    @Override
    <C> boolean parse(C context, ContextCharBufferPredicate<C> testChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            return testChars.apply(context, chars, 0, chars.length);
        }
        return testChars.apply(context, this.buf, from, len);
    }

    @Override
    void parse(CharBufferConsumer testChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            testChars.accept(chars, 0, chars.length);
        } else {
            testChars.accept(this.buf, from, len);
        }
    }

    @Override
    <C> void parse(C context, ContextCharBufferConsumer<C> testChars) {
        int from = this.head;
        int len = this.parse(from);
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(from, len);
            testChars.accept(context, chars, 0, chars.length);
        } else {
            testChars.accept(context, this.buf, from, len);
        }
    }

    @Override
    boolean fieldEquals(String field, int offset, int len) {
        return JsonIterator.fieldEquals(field, this.buf, offset, len);
    }

    @Override
    boolean breakOut(FieldBufferPredicate fieldBufferFunction, int offset, int len) {
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(offset, len);
            return !fieldBufferFunction.test(chars, 0, chars.length, this);
        }
        return !fieldBufferFunction.test(this.buf, offset, len, this);
    }

    @Override
    <C> boolean breakOut(C context, ContextFieldBufferPredicate<C> fieldBufferFunction, int offset, int len) {
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(offset, len);
            return !fieldBufferFunction.test(context, chars, 0, chars.length, this);
        }
        return !fieldBufferFunction.test(context, this.buf, offset, len, this);
    }

    @Override
    <C> long test(C context, long mask, ContextFieldBufferMaskedPredicate<C> fieldBufferFunction, int offset, int len) {
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(offset, len);
            return fieldBufferFunction.test(context, mask, chars, 0, chars.length, this);
        }
        return fieldBufferFunction.test(context, mask, this.buf, offset, len, this);
    }

    @Override
    <R> R apply(FieldBufferFunction<R> fieldBufferFunction, int offset, int len) {
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(offset, len);
            return fieldBufferFunction.apply(chars, 0, chars.length, this);
        }
        return fieldBufferFunction.apply(this.buf, offset, len, this);
    }

    @Override
    <C, R> R apply(C context, ContextFieldBufferFunction<C, R> fieldBufferFunction, int offset, int len) {
        if (this.numEscapes > 0) {
            char[] chars = this.handleEscapes(offset, len);
            return fieldBufferFunction.apply(context, chars, 0, chars.length, this);
        }
        return fieldBufferFunction.apply(context, this.buf, offset, len, this);
    }

    @Override
    BigDecimal parseBigDecimal(CharBufferFunction<BigDecimal> parseChars) {
        int len = this.parseNumber();
        return parseChars.apply(this.buf, this.head - len, len);
    }

    @Override
    String parsedNumberAsString(int len) {
        return new String(this.buf, this.head - len, len);
    }

    @Override
    <R> R parseNumber(CharBufferFunction<R> applyChars, int len) {
        return applyChars.apply(this.buf, this.head - len, len);
    }

    @Override
    <C, R> R parseNumber(C context, ContextCharBufferFunction<C, R> applyChars, int len) {
        return applyChars.apply(context, this.buf, this.head - len, len);
    }

    @Override
    int parseNumber(CharBufferToIntFunction applyChars, int len) {
        return applyChars.applyAsInt(this.buf, this.head - len, len);
    }

    @Override
    <C> int parseNumber(C context, ContextCharBufferToIntFunction<C> applyChars, int len) {
        return applyChars.applyAsInt(context, this.buf, this.head - len, len);
    }

    @Override
    long parseNumber(CharBufferToLongFunction applyChars, int len) {
        return applyChars.applyAsLong(this.buf, this.head - len, len);
    }

    @Override
    <C> long parseNumber(C context, ContextCharBufferToLongFunction<C> applyChars, int len) {
        return applyChars.applyAsLong(context, this.buf, this.head - len, len);
    }
}

