/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsoniter;

import java.util.Arrays;

final class JHex {
    private static final int INVALID = -1;
    private static final int[] DIGITS = INIT_DIGITS.initDigits();

    private JHex() {
    }

    static int decode(int b) {
        int val = DIGITS[b];
        if (val == -1) {
            throw new IndexOutOfBoundsException(b + " is not valid hex digit");
        }
        return val;
    }

    private static final class INIT_DIGITS {
        private INIT_DIGITS() {
        }

        private static int[] initDigits() {
            int i;
            int[] digits = new int[103];
            Arrays.fill(digits, -1);
            for (i = 48; i <= 57; ++i) {
                digits[i] = i - 48;
            }
            for (i = 97; i <= 102; ++i) {
                digits[i] = i - 97 + 10;
            }
            for (i = 65; i <= 70; ++i) {
                digits[i] = i - 65 + 10;
            }
            return digits;
        }
    }
}

