/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsoniter;

import java.io.Closeable;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import systems.comodal.jsoniter.BufferedStreamJsonIterator;
import systems.comodal.jsoniter.BytesJsonIterator;
import systems.comodal.jsoniter.CharBufferConsumer;
import systems.comodal.jsoniter.CharBufferFunction;
import systems.comodal.jsoniter.CharBufferPredicate;
import systems.comodal.jsoniter.CharBufferToIntFunction;
import systems.comodal.jsoniter.CharBufferToLongFunction;
import systems.comodal.jsoniter.CharsJsonIterator;
import systems.comodal.jsoniter.ContextCharBufferConsumer;
import systems.comodal.jsoniter.ContextCharBufferFunction;
import systems.comodal.jsoniter.ContextCharBufferPredicate;
import systems.comodal.jsoniter.ContextCharBufferToIntFunction;
import systems.comodal.jsoniter.ContextCharBufferToLongFunction;
import systems.comodal.jsoniter.ContextFieldBufferFunction;
import systems.comodal.jsoniter.ContextFieldBufferMaskedPredicate;
import systems.comodal.jsoniter.ContextFieldBufferPredicate;
import systems.comodal.jsoniter.FieldBufferFunction;
import systems.comodal.jsoniter.FieldBufferPredicate;
import systems.comodal.jsoniter.ValueType;

public interface JsonIterator
extends Closeable {
    public static JsonIterator parse(InputStream in, int bufSize) {
        return new BufferedStreamJsonIterator(in, new byte[bufSize], 0, 0);
    }

    public static JsonIterator parse(InputStream in, int bufSize, int charBufferLength) {
        return new BufferedStreamJsonIterator(in, new byte[bufSize], 0, 0, charBufferLength);
    }

    public static JsonIterator parse(byte[] buf) {
        return new BytesJsonIterator(buf, 0, buf.length);
    }

    public static JsonIterator parse(byte[] buf, int charBufferLength) {
        return new BytesJsonIterator(buf, 0, buf.length, charBufferLength);
    }

    public static JsonIterator parse(byte[] buf, int head, int tail) {
        return new BytesJsonIterator(buf, head, tail);
    }

    public static JsonIterator parse(byte[] buf, int head, int tail, int charBufferLength) {
        return new BytesJsonIterator(buf, head, tail, charBufferLength);
    }

    public static JsonIterator parse(char[] buf) {
        return new CharsJsonIterator(buf, 0, buf.length);
    }

    public static JsonIterator parse(char[] buf, int head, int tail) {
        return new CharsJsonIterator(buf, head, tail);
    }

    public static JsonIterator parse(String field) {
        return JsonIterator.parse(field.getBytes());
    }

    public static JsonIterator parse(String field, int charBufferLength) {
        return JsonIterator.parse(field.getBytes(), charBufferLength);
    }

    public static boolean fieldEquals(String field, char[] buf) {
        return JsonIterator.fieldEquals(field, buf, 0, buf.length);
    }

    public static boolean fieldEquals(String field, char[] buf, int len) {
        return JsonIterator.fieldEquals(field, buf, 0, len);
    }

    public static boolean fieldEquals(String field, char[] buf, int offset, int len) {
        if (field.length() != len) {
            return false;
        }
        int i = 0;
        int j = offset;
        while (i < len) {
            if (field.charAt(i) != buf[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean fieldStartsWith(String field, char[] buf, int offset, int len) {
        int to = field.length();
        if (to > len) {
            return false;
        }
        int i = 0;
        int j = offset;
        while (i < to) {
            if (field.charAt(i) != buf[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean fieldEqualsIgnoreCase(String field, char[] buf) {
        return JsonIterator.fieldEqualsIgnoreCase(field, buf, 0, buf.length);
    }

    public static boolean fieldEqualsIgnoreCase(String field, char[] buf, int len) {
        return JsonIterator.fieldEqualsIgnoreCase(field, buf, 0, len);
    }

    public static boolean fieldEqualsIgnoreCase(String field, char[] buf, int offset, int len) {
        if (field.length() != len) {
            return false;
        }
        int i = 0;
        int j = offset;
        while (i < len) {
            char d;
            char c = field.charAt(i);
            if (c != (d = buf[j]) && Character.toLowerCase((int)c) != d && Character.toUpperCase((int)c) != d) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean fieldStartsWithIgnoreCase(String field, char[] buf, int offset, int len) {
        int to = field.length();
        if (to > len) {
            return false;
        }
        int i = 0;
        int j = offset;
        while (i < to) {
            char d;
            char c = field.charAt(i);
            if (c != (d = buf[j]) && Character.toLowerCase((int)c) != d && Character.toUpperCase((int)c) != d) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean fieldEndsWith(String field, char[] buf, int offset, int len) {
        int i = field.length();
        if (i > len) {
            return false;
        }
        int j = offset + len;
        while (--i >= 0) {
            if (field.charAt(i) == buf[--j]) continue;
            return false;
        }
        return true;
    }

    public static boolean fieldEndsWithIgnoreCase(String field, char[] buf, int offset, int len) {
        int i = field.length();
        if (i > len) {
            return false;
        }
        int j = offset + len;
        while (--i >= 0) {
            char d;
            char c = field.charAt(i);
            if (c == (d = buf[--j]) || Character.toLowerCase((int)c) == d || Character.toUpperCase((int)c) == d) continue;
            return false;
        }
        return true;
    }

    public JsonIterator reset(int var1);

    public JsonIterator reset(byte[] var1);

    public JsonIterator reset(byte[] var1, int var2, int var3);

    public JsonIterator reset(char[] var1);

    public JsonIterator reset(char[] var1, int var2, int var3);

    public JsonIterator reset(InputStream var1);

    public JsonIterator reset(InputStream var1, int var2);

    public String currentBuffer();

    public boolean supportsMarkReset();

    public int mark();

    public ValueType whatIsNext();

    public boolean readArray();

    public JsonIterator openArray();

    public JsonIterator continueArray();

    public JsonIterator closeArray();

    default public String readObject() {
        return this.readObjField();
    }

    public String readObjField();

    public JsonIterator skipObjField();

    public JsonIterator skipUntil(String var1);

    public JsonIterator closeObj();

    public JsonIterator skip();

    default public JsonIterator skipRestOfObject() {
        while (this.skipObjField() != null) {
            this.skip();
        }
        return this;
    }

    default public JsonIterator skipRestOfArray() {
        while (this.readArray()) {
            this.skip();
        }
        return this;
    }

    public boolean readNull();

    public String readString();

    public byte[] decodeBase64String();

    public String readNumberAsString();

    public String readNumberOrNumberString();

    public boolean readBoolean();

    public short readShort();

    public int readInt();

    public long readLong();

    public float readFloat();

    public double readDouble();

    public BigDecimal readBigDecimal();

    @Deprecated
    default public BigDecimal readBigDecimalStripTrailingZeroes() {
        return this.readBigDecimalDropZeroes();
    }

    public BigDecimal readBigDecimalDropZeroes();

    public long readUnscaledAsLong(int var1);

    public BigInteger readBigInteger();

    public Instant readDateTime();

    public <R> R applyChars(CharBufferFunction<R> var1);

    public <C, R> R applyChars(C var1, ContextCharBufferFunction<C, R> var2);

    public <R> R applyNumberChars(CharBufferFunction<R> var1);

    public <C, R> R applyNumberChars(C var1, ContextCharBufferFunction<C, R> var2);

    public int applyCharsAsInt(CharBufferToIntFunction var1);

    public <C> int applyCharsAsInt(C var1, ContextCharBufferToIntFunction<C> var2);

    public int applyNumberCharsAsInt(CharBufferToIntFunction var1);

    public <C> int applyNumberCharsAsInt(C var1, ContextCharBufferToIntFunction<C> var2);

    public long applyCharsAsLong(CharBufferToLongFunction var1);

    public <C> long applyCharsAsLong(C var1, ContextCharBufferToLongFunction<C> var2);

    public long applyNumberCharsAsLong(CharBufferToLongFunction var1);

    public <C> long applyNumberCharsAsLong(C var1, ContextCharBufferToLongFunction<C> var2);

    public boolean testChars(CharBufferPredicate var1);

    public <C> boolean testChars(C var1, ContextCharBufferPredicate<C> var2);

    public void consumeChars(CharBufferConsumer var1);

    public <C> void consumeChars(C var1, ContextCharBufferConsumer<C> var2);

    public boolean testObjField(CharBufferPredicate var1);

    public <R> R applyObjField(CharBufferFunction<R> var1);

    public <C, R> R applyObject(C var1, ContextFieldBufferFunction<C, R> var2);

    public int applyObjFieldAsInt(CharBufferToIntFunction var1, int var2);

    public long applyObjFieldAsLong(CharBufferToLongFunction var1, long var2);

    public <C> int applyObjFieldAsInt(C var1, ContextCharBufferToIntFunction<C> var2, int var3);

    public <C> long applyObjFieldAsLong(C var1, ContextCharBufferToLongFunction<C> var2, long var3);

    public <R> R applyObject(FieldBufferFunction<R> var1);

    public <C> C testObject(C var1, ContextFieldBufferPredicate<C> var2);

    public void testObject(FieldBufferPredicate var1);

    public <C> C testObject(C var1, ContextFieldBufferMaskedPredicate<C> var2);
}

