/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.EdECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.PublicKeyBytes;
import software.sava.core.accounts.Signer;
import software.sava.core.crypto.SunCrypto;

final class KeyPairSigner
implements Signer {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private final Signature signature;

    KeyPairSigner(byte[] publicKey, byte[] privateKey) {
        this(new PublicKeyBytes(publicKey), KeyPairSigner.generatePrivateKey(privateKey));
    }

    KeyPairSigner(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.signature = KeyPairSigner.createSignature(this.privateKey);
    }

    static PrivateKey generatePrivateKey(byte[] privateKey) {
        try {
            EdECPrivateKeySpec privateKeySpec = new EdECPrivateKeySpec(NamedParameterSpec.ED25519, privateKey);
            return SunCrypto.EdDSA_KEY_FACTORY.generatePrivate(privateKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyPairSigner(PublicKey publicKey, PrivateKey privateKey, Signature signature) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.signature = signature;
    }

    private static Signature createSignature(PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(NamedParameterSpec.ED25519.getName(), SunCrypto.SUN_EC_PROVIDER);
            signature.initSign(privateKey);
            return signature;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PublicKey publicKey() {
        return this.publicKey;
    }

    @Override
    public PrivateKey privateKey() {
        return this.privateKey;
    }

    @Override
    public Signer createDedicatedSigner() {
        return new KeyPairSigner(this.publicKey, this.privateKey, KeyPairSigner.createSignature(this.privateKey));
    }

    @Override
    public int sign(byte[] message, int msgOffset, int msgLen, int outPos) {
        try {
            this.signature.update(message, msgOffset, msgLen);
            this.signature.sign(message, outPos, 64);
            return outPos + 64;
        }
        catch (SignatureException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public byte[] sign(byte[] message, int msgOffset, int msgLen) {
        try {
            this.signature.update(message, msgOffset, msgLen);
            return this.signature.sign();
        }
        catch (SignatureException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public byte[] sign(byte[] message) {
        return this.sign(message, 0, message.length);
    }
}

