/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts;

import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import software.sava.core.accounts.PublicKey;
import software.sava.core.encoding.Base58;

final class PublicKeyBytes
implements PublicKey {
    static final byte[] PDA_BYTES = "ProgramDerivedAddress".getBytes();
    private final byte[] publicKey;
    private String base58PublicKey;
    private int hashCode;

    PublicKeyBytes(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    static byte[] createBuffer(List<byte[]> seeds, boolean nonce, PublicKey programId) {
        if (seeds.size() > 16) {
            throw new IllegalArgumentException(String.format("Maximum number of seeds [%d] exceeded. Given [%d].", 16, seeds.size()));
        }
        int bufLength = nonce ? 1 : 0;
        for (byte[] seed : seeds) {
            int len = seed.length;
            if (len > 32) {
                throw new IllegalArgumentException(String.format("Seed [%s] exceeds maximum length of [%d].", new String(seed), 32));
            }
            bufLength += len;
        }
        byte[] buffer = new byte[bufLength + 32 + PDA_BYTES.length];
        int from = 0;
        for (byte[] seed : seeds) {
            System.arraycopy(seed, 0, buffer, from, seed.length);
            from += seed.length;
        }
        from = bufLength;
        from += programId.write(buffer, from);
        System.arraycopy(PDA_BYTES, 0, buffer, from, PDA_BYTES.length);
        return buffer;
    }

    @Override
    public byte[] toByteArray() {
        return this.publicKey;
    }

    @Override
    public byte[] copyByteArray() {
        return Arrays.copyOf(this.publicKey, this.publicKey.length);
    }

    @Override
    public int write(byte[] out, int off) {
        System.arraycopy(this.publicKey, 0, out, off, 32);
        return 32;
    }

    @Override
    public String toBase58() {
        if (this.base58PublicKey == null) {
            this.base58PublicKey = Base58.encode(this.publicKey);
        }
        return this.base58PublicKey;
    }

    @Override
    public String toBase64() {
        return Base64.getEncoder().encodeToString(this.publicKey);
    }

    public String toString() {
        return this.toBase58();
    }

    @Override
    public int compareTo(PublicKey o) {
        if (o instanceof PublicKeyBytes) {
            PublicKeyBytes publicKeyBytes = (PublicKeyBytes)o;
            return Arrays.compare(this.publicKey, 0, 32, publicKeyBytes.publicKey, 0, 32);
        }
        return -o.compareTo(this);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.publicKey);
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PublicKeyBytes) {
            PublicKeyBytes _publicKey = (PublicKeyBytes)o;
            return Arrays.equals(this.publicKey, _publicKey.publicKey);
        }
        return o != null && o.equals(this);
    }
}

