/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts;

import java.security.PrivateKey;
import java.util.Arrays;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import software.sava.core.accounts.KeyPairSigner;
import software.sava.core.accounts.PublicKey;
import software.sava.core.crypto.SunCrypto;
import software.sava.core.crypto.ed25519.Ed25519Util;
import software.sava.core.encoding.Base58;

public interface Signer {
    public static final int KEY_LENGTH = 32;

    public static byte[] generatePrivateKeyBytes() {
        byte[] privateKey = new byte[32];
        SunCrypto.SECURE_RANDOM.nextBytes(privateKey);
        return privateKey;
    }

    public static void validateKeyPair(byte[] privateKey, byte[] expectedPublicKey) {
        byte[] publicKey = new byte[32];
        Ed25519.generatePublicKey((byte[])privateKey, (int)0, (byte[])publicKey, (int)0);
        if (!Arrays.equals(expectedPublicKey, publicKey)) {
            throw new IllegalStateException(String.format("%s <> %s", Base58.encode(expectedPublicKey), Base58.encode(publicKey)));
        }
        if (!Ed25519.validatePublicKeyFull((byte[])publicKey, (int)0)) {
            throw new IllegalStateException("Invalid public key " + Base58.encode(publicKey));
        }
    }

    public static void validateKeyPair(byte[] keyPair) {
        byte[] publicKey = new byte[32];
        byte[] privateKey = Arrays.copyOfRange(keyPair, 0, 32);
        Ed25519Util.generatePublicKey(privateKey, publicKey);
        if (!Ed25519.validatePublicKeyFull((byte[])publicKey, (int)0)) {
            throw new IllegalStateException("Invalid public key " + Base58.encode(publicKey));
        }
        if (!Arrays.equals(keyPair, 32, 64, publicKey, 0, 32)) {
            throw new IllegalStateException(String.format("%s <> %s", Base58.encode(keyPair, 32, 64), Base58.encode(publicKey)));
        }
    }

    public static byte[] generatePrivateKeyPairBytes() {
        byte[] privateKey = new byte[32];
        SunCrypto.SECURE_RANDOM.nextBytes(privateKey);
        byte[] keyPair = new byte[64];
        Ed25519Util.generatePublicKey(privateKey, 0, keyPair, 32);
        System.arraycopy(privateKey, 0, keyPair, 0, 32);
        Signer.validateKeyPair(keyPair);
        return keyPair;
    }

    public static byte[] createKeyPairBytesFromPrivateKey(byte[] privateKey) {
        byte[] keyPair = new byte[64];
        Ed25519Util.generatePublicKey(privateKey, 0, keyPair, 32);
        System.arraycopy(privateKey, 0, keyPair, 0, 32);
        Signer.validateKeyPair(keyPair);
        return keyPair;
    }

    public static Signer createFromPrivateKey(byte[] privateKey) {
        byte[] copiedPrivateKey = Arrays.copyOfRange(privateKey, 0, 32);
        byte[] publicKey = new byte[32];
        Ed25519Util.generatePublicKey(copiedPrivateKey, 0, publicKey, 0);
        Signer.validateKeyPair(copiedPrivateKey, publicKey);
        return new KeyPairSigner(publicKey, copiedPrivateKey);
    }

    public static Signer createFromKeyPair(byte[] keyPair) {
        byte[] privateKey = Arrays.copyOfRange(keyPair, 0, 32);
        byte[] publicKey = Arrays.copyOfRange(keyPair, 32, 64);
        Signer.validateKeyPair(privateKey, publicKey);
        return new KeyPairSigner(publicKey, privateKey);
    }

    public static Signer createFromKeyPair(byte[] publicKey, byte[] privateKey) {
        Signer.validateKeyPair(privateKey, publicKey);
        byte[] copiedPrivateKey = Arrays.copyOfRange(privateKey, 0, 32);
        return new KeyPairSigner(Arrays.copyOfRange(publicKey, 0, 32), copiedPrivateKey);
    }

    public static Signer createFromKeyPair(PublicKey publicKey, PrivateKey privateKey) {
        return new KeyPairSigner(publicKey, privateKey);
    }

    public PublicKey publicKey();

    public PrivateKey privateKey();

    public Signer createDedicatedSigner();

    public int sign(byte[] var1, int var2, int var3, int var4);

    public byte[] sign(byte[] var1, int var2, int var3);

    public byte[] sign(byte[] var1);
}

