/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.lookup;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.lookup.AddressLookupTableRoot;
import software.sava.core.accounts.lookup.AddressLookupTableWithReverseLookup;
import software.sava.core.encoding.ByteUtil;

final class AddressLookupTableOverlay
extends AddressLookupTableRoot {
    AddressLookupTableOverlay(PublicKey address, byte[] data) {
        super(address, data);
    }

    @Override
    public byte[] discriminator() {
        byte[] discriminator = new byte[4];
        System.arraycopy(this.data, 0, discriminator, 0, 4);
        return discriminator;
    }

    @Override
    public long deactivationSlot() {
        return ByteUtil.getInt64LE(this.data, 4);
    }

    @Override
    public long lastExtendedSlot() {
        return ByteUtil.getInt64LE(this.data, 12);
    }

    @Override
    public int lastExtendedSlotStartIndex() {
        return this.data[20] & 0xFF;
    }

    @Override
    public PublicKey authority() {
        return this.data[21] == 0 ? null : PublicKey.readPubKey(this.data, 22);
    }

    @Override
    public AddressLookupTable withReverseLookup() {
        int numAccounts = this.numAccounts();
        PublicKey[] accounts = new PublicKey[numAccounts];
        HashMap<PublicKey, Integer> distinctAccounts = HashMap.newHashMap(numAccounts);
        int i = 0;
        int to = this.data.length;
        for (int from = 56; from < to; from += 32) {
            PublicKey pubKey = PublicKey.readPubKey(this.data, from);
            distinctAccounts.putIfAbsent(pubKey, i);
            accounts[i] = pubKey;
            ++i;
        }
        return new AddressLookupTableWithReverseLookup(this.address, this.discriminator(), this.deactivationSlot(), this.lastExtendedSlot(), this.lastExtendedSlotStartIndex(), this.authority(), distinctAccounts, accounts, this.data);
    }

    @Override
    public Set<PublicKey> uniqueAccounts() {
        int numAccounts = this.numAccounts();
        HashSet<PublicKey> distinctAccounts = HashSet.newHashSet(numAccounts);
        int i = 0;
        int to = this.data.length;
        for (int from = 56; from < to; from += 32) {
            distinctAccounts.add(PublicKey.readPubKey(this.data, from));
            ++i;
        }
        return distinctAccounts;
    }

    @Override
    public int numUniqueAccounts() {
        return this.uniqueAccounts().size();
    }

    @Override
    public PublicKey account(int index) {
        return PublicKey.readPubKey(this.data, 56 + (index << 5));
    }

    @Override
    public int indexOf(PublicKey publicKey) {
        byte[] bytes = publicKey.toByteArray();
        int from = 56;
        int to = from + 32;
        int numAccounts = this.numAccounts();
        for (int i = 0; i < numAccounts; ++i) {
            if (Arrays.equals(bytes, 0, 32, this.data, from, to)) {
                return i;
            }
            from = to;
            to += 32;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public byte indexOfOrThrow(PublicKey publicKey) {
        int index = this.indexOf(publicKey);
        if (index < 0) {
            throw new IllegalStateException(String.format("Could not find %s in lookup table.", publicKey.toBase58()));
        }
        return (byte)index;
    }

    @Override
    public int numAccounts() {
        return this.data.length - 56 >> 5;
    }

    @Override
    protected String keysToString() {
        int to = this.data.length;
        return IntStream.iterate(56, i -> i < to, i -> i + 32).mapToObj(i -> PublicKey.readPubKey(this.data, i)).map(PublicKey::toBase58).collect(Collectors.joining(", ", "[", "]"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof AddressLookupTableOverlay)) return false;
        AddressLookupTableOverlay overlay = (AddressLookupTableOverlay)obj;
        if (!this.address.equals(overlay.address)) return false;
        if (!Arrays.equals(this.data, 0, this.data.length, overlay.data, 0, overlay.data.length)) return false;
        return true;
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

