/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.lookup;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.lookup.AddressLookupTableRoot;

final class AddressLookupTableWithReverseLookup
extends AddressLookupTableRoot {
    private final byte[] discriminator;
    private final long deactivationSlot;
    private final long lastExtendedSlot;
    private final int lastExtendedSlotStartIndex;
    private final PublicKey authority;
    private final Map<PublicKey, Integer> distinctAccounts;
    private final PublicKey[] accounts;
    private static final Integer NOT_PRESENT = -1;

    AddressLookupTableWithReverseLookup(PublicKey address, byte[] discriminator, long deactivationSlot, long lastExtendedSlot, int lastExtendedSlotStartIndex, PublicKey authority, Map<PublicKey, Integer> distinctAccounts, PublicKey[] accounts, byte[] data) {
        super(address, data);
        this.discriminator = discriminator;
        this.deactivationSlot = deactivationSlot;
        this.lastExtendedSlot = lastExtendedSlot;
        this.lastExtendedSlotStartIndex = lastExtendedSlotStartIndex;
        this.authority = authority;
        this.accounts = accounts;
        this.distinctAccounts = distinctAccounts;
    }

    @Override
    public AddressLookupTable withReverseLookup() {
        return this;
    }

    @Override
    public PublicKey account(int index) {
        return this.accounts[index];
    }

    @Override
    public boolean containKey(PublicKey publicKey) {
        return this.distinctAccounts.containsKey(publicKey);
    }

    @Override
    public int indexOf(PublicKey publicKey) {
        return this.distinctAccounts.getOrDefault(publicKey, NOT_PRESENT);
    }

    @Override
    public byte indexOfOrThrow(PublicKey publicKey) {
        int index = this.indexOf(publicKey);
        if (index < 0) {
            throw new IllegalStateException(String.format("Could not find %s in lookup table.", publicKey.toBase58()));
        }
        return (byte)index;
    }

    @Override
    public int numAccounts() {
        return this.accounts.length;
    }

    @Override
    public int numUniqueAccounts() {
        return this.distinctAccounts.size();
    }

    @Override
    public Set<PublicKey> uniqueAccounts() {
        return Collections.unmodifiableSet(this.distinctAccounts.keySet());
    }

    @Override
    public byte[] discriminator() {
        return this.discriminator;
    }

    @Override
    public long deactivationSlot() {
        return this.deactivationSlot;
    }

    @Override
    public long lastExtendedSlot() {
        return this.lastExtendedSlot;
    }

    @Override
    public int lastExtendedSlotStartIndex() {
        return this.lastExtendedSlotStartIndex;
    }

    @Override
    public PublicKey authority() {
        return this.authority;
    }

    @Override
    protected String keysToString() {
        return Arrays.toString(this.accounts);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AddressLookupTableWithReverseLookup) {
            AddressLookupTableWithReverseLookup that = (AddressLookupTableWithReverseLookup)obj;
            return this.address.equals(that.address) && Arrays.equals(this.discriminator, that.discriminator) && this.deactivationSlot == that.deactivationSlot && this.lastExtendedSlot == that.lastExtendedSlot && this.lastExtendedSlotStartIndex == that.lastExtendedSlotStartIndex && Objects.equals(this.authority, that.authority) && Arrays.equals(this.accounts, that.accounts);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

