/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.meta;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.meta.AccountMetaFeePayer;
import software.sava.core.accounts.meta.AccountMetaInvoked;
import software.sava.core.accounts.meta.AccountMetaReadOnly;
import software.sava.core.accounts.meta.AccountMetaReadOnlySigner;
import software.sava.core.accounts.meta.AccountMetaSignerWriter;
import software.sava.core.accounts.meta.AccountMetaWrite;

public sealed interface AccountMeta
permits AccountMetaReadOnly {
    public static final IntFunction<AccountMeta[]> ACCOUNT_META_ARRAY_GENERATOR = AccountMeta[]::new;
    public static final List<AccountMeta> NO_KEYS = List.of();
    public static final Function<PublicKey, AccountMeta> CREATE_INVOKED = AccountMeta::createInvoked;
    public static final Function<PublicKey, AccountMeta> CREATE_READ = AccountMeta::createRead;
    public static final Function<PublicKey, AccountMeta> CREATE_WRITE = AccountMeta::createWrite;
    public static final Function<PublicKey, AccountMeta> CREATE_READ_ONLY_SIGNER = AccountMeta::createReadOnlySigner;
    public static final Function<PublicKey, AccountMeta> CREATE_WRITE_SIGNER = AccountMeta::createWritableSigner;
    public static final Function<PublicKey, AccountMeta> CREATE_FEE_PAYER = AccountMeta::createFeePayer;

    public static AccountMeta createInvoked(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        return new AccountMetaInvoked(publicKey);
    }

    public static AccountMeta createRead(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        return new AccountMetaReadOnly(publicKey);
    }

    public static AccountMeta createWrite(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        return new AccountMetaWrite(publicKey);
    }

    public static AccountMeta createReadOnlySigner(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        return new AccountMetaReadOnlySigner(publicKey);
    }

    public static AccountMeta createWritableSigner(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        return new AccountMetaSignerWriter(publicKey);
    }

    public static AccountMeta createFeePayer(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        return new AccountMetaFeePayer(publicKey);
    }

    public static Map<PublicKey, AccountMeta> createAccountsMap(int numAccounts, PublicKey feePayer) {
        HashMap<PublicKey, AccountMeta> accounts = HashMap.newHashMap(numAccounts);
        AccountMeta feePayerMeta = AccountMeta.createFeePayer(feePayer);
        accounts.put(feePayer, feePayerMeta);
        return accounts;
    }

    public static AccountMeta createMeta(PublicKey account, boolean writable, boolean signer) {
        if (signer) {
            return writable ? AccountMeta.createWritableSigner(account) : AccountMeta.createReadOnlySigner(account);
        }
        if (writable) {
            return AccountMeta.createWrite(account);
        }
        return AccountMeta.createRead(account);
    }

    public static AccountMeta createMeta(PublicKey account, boolean invoked, boolean feePayer, boolean writable, boolean signer) {
        if (invoked) {
            return AccountMeta.createInvoked(account);
        }
        if (feePayer) {
            return AccountMeta.createFeePayer(account);
        }
        return AccountMeta.createMeta(account, writable, signer);
    }

    public PublicKey publicKey();

    public boolean signer();

    public boolean write();

    public boolean feePayer();

    public boolean invoked();

    public AccountMeta merge(AccountMeta var1);
}

