/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.meta;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.AccountMetaFeePayer;
import software.sava.core.accounts.meta.AccountMetaInvoked;
import software.sava.core.accounts.meta.AccountMetaInvokedAndWrite;
import software.sava.core.accounts.meta.AccountMetaReadOnlySigner;
import software.sava.core.accounts.meta.AccountMetaSignerWriter;
import software.sava.core.accounts.meta.AccountMetaWrite;

sealed class AccountMetaReadOnly
implements AccountMeta
permits AccountMetaFeePayer, AccountMetaInvoked, AccountMetaInvokedAndWrite, AccountMetaReadOnlySigner, AccountMetaSignerWriter, AccountMetaWrite {
    protected final PublicKey publicKey;

    AccountMetaReadOnly(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public final PublicKey publicKey() {
        return this.publicKey;
    }

    @Override
    public boolean feePayer() {
        return false;
    }

    @Override
    public boolean signer() {
        return false;
    }

    @Override
    public boolean write() {
        return false;
    }

    @Override
    public boolean invoked() {
        return false;
    }

    @Override
    public AccountMeta merge(AccountMeta accountMeta) {
        return accountMeta;
    }

    public boolean equals(Object o) {
        return this == o || o.getClass() == AccountMetaReadOnly.class && this.publicKey.equals(((AccountMetaReadOnly)o).publicKey);
    }

    public int hashCode() {
        return this.publicKey.hashCode();
    }

    public final String toString() {
        return "{\n  \"publicKey\": \"%s\",\n  \"feePayer\": %b,\n  \"signer\": %b,\n  \"writable\": %b,\n  \"invoked\": %b\n}".formatted(this.publicKey.toBase58(), this.feePayer(), this.signer(), this.write(), this.invoked());
    }
}

