/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.sysvar;

import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;

public record Clock(PublicKey address, long slot, long epochStartTimestamp, long epoch, long leaderScheduleEpoch, long unixTimestamp) implements Borsh
{
    public static final long MAX_SLOT = -1L;
    public static final int BYTES = 40;
    public static final BiFunction<PublicKey, byte[], Clock> FACTORY = Clock::read;

    public static Clock read(byte[] data) {
        return Clock.read(data, 0);
    }

    public static Clock read(byte[] data, int offset) {
        return Clock.read(null, data, offset);
    }

    public static Clock read(PublicKey address, byte[] data) {
        return Clock.read(address, data, 0);
    }

    public static Clock read(PublicKey address, byte[] data, int offset) {
        long slot = ByteUtil.getInt64LE(data, offset);
        long epochStartTimestamp = ByteUtil.getInt64LE(data, offset += 8);
        long epoch = ByteUtil.getInt64LE(data, offset += 8);
        long leaderScheduleEpoch = ByteUtil.getInt64LE(data, offset += 8);
        long unixTimestamp = ByteUtil.getInt64LE(data, offset += 8);
        return new Clock(address, slot, epochStartTimestamp, epoch, leaderScheduleEpoch, unixTimestamp);
    }

    @Override
    public int write(byte[] data, int offset) {
        int i = offset;
        ByteUtil.putInt64LE(data, i, this.slot);
        ByteUtil.putInt64LE(data, i += 8, this.epochStartTimestamp);
        ByteUtil.putInt64LE(data, i += 8, this.epoch);
        ByteUtil.putInt64LE(data, i += 8, this.leaderScheduleEpoch);
        ByteUtil.putInt64LE(data, i += 8, this.unixTimestamp);
        return (i += 8) - offset;
    }

    @Override
    public int l() {
        return 40;
    }
}

